<?php
// ARQUIVO: /api/acao_filmes.php
// IMPORTANTE: Este arquivo deve ficar DENTRO da pasta 'api'

header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");

// 1. Captura os dados enviados pelo JavaScript
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

$acao = $input['acao'] ?? '';
$ids = $input['ids'] ?? [];
$categoryId = $input['category_id'] ?? 0;

// Validação básica
if (empty($ids) || !is_array($ids)) {
    echo json_encode(['success' => false, 'error' => 'Nenhum filme selecionado ou dados inválidos.']);
    exit;
}

// Garante que os IDs são números
$ids = array_map('intval', $ids);
$ids = array_filter($ids);

if (empty($ids)) {
    echo json_encode(['success' => false, 'error' => 'IDs inválidos.']);
    exit;
}

try {
    // 2. Conecta ao Banco de Dados
    // Procura o arquivo db.php em locais comuns
    $db_paths = [
        __DIR__ . '/controles/db.php',      // Se estiver em api/acao_filmes.php
        __DIR__ . '/../api/controles/db.php', // Fallback
        $_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php' // Caminho absoluto
    ];

    $db_found = false;
    foreach ($db_paths as $path) {
        if (file_exists($path)) {
            require_once($path);
            $db_found = true;
            break;
        }
    }

    if (!$db_found) {
        throw new Exception("Arquivo de banco de dados (db.php) não encontrado.");
    }

    $pdo = conectar_bd();
    if (!$pdo) {
        throw new Exception("Falha na conexão com o banco de dados.");
    }

    // 3. Executa a Ação (Excluir ou Mover)
    if ($acao === 'excluir') {
        
        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        
        // Deleta da tabela 'streams' (onde ficam os filmes)
        $sql = "DELETE FROM streams WHERE id IN ($placeholders)";
        $stmt = $pdo->prepare($sql);
        
        if ($stmt->execute($ids)) {
            echo json_encode(['success' => true, 'message' => count($ids) . ' filmes excluídos com sucesso!']);
        } else {
            throw new Exception("O banco de dados recusou a exclusão.");
        }

    } elseif ($acao === 'mover') {
        
        if (empty($categoryId)) throw new Exception("Categoria inválida.");

        $placeholders = implode(',', array_fill(0, count($ids), '?'));
        $sql = "UPDATE streams SET category_id = ? WHERE id IN ($placeholders)";
        
        // Coloca o ID da categoria no início
        $params = array_merge([$categoryId], $ids);
        $stmt = $pdo->prepare($sql);
        
        if ($stmt->execute($params)) {
            echo json_encode(['success' => true, 'message' => 'Filmes movidos com sucesso!']);
        } else {
            throw new Exception("Erro ao mover filmes.");
        }

    } else {
        throw new Exception("Ação desconhecida.");
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>