<?php
// api/acoes_excluir.php

// 1. CONFIGURAES DE DEPURAO
// Se der erro, vai mostrar na tela ao invs de ficar branco
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json; charset=utf-8');
session_start();

try {
    // 2. CONEXO COM O BANCO
    // Como estamos na pasta "api" e o banco em "api/controles", o caminho  direto:
    $caminho_banco = __DIR__ . '/controles/db.php';

    if (file_exists($caminho_banco)) {
        require_once $caminho_banco;
    } else {
        throw new Exception("Arquivo de banco no encontrado em: " . $caminho_banco);
    }

    if (!function_exists('conectar_bd')) {
        throw new Exception("O arquivo foi carregado, mas a funo 'conectar_bd' no existe nele.");
    }

    $pdo = conectar_bd();

    if (!$pdo) {
        throw new Exception("Falha ao conectar no Banco de Dados (retorno vazio).");
    }

    // 3. EXECUO DA LIMPEZA
    // Verifica se foi chamado corretamente
    $action = $_POST['action'] ?? '';

    // Teste de acesso direto pelo navegador
    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        echo json_encode([
            'status' => 'error', 
            'message' => 'API Conectada com Sucesso! O caminho do banco est certo. Agora use o boto no painel.'
        ]);
        exit;
    }

    if ($action === 'excluir_listas') {
        $daterange = $_POST['daterange'] ?? '';
        $tipos = $_POST['tipos'] ?? [];

        if (empty($daterange) || empty($tipos)) {
            throw new Exception("Faltam dados: Selecione datas e tipos.");
        }

        // Processa Datas
        $dates = explode(' - ', $daterange);
        if (count($dates) < 2) throw new Exception("Formato de data incorreto.");

        $d1 = DateTime::createFromFormat('d/m/Y', trim($dates[0]));
        $d2 = DateTime::createFromFormat('d/m/Y', trim($dates[1]));

        if (!$d1 || !$d2) throw new Exception("Datas invlidas.");

        $inicio = $d1->format('Y-m-d 00:00:00');
        $fim = $d2->format('Y-m-d 23:59:59');

        $condicoes = [];
        $params = [];

        // Filtro: Testes Vencidos
        if (in_array('testes', $tipos)) {
            $condicoes[] = "(is_trial = 1 AND Vencimento < NOW() AND criado_em BETWEEN ? AND ?)";
            $params[] = $inicio;
            $params[] = $fim;
        }

        // Filtro: Clientes Vencidos
        if (in_array('expiradas', $tipos)) {
            $condicoes[] = "(is_trial = 0 AND Vencimento < NOW() AND Vencimento BETWEEN ? AND ?)";
            $params[] = $inicio;
            $params[] = $fim;
        }

        if (empty($condicoes)) throw new Exception("Nenhum filtro selecionado.");

        $sql = "DELETE FROM clientes WHERE " . implode(' OR ', $condicoes);
        $stmt = $pdo->prepare($sql);
        
        if ($stmt->execute($params)) {
            $qtd = $stmt->rowCount();
            echo json_encode(['status' => 'success', 'message' => "Sucesso! {$qtd} contas foram apagadas."]);
        } else {
            $err = $stmt->errorInfo();
            throw new Exception("Erro SQL ao deletar: " . $err[2]);
        }

    } else {
        throw new Exception("Ao desconhecida: " . $action);
    }

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
?>