<?php
// ======================================================================
// ### ARQUIVO: api/api_config_confianca.php (NOVO ARQUIVO) ###
// ======================================================================
session_start();
header('Content-Type: application/json; charset=utf-8');

// Ajuste o caminho se o seu 'db.php' nao estiver um nivel acima
require_once('../db.php'); 

// Protecao: Somente o admin principal pode salvar
if (!isset($_SESSION['admin_id'])) {
     echo json_encode(['title' => 'Erro!', 'msg' => 'Sessao expirada.', 'icon' => 'error']);
     exit;
}

$admin_id = $_SESSION['admin_id'];

try {
    $conexao = conectar_bd();
    
    // Verifica se o usuario e o admin principal (admin = 1)
    $stmt_check = $conexao->prepare("SELECT admin FROM admin WHERE id = ?");
    $stmt_check->execute([$admin_id]);
    $user = $stmt_check->fetch(PDO::FETCH_ASSOC);

    if (!$user || $user['admin'] != 1) {
        echo json_encode(['title' => 'Erro!', 'msg' => 'Voce nao tem permissao para esta acao.', 'icon' => 'error']);
        exit;
    }

    // Se for o admin e estiver salvando...
    if (isset($_POST['salvar_configuracoes'])) {
        $confianca_ativo = isset($_POST['confianca_ativo']) ? (int)$_POST['confianca_ativo'] : 1;
        $confianca_dias = isset($_POST['confianca_dias']) ? (int)$_POST['confianca_dias'] : 2;
        
        $confianca_ativo = ($confianca_ativo === 1) ? 1 : 0;
        $confianca_dias = max(1, min(7, $confianca_dias)); // Limita entre 1 e 7 dias

        $sql = "UPDATE admin SET confianca_ativo = ?, confianca_dias = ? WHERE id = ?";
        $stmt = $conexao->prepare($sql);
        $stmt->execute([$confianca_ativo, $confianca_dias, $admin_id]);
        
        echo json_encode(['title' => 'Sucesso!', 'msg' => 'Configuracoes salvas.', 'icon' => 'success']);
        exit;
    }

} catch (PDOException $e) {
    error_log("Erro em api/api_config_confianca.php: " . $e->getMessage());
    echo json_encode(['title' => 'Erro!', 'msg' => 'Nao foi possivel salvar no banco de dados.', 'icon' => 'error']);
    exit;
}
?>