<?php
// ARQUIVO: /api/api_mass_link_update.php
set_time_limit(0); 
header('Content-Type: application/json');
session_start();

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado.']);
    exit;
}

require_once('controles/db.php');
$pdo = conectar_bd();

$action = $_POST['action'] ?? '';
$search = $_POST['search_from'] ?? '';
$replace = $_POST['replace_with'] ?? '';
$tables = json_decode($_POST['tables'] ?? '[]', true); 

if (empty($search)) {
    echo json_encode(['success' => false, 'message' => 'Termo de busca vazio.']);
    exit;
}

// --- CONFIGURAÇÃO BLINDADA (BASEADA NO SEU PRINT) ---

// 1. Tabela STREAMS (Canais e Filmes)
// Seu print provou: O link está na coluna 'link' e o nome está em 'name'.
$col_link_streams = 'link'; 
$col_nome_streams = 'name';

// 2. Tabela SERIES_EPISODES (Episódios)
// Como não vimos o print, vamos testar as 3 mais comuns para garantir.
$col_link_series = 'url'; // Tenta 'url' primeiro
try {
    $pdo->query("SELECT link FROM series_episodes LIMIT 1");
    $col_link_series = 'link'; // Se 'link' existir, usa ela
} catch (Exception $e) {
    try {
        $pdo->query("SELECT remote_url FROM series_episodes LIMIT 1");
        $col_link_series = 'remote_url';
    } catch (Exception $e2) {}
}
$col_nome_series = 'title'; // Padrãozão de episódios

// --- Definição do que processar ---
$processar_streams = []; 
$processar_series = false; 

if (in_array('canais', $tables)) $processar_streams[] = "'live'";
if (in_array('filmes', $tables)) $processar_streams[] = "'movie'";

// Só processa séries se achou a coluna válida
if (in_array('series', $tables)) {
    $processar_series = true;
}

if (empty($processar_streams) && !$processar_series) {
    echo json_encode(['success' => false, 'message' => 'Selecione uma categoria válida.']);
    exit;
}

try {
    // =================================================================================
    // AÇÃO: PREVIEW
    // =================================================================================
    if ($action === 'preview') {
        $total = 0;
        $exemplos = [];

        // A. Busca em Streams (Canais e Filmes)
        if (!empty($processar_streams)) {
            $typesStr = implode(',', $processar_streams);
            
            // Conta quantos tem o link antigo
            $sqlCount = "SELECT COUNT(*) FROM streams WHERE stream_type IN ($typesStr) AND `$col_link_streams` LIKE :search";
            $stmt = $pdo->prepare($sqlCount);
            $stmt->execute([':search' => '%' . $search . '%']);
            $total += $stmt->fetchColumn();

            // Pega exemplos para mostrar na tela
            $sqlEx = "SELECT id, `$col_nome_streams` as name, `$col_link_streams` as link, stream_type as type 
                      FROM streams 
                      WHERE stream_type IN ($typesStr) AND `$col_link_streams` LIKE :search 
                      LIMIT 3";
            $stmtEx = $pdo->prepare($sqlEx);
            $stmtEx->execute([':search' => '%' . $search . '%']);
            
            foreach($stmtEx->fetchAll(PDO::FETCH_ASSOC) as $row) {
                $tipoLabel = ($row['type'] == 'live') ? 'CANAL' : 'FILME';
                $novoLink = str_replace($search, $replace, $row['link']);
                $exemplos[] = [
                    'name' => "[$tipoLabel] " . $row['name'], // Usa a coluna 'name' do seu print
                    'old_url' => $row['link'],                 // Usa a coluna 'link' do seu print
                    'new_url' => $novoLink
                ];
            }
        }

        // B. Busca em Séries (Se solicitado)
        if ($processar_series) {
            $sqlCount = "SELECT COUNT(*) FROM series_episodes WHERE `$col_link_series` LIKE :search";
            $stmt = $pdo->prepare($sqlCount);
            $stmt->execute([':search' => '%' . $search . '%']);
            $total += $stmt->fetchColumn();

            $limit = (count($exemplos) > 0) ? 2 : 5;
            $sqlEx = "SELECT id, `$col_nome_series` as name, `$col_link_series` as link 
                      FROM series_episodes 
                      WHERE `$col_link_series` LIKE :search 
                      LIMIT $limit";
            $stmtEx = $pdo->prepare($sqlEx);
            $stmtEx->execute([':search' => '%' . $search . '%']);

            foreach($stmtEx->fetchAll(PDO::FETCH_ASSOC) as $row) {
                $novoLink = str_replace($search, $replace, $row['link']);
                $exemplos[] = [
                    'name' => "[EPISÓDIO] " . $row['name'],
                    'old_url' => $row['link'],
                    'new_url' => $novoLink
                ];
            }
        }

        echo json_encode([
            'success' => true,
            'total_items' => $total,
            'examples' => $exemplos
        ]);

    // =================================================================================
    // AÇÃO: EXECUTE
    // =================================================================================
    } elseif ($action === 'execute') {
        $afetados = 0;

        // Atualiza Streams
        if (!empty($processar_streams)) {
            $typesStr = implode(',', $processar_streams);
            $sqlUpdate = "UPDATE streams SET `$col_link_streams` = REPLACE(`$col_link_streams`, :search, :replace) 
                          WHERE stream_type IN ($typesStr) AND `$col_link_streams` LIKE :search_like";
            $stmt = $pdo->prepare($sqlUpdate);
            $stmt->execute([
                ':search' => $search,
                ':replace' => $replace,
                ':search_like' => '%' . $search . '%'
            ]);
            $afetados += $stmt->rowCount();
        }

        // Atualiza Séries
        if ($processar_series) {
            $sqlUpdate = "UPDATE series_episodes SET `$col_link_series` = REPLACE(`$col_link_series`, :search, :replace) 
                          WHERE `$col_link_series` LIKE :search_like";
            $stmt = $pdo->prepare($sqlUpdate);
            $stmt->execute([
                ':search' => $search,
                ':replace' => $replace,
                ':search_like' => '%' . $search . '%'
            ]);
            $afetados += $stmt->rowCount();
        }

        echo json_encode([
            'success' => true,
            'main_links_updated' => $afetados
        ]);
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro Geral: ' . $e->getMessage()]);
}
?>