<?php
// /api/chatbot_office_api.php
// VERSO FINAL COM TRATAMENTO DE ERROS E LGICA CORRETA

session_start();
header('Content-Type: application/json; charset=UTF-8');

// Bloco de tratamento de erros para capturar qualquer falha (como um arquivo faltando)
try {
    // Inclui a conexo com o banco de dados e o arquivo de funes
    require_once(__DIR__ . '/../api/controles/db.php');
    // CORREO: Alterado o nome do arquivo conforme solicitado.
    require_once(__DIR__ . '/../chatbot_gerar_teste_final2.php');

    // --- CONFIGURAES ---
    $plano_padrao_para_teste = 73; // Plano "teste 1" pertencente ao admin ID 11
    $duracao_padrao_horas = 3;
    $dominio_servidor = "http://" . $_SERVER['HTTP_HOST'];

    /**
     * Funo para encapsular a resposta e terminar o script.
     */
    function responder($mensagem = "") {
        die(json_encode(["data" => [["message" => $mensagem]]], JSON_UNESCAPED_UNICODE));
    }

    // --- PROCESSAMENTO DA REQUISIO ---
    $data = json_decode(file_get_contents('php://input'), true);
    $key = $_GET['key'] ?? '';

    if (empty($key)) {
        responder("Identificador invlido.");
    }

    // Valida o token e busca os dados do admin
    $admin = getUserByChatbotToken($key);
    if (!$admin) {
        responder("Identificador no encontrado.");
    }

    // Inicia uma sesso vlida para o admin
    $_SESSION['admin_id'] = $admin['id'];
    $_SESSION['token'] = $admin['token'];

    $userMessage = $data['senderMessage'] ?? '';
    if (empty(trim($userMessage))) {
        die(); // Termina se a mensagem do usurio estiver vazia
    }

    // Busca as regras do chatbot para este admin
    $chatbotRules = getAllChatbotRulesByAdmin($admin['id']);

    // --- LGICA DO CHATBOT ---
    foreach ($chatbotRules as $rule) {
        if ($rule["status"] != 1) continue;

        foreach ($rule["messages"] as $message) {
            $match = false;
            // Verifica se a mensagem do usurio corresponde  regra
            if (($rule["rule_type"] === "equals" && strtolower($message) === strtolower($userMessage)) || 
                ($rule["rule_type"] === "contains" && stripos(strtolower($userMessage), strtolower($message)) !== false)) {
                $match = true;
            }

            if ($match) {
                $response_message = "";
                // Se a ao for criar um teste de IPTV
                if ($rule["rule_action"] === 'test_iptv') {
                    $usuario_teste = strtolower(substr(str_shuffle("abcdefghijklmnopqrstuvwxyz0123456789"), 0, 8));
                    $senha_teste = strtolower(substr(str_shuffle("abcdefghijklmnopqrstuvwxyz0123456789"), 0, 6));

                    // Chama a funo correta de 'chatbot_gerar_teste_final2.php'
                    $resultado_criacao = confirme_adicionar_testes(
                        'Teste via Chatbot',      // name
                        $usuario_teste,           // usuario
                        $senha_teste,             // senha
                        1,                        // conexoes
                        $plano_padrao_para_teste, // plano_id
                        null, null, null,         // revendedor, categoria, forma_pgto
                        'Cliente Chatbot',        // obs
                        null, null, null, null,   // whatsapp, mac, key, id
                        $duracao_padrao_horas     // horas
                    );

                    if (isset($resultado_criacao['icon']) && $resultado_criacao['icon'] === 'success') {
                        $vencimento = date('d/m/Y H:i', strtotime("+$duracao_padrao_horas hours"));
                        $link_m3u_completo = "{$dominio_servidor}/get.php?username={$usuario_teste}&password={$senha_teste}&type=m3u_plus&output=ts";
                        $link_ssiptv_encurtado = "{$dominio_servidor}/ss-ts/{$usuario_teste}/{$senha_teste}";
                        
                        $response_message = "*Seu teste foi gerado com sucesso!* \n\n";
                        $response_message .= "*DADOS DE ACESSO:*\n";
                        $response_message .= "*Usuario:* " . $usuario_teste . "\n";
                        $response_message .= "*Senha:* " . $senha_teste . "\n";
                        $response_message .= "*Vencimento:* " . $vencimento . "\n\n";
                        $response_message .= "*URL para App XCIPTV:* \nhttp://topipv.brtvs.top:8080\n\n";
                        $response_message .= "*LISTAS:* \n";
                        $response_message .= "*Lista M3U (Completa):* \n" . $link_m3u_completo . "\n\n";
                        $response_message .= "*Lista SSIPTV (Encurtada):* \n" . $link_ssiptv_encurtado;
                        $response_message .= "\n\n*Obrigado pela preferencia*, *TOP IPTV*";
                    } else {
                        // Se a criao falhar, envia a mensagem de erro da funo
                        $response_message = "Desculpe, nao foi possivel gerar seu teste. Motivo: " . ($resultado_criacao['msg'] ?? 'Erro desconhecido no painel.');
                    }
                } else {
                    // Se a ao for uma resposta de texto simples
                    $response_message = $rule["response"];
                }
                
                incrementChatbotRuleRuns($rule["id"]);
                responder($response_message);
            }
        }
    }

} catch (Throwable $e) {
    // Se ocorrer um erro fatal (como um arquivo faltando ou erro de sintaxe), ele ser capturado aqui.
    error_log("Erro fatal na API do Chatbot: " . $e->getMessage() . " no arquivo " . $e->getFile() . " na linha " . $e->getLine());
    // Responde com uma mensagem genrica para o usurio final
    die(json_encode(["data" => [["message" => "Ocorreu um erro crtico no servidor. Por favor, contate o suporte."]]], JSON_UNESCAPED_UNICODE));
}
?>

