<?php
// Arquivo: /api/clientes.php
// VERSÃO FINAL - CORRIGIDA PARA CONTAR APENAS IPTV OFICIAL

// Limpa lixo de buffer
ob_start();
session_start();
require_once('controles/db.php');
ob_clean(); 

header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['error' => 'Sessão expirada']);
    exit;
}

$pdo = conectar_bd();
$admin_id = $_SESSION['admin_id'];

// --- GET ---

if (isset($_GET['acao']) && $_GET['acao'] == 'obter_contagens') {
    $agora = date("Y-m-d H:i:s");
    
    // 1. Verifica se é Admin Master ou Revenda
    $u = $pdo->query("SELECT admin FROM admin WHERE id = $admin_id")->fetch();
    $filtro_dono = "";
    
    // Se NÃO for admin master (admin=1), aplica o filtro pelo ID dele
    if (!$u || $u['admin'] != 1) {
        $filtro_dono = " AND admin_id = $admin_id ";
    }

    // 2. Filtro fundamental: APENAS IPTV (Sem P2P e Sem Testes)
    $filtro_tipo = " AND is_trial = 0 AND is_p2p = 0 ";

    // 3. Monta as consultas com os filtros corretos
    
    // Ativos: Não banido, Vencimento futuro, Tipo IPTV, Filtro de Dono
    $sql_ativos = "SELECT COUNT(*) FROM clientes WHERE is_banned=0 AND Vencimento >= '$agora' $filtro_tipo $filtro_dono";
    
    // Vencidos: Não banido, Vencimento passado, Tipo IPTV, Filtro de Dono
    $sql_vencidos = "SELECT COUNT(*) FROM clientes WHERE is_banned=0 AND Vencimento < '$agora' $filtro_tipo $filtro_dono";
    
    // Bloqueados: Banido, Tipo IPTV, Filtro de Dono
    $sql_bloq = "SELECT COUNT(*) FROM clientes WHERE is_banned=1 $filtro_tipo $filtro_dono";
    
    echo json_encode([
        'ativos' => $pdo->query($sql_ativos)->fetchColumn(),
        'vencidos' => $pdo->query($sql_vencidos)->fetchColumn(),
        'bloqueados' => $pdo->query($sql_bloq)->fetchColumn()
    ]);
    exit;
}

if (isset($_GET['acao']) && $_GET['acao'] == 'listar_revendedores') {
    $stmt = $pdo->query("SELECT id, user FROM admin WHERE admin = 0 ORDER BY user");
    echo json_encode(['data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
    exit;
}

// --- LISTAGEM (Chama a função corrigida do erro HY093) ---
if (isset($_REQUEST['listar_clientes'])) {
    require_once('controles/funcoes_clientes.php');
    echo json_encode(listar_clientes($_REQUEST));
    exit;
}

// --- POST (Botões) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once('controles/funcoes_clientes.php');
    
    // Tenta descobrir qual a ação
    $action = $_POST['action'] ?? null;
    
    // Se não veio 'action', pega a primeira chave (padrão antigo)
    if (!$action) {
        foreach ($_POST as $key => $value) {
            if ($key != 'id' && function_exists($key)) {
                $action = $key;
                break;
            }
        }
    }

    if ($action && function_exists($action)) {
        // Se for confirmação (form submit), manda o POST todo
        if (strpos($action, 'confirme_') === 0) {
            echo json_encode($action($_POST));
        } 
        // Se for abrir modal, manda o ID
        else {
            $id = $_POST['id'] ?? $_POST[$action] ?? null;
            echo json_encode($action($id));
        }
    } else {
        echo json_encode(['title'=>'Erro', 'msg'=>'Ação não identificada', 'icon'=>'error']);
    }
    exit;
}
?>