<?php
// Arquivo: /api/clientes.php
// VERSÃO 17 - CORREÇÃO DE COMPATIBILIDADE PHP
// Esta versão é compatível com PHP 5.6+ e usa a lógica validada pelo teste.

ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();

// Dependência básica (só o banco de dados)
require_once('controles/db.php');

// Verificação de segurança
if (!isset($_SESSION['admin_id'])) {
    die(json_encode(['title' => 'Erro de Acesso!', 'msg' => 'Sessão expirada. Faça login novamente.', 'icon' => 'error', 'data' => []]));
}

header('Content-Type: application/json; charset=utf-8');

// =================================================================
// ROTEADOR DE AÇÕES
// =================================================================

// --- BLOCO DE CONTAGEM (ISOLADO) ---
if (isset($_GET['acao']) && $_GET['acao'] == 'obter_contagens') {
    
    $pdo = conectar_bd(); 
    $resposta = ['ativos' => 0, 'vencidos' => 0, 'bloqueados' => 0];

    try {
        if ($pdo === null) {
             throw new Exception("Não foi possível conectar ao banco de dados.");
        }
        
        $admin_id = $_SESSION['admin_id'];
        $agora_php_formatado = date("Y-m-d H:i:s"); 
        $filtro_base_sql = " AND admin_id = :admin_id AND is_trial = 0 AND is_p2p = 0";
        $params_base = [':admin_id' => $admin_id];

        // 1. Clientes BLOQUEADOS
        $sql_bloqueados = "SELECT COUNT(*) FROM clientes WHERE is_banned = 1" . $filtro_base_sql;
        $query_bloqueados = $pdo->prepare($sql_bloqueados);
        $query_bloqueados->execute($params_base);
        $cont_bloqueados = $query_bloqueados->fetchColumn();

        // 2. Clientes ATIVOS
        $sql_ativos = "SELECT COUNT(*) FROM clientes WHERE (is_banned IS NULL OR is_banned = 0) AND Vencimento >= :agora" . $filtro_base_sql;
        $query_ativos = $pdo->prepare($sql_ativos);
        $query_ativos->execute(array_merge($params_base, [':agora' => $agora_php_formatado]));
        $cont_ativos = $query_ativos->fetchColumn();

        // 3. Clientes VENCIDOS (Expirado)
        $sql_vencidos = "SELECT COUNT(*) FROM clientes WHERE (is_banned IS NULL OR is_banned = 0) AND Vencimento < :agora" . $filtro_base_sql;
        $query_vencidos = $pdo->prepare($sql_vencidos);
        $query_vencidos->execute(array_merge($params_base, [':agora' => $agora_php_formatado]));
        $cont_vencidos = $query_vencidos->fetchColumn();
        
        $resposta = [
            'ativos' => $cont_ativos,
            'vencidos' => $cont_vencidos,
            'bloqueados' => $cont_bloqueados
        ];

    } catch (Exception $e) {
        $msg = $e->getMessage();
        $msg_limpa = str_replace(dirname(__FILE__), '...', $msg);
        $resposta = ['title' => 'Erro de BD!', 'msg' => 'Não foi possível buscar as contagens. Erro: ' . $msg_limpa, 'icon' => 'error'];
    }

    echo json_encode($resposta);
    exit; 
}

// --- SE NÃO FOR 'obter_contagens', CARREGA AS OUTRAS FUNÇÕES ---
require_once('controles/funcoes_clientes.php');

// --- LÓGICA PARA LISTAR CLIENTES NA TABELA (DATATABLES) ---
if (isset($_GET['listar_clientes'])) {
    
    if (function_exists('listar_clientes')) {
        $dados_requisicao = $_REQUEST;
        $resultado = listar_clientes($dados_requisicao);
        echo json_encode($resultado);
    } else {
        echo json_encode(['title' => 'Erro Crítico!', 'msg' => 'Função listar_clientes() não encontrada.', 'icon' => 'error', 'data' => []]);
    }
    exit();
}

// --- LÓGICA PARA REQUISIÇÕES POST ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // --- AÇÕES EM MASSA ---
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'delete_multiple':
                $ids = isset($_POST['ids']) ? $_POST['ids'] : []; 
                if (!empty($ids) && is_array($ids) && function_exists('confirme_delete_cliente')) {
                    $deleted_count = 0;
                    foreach ($ids as $id) {
                        $result = confirme_delete_cliente(['confirme_delete_cliente' => intval($id)]);
                        if (isset($result['icon']) && $result['icon'] === 'success') {
                            $deleted_count++;
                        }
                    }
                    if ($deleted_count > 0) {
                        echo json_encode(['title' => 'Sucesso!', 'msg' => "$deleted_count clientes foram excluídos.", 'icon' => 'success']);
                    } else {
                        echo json_encode(['title' => 'Erro!', 'msg' => 'Nenhum cliente foi excluído.', 'icon' => 'error']);
                    }
                }
                exit();

            case 'renew_multiple':
                $ids = isset($_POST['ids']) ? $_POST['ids'] : [];
                $meses = isset($_POST['meses']) ? intval($_POST['meses']) : 0;
                if (!empty($ids) && is_array($ids) && $meses > 0 && function_exists('confirme_renovar_cliente')) {
                    $updated_count = 0;
                    $failed_count = 0;
                    foreach ($ids as $id) {
                        $result = confirme_renovar_cliente([
                            'confirme_renovar_cliente' => intval($id),
                            'meses' => $meses
                        ]);
                        if (isset($result['icon']) && $result['icon'] === 'success') {
                            $updated_count++;
                        } else {
                            $failed_count++;
                        }
                    }
                    if ($updated_count > 0) {
                        $msg = "$updated_count clientes foram renovados.";
                        if ($failed_count > 0) { $msg .= " Falha ao renovar $failed_count."; }
                        echo json_encode(['title' => 'Sucesso!', 'msg' => $msg, 'icon' => 'success']);
                    } else {
                        echo json_encode(['title' => 'Erro!', 'msg' => 'Não foi possível renovar os clientes.', 'icon' => 'error']);
                    }
                }
                exit();
        }
    }

    // --- AÇÕES INDIVIDUAIS ---
    // Correção PHP 5.6 (Substitui array_key_first)
    reset($_POST);
    $action = key($_POST);

    if ($action && function_exists($action)) {
        if (strpos($action, 'confirme_') === 0) {
             $params = $_POST;
             echo json_encode($action($params));
        } else {
            $value = isset($_POST[$action]) ? $_POST[$action] : null; 
            echo json_encode($action($value)); 
        }
    } else {
        echo json_encode(['title' => 'Erro!', 'msg' => 'Ação POST não reconhecida.', 'icon' => 'error']);
    }
    exit();
}

// Resposta padrão
echo json_encode(['title' => 'Erro!', 'msg' => 'Requisição inválida.', 'icon' => 'error']);
?>
