<?php
// Desativa a exibio de erros para no quebrar o JSON
ini_set('display_errors', 0);
error_reporting(0);

// Define o cabealho como JSON imediatamente
header('Content-Type: application/json');

// ===================================================================
// ? CORREO: Adiciona um try...catch principal para apanhar
// erros fatais (ex: falha ao incluir db.php ou ao conectar)
// ===================================================================
try {
    session_start();
    
    // ===================================================================
    // ? CORREO DE DEBUG: Verifica se o db.php existe ANTES de o incluir
    // ===================================================================
    $db_path = 'db.php';
    if (!file_exists($db_path)) {
        http_response_code(500);
        echo json_encode([
            'status' => 'error', 
            'message' => 'Erro Fatal no Servidor: O arquivo \'db.php\' no foi encontrado na pasta \'api/controles/\'.'
        ]);
        exit;
    }
    
    // Garante que este script est na mesma pasta (api/controles/) que o db.php
    require_once($db_path); 

    // Proteo MXIMA: Apenas o admin Nvel 1 pode executar isto.
    if (!isset($_SESSION['nivel_admin']) || $_SESSION['nivel_admin'] != 1) {
        http_response_code(403); // Forbidden
        echo json_encode(['status' => 'error', 'message' => 'Acesso negado. Apenas o administrador master pode executar esta ao.']);
        exit;
    }

    $data = json_decode(file_get_contents('php://input'), true);

    if (empty($data['action'])) {
        http_response_code(400); // Bad Request
        echo json_encode(['status' => 'error', 'message' => 'Nenhuma ao especificada.']);
        exit;
    }

    // Tenta conectar-se ao BD. Se db.php falhar, isto ser apanhado pelo catch
    $conexao = conectar_bd();

    switch ($data['action']) {
        
        // Caso para a ao 'limpar_tudo'
        case 'limpar_tudo':
            // ===================================================================
            // ? CORREO: Removida a lgica de transao (beginTransaction, commit, rollBack)
            // TRUNCATE no funciona bem com transaes InnoDB.
            // ===================================================================
            try {
                $conexao->exec("SET FOREIGN_KEY_CHECKS = 0;");
                $conexao->exec("TRUNCATE TABLE streams;");
                $conexao->exec("TRUNCATE TABLE series;");
                $conexao->exec("TRUNCATE TABLE series_episodes;");
                $conexao->exec("TRUNCATE TABLE series_seasons;");
                $conexao->exec("TRUNCATE TABLE categoria;");
                $conexao->exec("SET FOREIGN_KEY_CHECKS = 1;");
                
                echo json_encode(['status' => 'success', 'message' => 'Tabelas limpas com sucesso.']);
                
            } catch (Exception $e) {
                // Se falhar (ex: tabela no existe), restaura as chaves estrangeiras
                $conexao->exec("SET FOREIGN_KEY_CHECKS = 1;"); 
                
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Erro de Banco de Dados: ' . $e->getMessage()]);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Ao desconhecida.']);
            break;
    }

} catch (Throwable $e) {
    // ? CORREO: Apanha erros fatais (ex: conectar_bd() no existe ou falhou)
    http_response_code(500); // Internal Server Error
    echo json_encode([
        'status' => 'error', 
        'message' => 'Erro Fatal no Servidor PHP: ' . $e->getMessage()
    ]);
}
?>

