<?php
// Arquivo: /api/controles/funcoes_revendedores.php
// VERSÃO CORRIGIDA: Admin vê todos os revendedores

// Limpeza de segurança
if (ob_get_level() == 0) ob_start();
error_reporting(0);
ini_set('display_errors', 0);

// ======================================================================
// ### LISTAGEM ###
// ======================================================================
function listar_revendedores($req) {
    if (ob_get_length()) ob_clean();
    
    try {
        $conexao = conectar_bd();
        $admin_id = $_SESSION['admin_id'];
        
        // 1. VERIFICA SE É ADMIN MASTER
        $stmt_check = $conexao->prepare("SELECT admin FROM `admin` WHERE id = ?");
        $stmt_check->execute([$admin_id]);
        $currentUser = $stmt_check->fetch(PDO::FETCH_ASSOC);
        $isMaster = ($currentUser && $currentUser['admin'] == 1);

        // 2. DEFINE A LÓGICA DO FILTRO
        $params = [];
        
        if ($isMaster) {
            // SE FOR DONO: Vê todos que não são admins (ou seja, vê todas as revendas)
            $where = " WHERE admin = 0 ";
        } else {
            // SE FOR REVENDA: Vê apenas quem ele criou (Sub-revendas)
            $where = " WHERE criado_por = :meu_id AND admin = 0 ";
            $params[':meu_id'] = $admin_id;
        }

        // Filtro Dropdown (Se selecionou alguém específico)
        if (!empty($req['filtro_revenda'])) {
            $where .= " AND id = :filtro_id ";
            $params[':filtro_id'] = $req['filtro_revenda'];
        }

        // Pesquisa (Campo de busca)
        if (!empty($req['search']['value'])) {
            $termo = "%" . $req['search']['value'] . "%";
            $where .= " AND user LIKE :search ";
            $params[':search'] = $termo;
        }

        // Contagem Total (para paginação)
        $stmt_total = $conexao->prepare("SELECT COUNT(id) FROM `admin` " . $where);
        $stmt_total->execute($params);
        $total = $stmt_total->fetchColumn();

        // Ordenação e Limite
        $colunas = [0=>'id', 1=>'user', 2=>'creditos'];
        $ordem = $req['order'][0]['dir'] ?? 'desc';
        $limit = intval($req['length'] ?? 10);
        $offset = intval($req['start'] ?? 0);

        // Query Principal
        $sql = "SELECT id, user as usuario, creditos, 
                (SELECT COUNT(id) FROM clientes WHERE admin_id = a.id) as total_clientes 
                FROM `admin` a " . $where . " ORDER BY id $ordem LIMIT $limit OFFSET $offset";
        
        $stmt = $conexao->prepare($sql);
        $stmt->execute($params);

        $dados = [];
        while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $id = $row['id'];
            $api = "/api/revendedores.php?id=$id"; 
            
            // Botões de Ação (Mobile Friendly)
            $btns = "<div class='btn-group' style='white-space: nowrap;'>";
            $btns .= "<button class='btn btn-sm btn-outline-success mx-1' onclick='modal_master(\"$api\", \"add_creditos\", \"$id\")' title='Créditos'><i class='fas fa-coins'></i></button>";
            $btns .= "<button class='btn btn-sm btn-outline-primary mx-1' onclick='modal_master(\"$api\", \"edite_revendedor\", \"$id\")' title='Editar'><i class='fas fa-edit'></i></button>";
            $btns .= "<button class='btn btn-sm btn-outline-danger mx-1' onclick='modal_master(\"$api\", \"delete_revendedor\", \"$id\")' title='Excluir'><i class='fas fa-trash-alt'></i></button>";
            $btns .= "</div>";

            $dados[] = [
                "id" => $id,
                "usuario" => htmlspecialchars($row['usuario'], ENT_QUOTES),
                "creditos" => ($row['creditos'] > 0) 
                    ? "<span class='badge bg-success'>{$row['creditos']}</span>" 
                    : "<span class='badge bg-danger'>{$row['creditos']}</span>",
                "clientes" => $row['total_clientes'],
                "acao" => $btns
            ];
        }

        return ["draw"=>intval($req['draw']), "recordsTotal"=>$total, "recordsFiltered"=>$total, "data"=>$dados];

    } catch (Exception $e) {
        return ["draw"=>0, "recordsTotal"=>0, "recordsFiltered"=>0, "data"=>[], "error"=>$e->getMessage()];
    }
}

// ======================================================================
// ### HELPER ID ###
// ======================================================================
function get_id_url($id_param) {
    if (!empty($_GET['id'])) return (int)$_GET['id'];
    if (!empty($id_param) && $id_param != 0) return (int)$id_param;
    if (!empty($_REQUEST['id'])) return (int)$_REQUEST['id'];
    return 0;
}

// ======================================================================
// ### EXCLUIR ###
// ======================================================================
function delete_revendedor($id) {
    if (ob_get_length()) ob_clean();
    $id = get_id_url($id);
    
    if ($id == 0) return ['modal_titulo'=>"Erro", 'modal_body'=>"Erro: ID não encontrado.", 'modal_footer'=>""];

    $pdo = conectar_bd();
    $r = $pdo->query("SELECT user FROM `admin` WHERE id=$id")->fetch();
    $nome = $r ? $r['user'] : 'usuário';
    
    $form_id = "formDel_" . time();

    $html = "<form id='$form_id'>
                <input type='hidden' name='acao' value='confirme_delete_revendedor'>
                <input type='hidden' name='id' value='$id'>
                <div class='text-center text-danger p-3'>
                    <h4>ATENÇÃO!</h4>
                    <p>Deseja excluir <b>$nome</b>?</p>
                    <p class='small'>Isso apagará todos os clientes dele.</p>
                </div>
             </form>";
    
    $url_destino = "/api/revendedores.php?id=$id";
    $ft = "<button class='btn btn-danger' onclick='enviarFormulario(\"$form_id\", \"$url_destino\")'>SIM, EXCLUIR</button>";
    return ['modal_titulo'=>"Excluir", 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_delete_revendedor($p) {
    try {
        $pdo = conectar_bd();
        $id_rev = 0;
        if (!empty($_REQUEST['id'])) $id_rev = (int)$_REQUEST['id'];
        elseif (!empty($p['id'])) $id_rev = (int)$p['id'];

        if ($id_rev <= 0) return ['title'=>'Erro', 'msg'=>"ID Inválido.", 'icon'=>'error'];

        $pdo->beginTransaction();
        $pdo->prepare("DELETE FROM credits_log WHERE admin_id = ? OR target_id = ?")->execute([$id_rev, $id_rev]);
        $pdo->prepare("DELETE FROM clientes WHERE admin_id = ?")->execute([$id_rev]);
        $pdo->prepare("DELETE FROM planos WHERE admin_id = ?")->execute([$id_rev]);
        $pdo->prepare("DELETE FROM `admin` WHERE id = ?")->execute([$id_rev]);
        $pdo->commit();
        
        return ['title'=>'Sucesso', 'msg'=>'Revendedor excluído!', 'icon'=>'success', 'data_table'=>'atualizar'];
    } catch (Exception $e) {
        $pdo->rollBack();
        return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error'];
    }
}

// ======================================================================
// ### CRÉDITOS ###
// ======================================================================
function add_creditos($id) {
    if (ob_get_length()) ob_clean();
    $id = get_id_url($id);

    $pdo = conectar_bd();
    $r = $pdo->query("SELECT user, creditos FROM `admin` WHERE id=$id")->fetch();
    $user_nome = $r ? $r['user'] : 'Revendedor';

    $form_id = "formCred_" . time();
    $html = "<form id='$form_id'>
                <input type='hidden' name='acao' value='confirme_add_creditos'>
                <input type='hidden' name='id' value='$id'>
                <div class='form-group'>
                    <label>Créditos para <b>$user_nome</b>:</label>
                    <input type='number' name='creditos' class='form-control' value='1'>
                </div>
             </form>";
    
    $url_destino = "/api/revendedores.php?id=$id";
    $ft = "<button class='btn btn-success' onclick='enviarFormulario(\"$form_id\", \"$url_destino\")'>Confirmar</button>";
    return ['modal_titulo'=>"Créditos", 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_add_creditos($p) {
    try {
        $pdo = conectar_bd();
        $id_rev = 0;
        if (!empty($_REQUEST['id'])) $id_rev = (int)$_REQUEST['id'];
        elseif (!empty($p['id'])) $id_rev = (int)$p['id'];

        $qtd = (int)$p['creditos'];
        $meu_id = $_SESSION['admin_id'];
        $eu = $pdo->query("SELECT admin, creditos FROM `admin` WHERE id=$meu_id")->fetch();
        
        // Se não for admin, verifica se tem saldo para dar
        if ($eu['admin'] != 1 && $qtd > 0 && $eu['creditos'] < $qtd) {
            return ['title'=>'Erro', 'msg'=>'Saldo insuficiente.', 'icon'=>'error'];
        }

        // Adiciona ao revendedor
        $pdo->prepare("UPDATE `admin` SET creditos = creditos + ? WHERE id = ?")->execute([$qtd, $id_rev]);
        
        // Se não for admin, remove do saldo dele
        if ($eu['admin'] != 1 && $qtd > 0) {
            $pdo->prepare("UPDATE `admin` SET creditos = creditos - ? WHERE id = ?")->execute([$qtd, $meu_id]);
        }

        $alvo = $pdo->query("SELECT user FROM `admin` WHERE id=$id_rev")->fetch();
        $acao = $qtd > 0 ? "adicionado(s)" : "removido(s)";
        $msg = "✅ *Operação de Créditos Concluída!*\n\nOlá, {$alvo['user']}!\nFoi $acao *" . abs($qtd) . " credito* em sua conta.";

        return ['title'=>'Sucesso', 'msg'=>'Atualizado!', 'icon'=>'success', 'data_table'=>'atualizar', 'dados_operacao_msg'=>$msg];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}

// ======================================================================
// ### EDIÇÃO ###
// ======================================================================
function edite_revendedor($id) {
    if (ob_get_length()) ob_clean();
    $id = get_id_url($id);
    
    $pdo = conectar_bd();
    $admin_id = $_SESSION['admin_id'];
    
    $r = $pdo->query("SELECT * FROM `admin` WHERE id=$id")->fetch();
    
    $meu_plano = $pdo->query("SELECT plano FROM `admin` WHERE id=$admin_id")->fetchColumn();
    $stmt = $pdo->prepare("SELECT id, nome FROM planos_admin WHERE id < ? ORDER BY id");
    $stmt->execute([$meu_plano ?: 1]);
    $opts = ""; 
    while($p = $stmt->fetch()) {
        $sel = ($r['plano'] == $p['id']) ? 'selected' : '';
        $opts .= "<option value='{$p['id']}' $sel>{$p['nome']}</option>";
    }

    $form_id = "formEdit_" . time();
    $html = "<form id='$form_id'>
                <input type='hidden' name='acao' value='confirme_edite_revendedor'>
                <input type='hidden' name='id' value='$id'>
                <div class='row'>
                    <div class='col-6 mb-2'><label>Usuário</label><input type='text' name='usuario' value='{$r['user']}' class='form-control'></div>
                    <div class='col-6 mb-2'><label>Senha (vazio = manter)</label><input type='password' name='senha' class='form-control'></div>
                    <div class='col-12 mb-2'><label>WhatsApp</label><input type='text' name='whatsapp' value='{$r['whatsapp']}' class='form-control'></div>
                    <div class='col-12 mb-2'><label>Plano</label><select name='plano' class='form-select'>$opts</select></div>
                </div>
             </form>";
    
    $url_destino = "/api/revendedores.php?id=$id";
    $ft = "<button class='btn btn-primary' onclick='enviarFormulario(\"$form_id\", \"$url_destino\")'>Salvar</button>";
    return ['modal_titulo'=>"Editar", 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_edite_revendedor($p) {
    $pdo = conectar_bd();
    $id = 0;
    if (!empty($_REQUEST['id'])) $id = (int)$_REQUEST['id'];
    elseif (!empty($p['id'])) $id = (int)$p['id'];

    if(!empty($p['senha'])) {
        $pdo->prepare("UPDATE `admin` SET user=?, pass=?, whatsapp=?, plano=? WHERE id=?")->execute([$p['usuario'], $p['senha'], $p['whatsapp'], $p['plano'], $id]);
    } else {
        $pdo->prepare("UPDATE `admin` SET user=?, whatsapp=?, plano=? WHERE id=?")->execute([$p['usuario'], $p['whatsapp'], $p['plano'], $id]);
    }
    return ['title'=>'Sucesso', 'msg'=>'Dados atualizados', 'icon'=>'success', 'data_table'=>'atualizar'];
}

// ======================================================================
// ### CRIAR ###
// ======================================================================
function add_revendedor($id=0) { 
    if (ob_get_length()) ob_clean();
    $pdo = conectar_bd();
    $id_adm = $_SESSION['admin_id'];
    $meu_plano = $pdo->query("SELECT plano FROM `admin` WHERE id=$id_adm")->fetchColumn();
    
    $stmt = $pdo->prepare("SELECT id, nome FROM planos_admin WHERE id < ? ORDER BY id");
    $stmt->execute([$meu_plano ?: 1]);
    $opts = ""; 
    while($p = $stmt->fetch()) {
        $opts .= "<option value='{$p['id']}'>{$p['nome']}</option>";
    }
    if(empty($opts)) $opts = "<option value='1'>Padrão</option>";

    $html = '<form id="formAddRev"><input type="hidden" name="acao" value="confirme_add_revendedor">
             <div class="row">
                <div class="col-6 mb-2"><label>Usuário</label><input type="text" name="usuario" class="form-control" required></div>
                <div class="col-6 mb-2"><label>Senha</label><input type="text" name="senha" class="form-control" required></div>
                <div class="col-6 mb-2"><label>WhatsApp</label><input type="text" name="whatsapp" class="form-control"></div>
                <div class="col-6 mb-2"><label>Email</label><input type="email" name="email" class="form-control"></div>
                <div class="col-6 mb-2"><label>Plano</label><select name="plano" class="form-select">'.$opts.'</select></div>
                <div class="col-6 mb-2"><label>Créditos Iniciais</label><input type="number" name="creditos" value="0" class="form-control"></div>
             </div></form>';
    
    $ft = "<button class='btn btn-success' onclick='enviarFormulario(\"formAddRev\", \"/api/revendedores.php\")'>Criar</button>";
    return ['modal_titulo'=>"Novo Revendedor", 'modal_body'=>$html, 'modal_footer'=>$ft];
}

function confirme_add_revendedor($p) {
    try {
        $pdo = conectar_bd();
        $sql = "INSERT INTO `admin` (user, pass, admin, creditos, criado_por, plano, whatsapp, email, data_criado) VALUES (?,?,0,?,?,?,?,?,NOW())";
        $pdo->prepare($sql)->execute([$p['usuario'], $p['senha'], $p['creditos'], $_SESSION['admin_id'], $p['plano'], $p['whatsapp'], $p['email']]);
        
        $link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
        $msg = "Seja bem-vindo(a) à Top IPTV! 🚀\n\nSeguem seus dados de acesso ao painel de revenda:\n\n🔗 Link do Painel: $link\n👤 Usuário: {$p['usuario']}\n🔑 Senha: {$p['senha']}\n\nSua conta foi iniciada com {$p['creditos']} crédito(s).";
        
        return ['title'=>'Sucesso', 'msg'=>'Criado!', 'icon'=>'success', 'data_table'=>'atualizar', 'dados_revendedor_msg'=>$msg];
    } catch(Exception $e) { return ['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']; }
}
?>