<?php
// Arquivo: /api/controles/funcoes_revendedores.php
// VERSÃO LIMPA
// - REMOVIDO: 'header()' e 'ini_set' do topo (isto causava o erro "Não foi possível carregar o modal")
// - CORRIGIDO: Todos os 'onclick' agora apontam para '/api/revendedores.php'
// - CORRIGIDO: 'enviardados' mudado para 'enviarFormulario'
// - CORRIGIDO: 'confirme_add_revendedor' para não inserir 'is_banned' ou 'status' (colunas não existem)

// ======================================================================
// ### FUNÇÃO PARA LISTAR REVENDEDORES ###
// ======================================================================
function listar_revendedores($dados_requisicao) {
    try {
        $conexao = conectar_bd();
        try { $conexao->exec("SET NAMES 'utf8mb4'"); } catch (PDOException $e) { /*...*/ }
        $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
        if ($admin_id === null) {
            return ["draw" => 0, "recordsTotal" => 0, "recordsFiltered" => 0, "data" => [], "error" => "Erro de Sessao."];
        }

        $sql = "SELECT a.id, a.user as usuario, a.creditos, (SELECT COUNT(id) FROM clientes WHERE admin_id = a.id) as qnt_clientes FROM admin a WHERE a.criado_por = :admin_id";
        $stmt = $conexao->prepare($sql);
        $stmt->execute([':admin_id' => $admin_id]);

        $dados = [];
        while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $id = $row['id'];
            $acoes = "<div class='btn-group' role='group'>";
            $api_path = '/api/revendedores.php';
            
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-success mx-1' onclick='modal_master(\"{$api_path}\", \"add_creditos\", \"" . $id . "\")' title='Gerenciar Creditos'><i class='fas fa-coins'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-primary mx-1' onclick='modal_master(\"{$api_path}\", \"edite_revendedor\", \"" . $id . "\")' title='Editar'><i class='fas fa-edit'></i></button>";
            $acoes .= "<button type='button' class='btn btn-sm btn-outline-danger mx-1' onclick='modal_master(\"{$api_path}\", \"delete_revendedor\", \"" . $id . "\")' title='Excluir'><i class='fas fa-trash-alt'></i></button>";
            $acoes .= "</div>";
            
            $dados[] = [
                "id" => $id,
                "usuario" => htmlspecialchars($row['usuario'], ENT_QUOTES, 'UTF-8'),
                "creditos" => $row['creditos'],
                "qnt_clientes" => $row['qnt_clientes'],
                "acao" => $acoes
            ];
        }
        $total_records = $stmt->rowCount();
        return ["draw" => isset($dados_requisicao['draw']) ? intval($dados_requisicao['draw']) : 0, "recordsTotal" => $total_records, "recordsFiltered" => $total_records, "data" => $dados];
    } catch (Exception $e) {
        error_log("Erro ao listar revendedores: " . $e->getMessage());
        return ["draw" => 0, "recordsTotal" => 0, "recordsFiltered" => 0, "data" => [], "error" => "Erro Interno."];
    }
}

// ======================================================================
// ### FUNÇÕES DE CRÉDITOS ###
// ======================================================================
function add_creditos($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT user FROM admin WHERE id = ?");
    $stmt->execute([$id]);
    $revendedor = $stmt->fetch();
    if(!$revendedor) return ['modal_titulo' => 'Erro', 'modal_body' => 'Revendedor nao encontrado.'];

    $modal_body = "<form id='formAddCreditos-{$id}'>";
    $modal_body .= "<input type='hidden' name='acao' value='confirme_add_creditos'>";
    $modal_body .= "<input type='hidden' name='id' value='{$id}'>";
    $modal_body .= "<div class='form-group'><label>Creditos a Adicionar (use negativo para remover):</label><input type='number' name='creditos' class='form-control' value='1' step='1' required></div>";
    $modal_body .= "</form>";

    $modal_footer = "<button type='button' class='btn btn-success' onclick='enviarFormulario(\"formAddCreditos-{$id}\", \"/api/revendedores.php\")'>Confirmar</button>";
    
    return [ 'modal_header_class' => "modal-header bg-success text-white", 'modal_titulo' => "Gerenciar Creditos de " . htmlspecialchars($revendedor['user'], ENT_QUOTES, 'UTF-8'), 'modal_body' => $modal_body, 'modal_footer' => $modal_footer ];
}

function confirme_add_creditos($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'];
    $revendedor_id = isset($post_data['id']) ? $post_data['id'] : 0;
    $creditos_movidos = isset($post_data['creditos']) ? $post_data['creditos'] : null;
    
    try {
        if ($creditos_movidos === null || !is_numeric($creditos_movidos)) { throw new Exception("Quantidade de creditos invalida."); }
        $creditos_movidos = (int)$creditos_movidos;
        if ($creditos_movidos == 0) { throw new Exception("Nenhuma alteracao de credito foi feita (valor 0).", 1); }

        $conexao->beginTransaction();
        
        $stmt_rev_before = $conexao->prepare("SELECT user, creditos FROM admin WHERE id = :id");
        $stmt_rev_before->execute([':id' => $revendedor_id]);
        $revendedor_antes = $stmt_rev_before->fetch(PDO::FETCH_ASSOC);
        if (!$revendedor_antes) throw new Exception("Revendedor nao encontrado.");
        $revendedor_user = $revendedor_antes['user'];
        $creditos_rev_antes = (int)$revendedor_antes['creditos'];

        $stmt_admin_check = $conexao->prepare("SELECT admin, creditos FROM admin WHERE id = :admin_id");
        $stmt_admin_check->execute([':admin_id' => $admin_id]);
        $admin_info = $stmt_admin_check->fetch(PDO::FETCH_ASSOC);
        if(!$admin_info) throw new Exception("Admin nao encontrado.");
        $is_main_admin = ($admin_info['admin'] == 1);
        
        if (!$is_main_admin && (int)$admin_info['creditos'] < $creditos_movidos) { throw new Exception("Voce nao tem creditos suficientes."); }
        if ($creditos_movidos < 0 && $creditos_rev_antes < abs($creditos_movidos)){ throw new Exception("O revendedor nao tem creditos suficientes para remover."); }

        $sql_update_revendedor = "UPDATE admin SET creditos = creditos + :creditos WHERE id = :id";
        if (!$is_main_admin) { $sql_update_revendedor .= " AND criado_por = :admin_id_criador"; }
        $stmt_revendedor = $conexao->prepare($sql_update_revendedor);
        $params_rev = [':creditos' => $creditos_movidos, ':id' => $revendedor_id];
        if (!$is_main_admin) { $params_rev[':admin_id_criador'] = $admin_id; }
        $stmt_revendedor->execute($params_rev);

        if (!$is_main_admin) {
            $sql_update_admin = "UPDATE admin SET creditos = creditos - :creditos WHERE id = :admin_id";
            $stmt_admin_update = $conexao->prepare($sql_update_admin);
            $stmt_admin_update->execute([':creditos' => $creditos_movidos, ':admin_id' => $admin_id]);
        }
        
        $conexao->commit();
        
        $acao = $creditos_movidos > 0 ? "adicionado(s)" : "removido(s)";
        $quantidade = abs($creditos_movidos);
        $palavra_credito = ($quantidade === 1) ? 'credito' : 'creditos';
        $mensagem = "✅ *Operação de Créditos Concluída!*\n\n" .
                      "Olá, {$revendedor_user}!\n" .
                      "Foi {$acao} *{$quantidade} {$palavra_credito}* em sua conta com sucesso.";

        return [
            'icon' => 'success', 'title' => 'Sucesso!', 'msg' => 'Operacao concluida!',
            'data_table' => 'atualizar', 'dados_operacao_msg' => $mensagem 
        ];
        
    } catch(Exception $e) {
        if($conexao->inTransaction()) { $conexao->rollBack(); }
        $icon = $e->getCode() == 1 ? 'warning' : 'error';
        return ['title' => 'Atencao!', 'msg' => $e->getMessage(), 'icon' => $icon];
    }
}

// ======================================================================
// ### FUNÇÕES DE NOVO REVENDEDOR ###
// ======================================================================
function add_revendedor() {
    $conexao = conectar_bd();
    $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
    $stmt_admin = $conexao->prepare("SELECT plano FROM admin WHERE id = :admin_id");
    $stmt_admin->execute([':admin_id' => $admin_id]);
    $admin_plano = $stmt_admin->fetchColumn();
    $option = "";
    $planos_disponiveis = $conexao->prepare("SELECT id, nome FROM planos_admin WHERE id < :admin_plano ORDER BY id");
    $planos_disponiveis->execute([':admin_plano' => $admin_plano]);
    while ($p_admin = $planos_disponiveis->fetch(PDO::FETCH_ASSOC)) {
        $option .= '<option value="' . htmlspecialchars($p_admin['id']) . '">' . htmlspecialchars($p_admin['nome'], ENT_QUOTES, 'UTF-8') . '</option>';
    }
    if(empty($option)){ return ['modal_titulo' => "Aviso", 'modal_body' => "<div class='alert alert-warning'>Nao ha planos inferiores disponiveis...</div>", 'modal_footer' => "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Fechar</button>"]; }

    $modal_body = '<form id="formAddRevendedor">';
    $modal_body .= '<input type="hidden" name="acao" value="confirme_add_revendedor">';
    $modal_body .= '<div class="row"><div class="form-group col-md-6 mb-3"><label for="usuario">Usuario:</label><input type="text" class="form-control" name="usuario" required></div>';
    $modal_body .= '<div class="form-group col-md-6 mb-3"><label for="senha">Senha:</label><input type="password" class="form-control" name="senha" required></div></div>';
    $modal_body .= '<div class="row"><div class="form-group col-md-6 mb-3"><label for="whatsapp">WhatsApp (Opcional):</label><input type="text" class="form-control" name="whatsapp" placeholder="Ex: 55479..."></div>';
    $modal_body .= '<div class="form-group col-md-6 mb-3"><label for="email">Email (Opcional):</label><input type="email" class="form-control" name="email"></div></div>';
    $modal_body .= '<div class="row"><div class="form-group col-md-7 mb-3"><label for="plano">Selecione um plano:</label><select class="form-select" name="plano" required>' . $option . '</select></div>';
    $modal_body .= '<div class="form-group col-md-5 mb-3"><label for="creditos">Créditos Iniciais:</label><input type="number" class="form-control" name="creditos" value="0" min="0"></div></div>';
    $modal_body .= '</form>';
    
    $modal_footer = "<button type='button' onclick='enviarFormulario(\"formAddRevendedor\", \"/api/revendedores.php\")' class='btn btn-success'>Adicionar</button><button type='button' class='btn btn-danger' data-bs-dismiss='modal'>Cancelar</button>";
    
    return [ 'modal_header_class' => "modal-header bg-success text-white", 'modal_titulo' => "Adicionar Revendedor", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer ];
}

function confirme_add_revendedor($post_data) {
    $conexao = conectar_bd();
    $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
    $usuario = isset($post_data['usuario']) ? $post_data['usuario'] : '';
    $senha = isset($post_data['senha']) ? $post_data['senha'] : '';
    $plano = isset($post_data['plano']) ? $post_data['plano'] : '';
    $whatsapp = empty($post_data['whatsapp']) ? null : $post_data['whatsapp'];
    $email = empty($post_data['email']) ? null : $post_data['email'];
    $creditos = empty($post_data['creditos']) ? 0 : (int)$post_data['creditos'];

    try {
        if (mb_strlen($usuario, 'UTF-8') === 0 || empty($senha) || empty($plano)) { throw new Exception("Usuario, senha e plano sao obrigatorios."); }
        
        // CORREÇÃO: Removido 'is_banned' e 'status' (colunas não existem)
        $sql_insert = "INSERT INTO admin (user, pass, admin, creditos, criado_por, plano, whatsapp, email, data_criado) 
                       VALUES (:user, :pass, 0, :creditos, :criado_por, :plano, :whatsapp, :email, NOW())";
        
        $stmt_insert = $conexao->prepare($sql_insert);
        $params = [
            ':user' => $usuario, ':pass' => $senha, ':creditos' => $creditos,
            ':criado_por' => $admin_id, ':plano' => $plano,
            ':whatsapp' => $whatsapp, ':email' => $email
        ];
        
        $stmt_insert->execute($params);
        $lastInsertedId = $conexao->lastInsertId();
        
        $sql_insert_planos = "INSERT INTO planos (nome, admin_id, valor, custo_por_credito) VALUES ('Padrao', :admin_id, 30, 1)";
        $conexao->prepare($sql_insert_planos)->execute([':admin_id' => $lastInsertedId]);

        $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
        $link_painel = $protocolo . $_SERVER['HTTP_HOST'];
        
        $mensagem_revendedor = "Seja bem-vindo(a) à Top IPTV! 🚀\n\n" .
                               "Seguem seus dados de acesso ao painel de revenda:\n\n" .
                               "🔗 Link do Painel: " . $link_painel . "\n" .
                               "👤 Usuário: " . $usuario . "\n" .
                               "🔑 Senha: " . $senha . "\n\n";
        if ($creditos > 0) {
            $mensagem_revendedor .= "Sua conta foi iniciada com " . $creditos . " crédito(s).\n\n";
        }
        $mensagem_revendedor .= "Atenciosamente,\nEquipe Top IPTV";
                               
        return [
            'icon' => 'success', 'title' => 'Concluido!', 'msg' => 'Revendedor criado com sucesso',
            'data_table' => 'atualizar', 'dados_revendedor_msg' => $mensagem_revendedor 
        ];
    } catch (Exception $e) {
        if ($e->getCode() == 23000 || strpos($e->getMessage(), 'Duplicate entry') !== false) {
             return [ 'title' => 'Erro!', 'msg' => 'Erro ao criar: Usuario ja existe.', 'icon' => 'error' ];
        }
        return [ 'title' => 'Erro!', 'msg' => 'Erro ao criar revendedor: ' . $e->getMessage(), 'icon' => 'error' ];
    }
}

// ======================================================================
// ### FUNÇÕES DE EDITAR REVENDEDOR ###
// ======================================================================
function edite_revendedor($id) {
    $conexao = conectar_bd();
    $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
    $sql = "SELECT user, pass, plano, whatsapp FROM admin WHERE id = :id AND criado_por = :admin_id";
    $stmt = $conexao->prepare($sql);
    $stmt->execute([':id' => $id, ':admin_id' => $admin_id]);
    
    if ($revendedor = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $stmt_admin = $conexao->prepare("SELECT plano FROM admin WHERE id = :admin_id");
        $stmt_admin->execute([':admin_id' => $admin_id]);
        $admin_plano = $stmt_admin->fetchColumn();
        $option = "";
        $planos_disponiveis = $conexao->prepare("SELECT id, nome FROM planos_admin WHERE id < :admin_plano ORDER BY id");
        $planos_disponiveis->execute([':admin_plano'=> $admin_plano]);
        while ($p_admin = $planos_disponiveis->fetch(PDO::FETCH_ASSOC)) {
            $selected = ($p_admin['id'] == $revendedor['plano']) ? 'selected' : '';
            $option .= '<option value="' . htmlspecialchars($p_admin['id']) . '" ' . $selected . '>' . htmlspecialchars($p_admin['nome'], ENT_QUOTES, 'UTF-8') . '</option>';
        }

        $modal_body = '<form id="formEditeRevendedor-' . $id . '">';
        $modal_body .= '<input type="hidden" name="acao" value="confirme_editar_revendedor">';
        $modal_body .= '<input type="hidden" name="id" value="' . htmlspecialchars($id) . '">';
        $modal_body .= '<div class="row"><div class="form-group col-md-6 mb-3"><label for="usuario">Usuario:</label><input type="text" class="form-control" name="usuario" value="' . htmlspecialchars($revendedor['user'], ENT_QUOTES, 'UTF-8') . '" required></div>';
        $modal_body .= '<div class="form-group col-md-6 mb-3"><label for="senha">Nova Senha (deixe em branco):</label><input type="password" class="form-control" name="senha" value=""></div></div>';
        $whatsapp_valor = htmlspecialchars(isset($revendedor['whatsapp']) ? $revendedor['whatsapp'] : '', ENT_QUOTES, 'UTF-8');
        $modal_body .= '<div class="row"><div class="form-group col-md-12 mb-3"><label for="whatsapp">WhatsApp (Opcional):</label><input type="text" class="form-control" name="whatsapp" value="' . $whatsapp_valor . '"></div></div>';
        $modal_body .= '<div class="form-group"><label for="plano">Selecione um plano</label><select class="form-select" name="plano" required>' . $option . '</select></div>';
        $modal_body .= '</form>';
        
        $modal_footer = "<button type='button' onclick='enviarFormulario(\"formEditeRevendedor-" . $id . "\", \"/api/revendedores.php\")' class='btn btn-info'>Salvar</button><button type='button' class='btn btn-danger' data-bs-dismiss='modal'>Cancelar</button>";
        
        return [ 'modal_header_class' => "modal-header bg-info text-white", 'modal_titulo' => "Editar Revendedor", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer ];
    }
    return ['title' => 'Erro!', 'msg' => 'Revendedor nao encontrado ou sem permissao.', 'icon' => 'error'];
}

function confirme_editar_revendedor($post_data) {
    $conexao = conectar_bd();
    $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : null;
    $id = isset($post_data['id']) ? $post_data['id'] : 0;
    $usuario = isset($post_data['usuario']) ? $post_data['usuario'] : '';
    $senha = isset($post_data['senha']) ? $post_data['senha'] : '';
    $plano = isset($post_data['plano']) ? $post_data['plano'] : '';
    $whatsapp = isset($post_data['whatsapp']) ? $post_data['whatsapp'] : null;
    
    if (empty($id) || mb_strlen($usuario, 'UTF-8') === 0 || empty($plano)) { 
        return ['title' => 'Erro!', 'msg' => 'Usuario, ID ou Plano invalido.', 'icon' => 'error']; 
    }
    
    try {
        if (!empty($senha)) {
            $sql = "UPDATE admin SET user = :user, pass = :pass, plano = :plano, whatsapp = :whatsapp WHERE id = :id AND criado_por = :admin_id";
            $stmt = $conexao->prepare($sql);
            $stmt->bindParam(':pass', $senha);
        } else {
            $sql = "UPDATE admin SET user = :user, plano = :plano, whatsapp = :whatsapp WHERE id = :id AND criado_por = :admin_id";
            $stmt = $conexao->prepare($sql);
        }
        
        $stmt->bindParam(':user', $usuario);
        $stmt->bindParam(':plano', $plano, PDO::PARAM_INT);
        $stmt->bindParam(':whatsapp', $whatsapp, PDO::PARAM_STR); 
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':admin_id', $admin_id, PDO::PARAM_INT);
        
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            return ['title' => 'Concluido!', 'msg' => 'Revendedor editado com sucesso.', 'icon' => 'success', 'data_table' => 'atualizar'];
        } else {
             $checkStmt = $conexao->prepare("SELECT COUNT(*) FROM admin WHERE id = :id AND criado_por = :admin_id AND user = :user AND plano = :plano AND (whatsapp = :whatsapp OR (whatsapp IS NULL AND :whatsapp IS NULL))");
             $checkStmt->execute([':id' => $id, ':admin_id' => $admin_id, ':user' => $usuario, ':plano' => $plano, ':whatsapp' => $whatsapp]);
             if($checkStmt->fetchColumn() > 0 && empty($senha)){
                 return ['title' => 'Atencao!', 'msg' => 'Nenhuma alteracao foi detectada.', 'icon' => 'warning'];
             }
            return ['title' => 'Erro!', 'msg' => 'Nao foi possivel editar (permissao negada ou ID invalido).', 'icon' => 'error'];
        }
    } catch (PDOException $e) {
        if ($e->getCode() == 23000 || strpos($e->getMessage(), 'Duplicate entry') !== false) { 
            return ['title' => 'Erro!', 'msg' => 'Este nome de usuario ja existe. Tente outro.', 'icon' => 'error']; 
        }
        error_log("Erro em confirme_editar_revendedor: ".$e->getMessage());
        return ['title' => 'Erro!', 'msg' => 'Erro no banco de dados ao editar.', 'icon' => 'error'];
    }
}

// ======================================================================
// ### FUNÇÕES DE EXCLUIR REVENDEDOR ###
// ======================================================================
function delete_revendedor($id) {
    $conexao = conectar_bd();
    $stmt = $conexao->prepare("SELECT user FROM admin WHERE id = ?");
    $stmt->execute([$id]);
    $revendedor = $stmt->fetch();
    if(!$revendedor) return ['modal_titulo' => 'Erro', 'modal_body' => 'Revendedor nao encontrado.'];

    $modal_body = "<form id='formDeleteRevendedor-{$id}' onsubmit='return false;'>";
    $modal_body .= "<input type='hidden' name='acao' value='confirme_delete_revendedor'>";
    $modal_body .= "<input type='hidden' name='id' value='{$id}'>";
    $modal_body .= "</form>";
    $modal_body .= "Tem certeza que deseja excluir o revendedor <b>".htmlspecialchars($revendedor['user'], ENT_QUOTES, 'UTF-8')."</b>?<br><b class='text-danger'>Todos os clientes e sub-revendedores dele tambem serao perdidos permanentemente!</b>";
    
    $modal_footer = "<button type='button' class='btn btn-secondary' data-bs-dismiss='modal'>Cancelar</button><button type='button' class='btn btn-danger' onclick='enviarFormulario(\"formDeleteRevendedor-{$id}\", \"/api/revendedores.php\")'>EXCLUIR</button>";
    
    return [ 'modal_header_class' => "modal-header bg-danger text-white", 'modal_titulo' => "EXCLUIR REVENDEDOR", 'modal_body' => $modal_body, 'modal_footer' => $modal_footer ];
}

function confirme_delete_revendedor($post_data) {
    $conexao = conectar_bd();
    $admin_id = $_SESSION['admin_id'];
    $revendedor_id = isset($post_data['id']) ? $post_data['id'] : 0;
    
    if(empty($revendedor_id)) return ['title' => 'Erro!', 'msg' => 'ID do revendedor invalido.', 'icon' => 'error'];
    if($revendedor_id == $admin_id) return ['title' => 'Erro!', 'msg' => 'Voce nao pode excluir a si mesmo.', 'icon' => 'error'];

    try {
        $conexao->beginTransaction();
        $subRevendedoresIds = []; $idsParaVerificar = [$revendedor_id];
        while (!empty($idsParaVerificar)) {
            $placeholders = implode(',', array_fill(0, count($idsParaVerificar), '?'));
            $stmtSub = $conexao->prepare("SELECT id FROM admin WHERE criado_por IN ($placeholders)");
            foreach ($idsParaVerificar as $k => $idSub) { $stmtSub->bindValue(($k+1), $idSub, PDO::PARAM_INT); }
            $stmtSub->execute(); $novosIds = $stmtSub->fetchAll(PDO::FETCH_COLUMN, 0);
            $subRevendedoresIds = array_merge($subRevendedoresIds, $novosIds); $idsParaVerificar = $novosIds;
        }
        $todosIdsParaExcluir = array_merge([$revendedor_id], $subRevendedoresIds);
        if (!empty($todosIdsParaExcluir)) {
            $placeholdersExcluir = implode(',', array_fill(0, count($todosIdsParaExcluir), '?'));
            $stmtClientes = $conexao->prepare("DELETE FROM clientes WHERE admin_id IN ($placeholdersExcluir)");
            foreach ($todosIdsParaExcluir as $k => $idDel) { $stmtClientes->bindValue(($k+1), $idDel, PDO::PARAM_INT); } $stmtClientes->execute();
            $stmtPlanos = $conexao->prepare("DELETE FROM planos WHERE admin_id IN ($placeholdersExcluir)");
            foreach ($todosIdsParaExcluir as $k => $idDel) { $stmtPlanos->bindValue(($k+1), $idDel, PDO::PARAM_INT); } $stmtPlanos->execute();
            if (!empty($subRevendedoresIds)) {
                $placeholdersSubs = implode(',', array_fill(0, count($subRevendedoresIds), '?'));
                $stmtDelSubs = $conexao->prepare("DELETE FROM admin WHERE id IN ($placeholdersSubs)");
                foreach ($subRevendedoresIds as $k => $idSubDel) { $stmtDelSubs->bindValue(($k+1), $idSubDel, PDO::PARAM_INT); } $stmtDelSubs->execute();
            }
        }
        $stmtDelPrincipal = $conexao->prepare("DELETE FROM admin WHERE id = ? AND criado_por = ?");
        $stmtDelPrincipal->execute([$revendedor_id, $admin_id]);
        
        if ($stmtDelPrincipal->rowCount() > 0) {
            $conexao->commit();
            return ['title' => 'Sucesso!', 'msg' => 'Revendedor, sub-revendedores e clientes associados foram excluidos.', 'icon' => 'success', 'data_table' => 'atualizar'];
        } else {
            $conexao->rollBack();
            return ['title' => 'Erro!', 'msg' => 'Revendedor nao encontrado ou voce nao tem permissao para exclui-lo.', 'icon' => 'error'];
        }
    } catch (Exception $e) {
        if ($conexao->inTransaction()) { $conexao->rollBack(); }
        error_log("Erro em confirme_delete_revendedor: ".$e->getMessage());
        return ['title' => 'Erro!', 'msg' => 'Nao foi possivel excluir o revendedor: ' . $e->getMessage(), 'icon' => 'error'];
    }
}

// ======================================================================
// ### FUNÇÕES DE ADMIN/PERFIL (Placeholders) ###
// ======================================================================
if (!function_exists('edite_admin')) {
    function edite_admin() {
        return ['modal_titulo' => 'Aviso', 'modal_body' => 'Funcao "edite_admin" ainda nao implementada.'];
    }
}
if (!function_exists('confirme_edite_admin')) {
    function confirme_edite_admin($post_data) {
        return ['title' => 'Aviso', 'msg' => 'Funcao "confirme_edite_admin" nao implementada.', 'icon' => 'info'];
    }
}
if (!function_exists('edite_admin_revenda')) {
    function edite_admin_revenda() {
        return ['modal_titulo' => 'Aviso', 'modal_body' => 'Funcao "edite_admin_revenda" nao implementada.'];
    }
}
if (!function_exists('confirme_edite_admin_revenda')) {
    function confirme_edite_admin_revenda($post_data) {
        return ['title' => 'Aviso', 'msg' => 'Funcao "confirme_edite_admin_revenda" nao implementada.', 'icon' => 'info'];
    }
}
?>
