<?php
session_start();
header('Content-Type: application/json');

// Inclui o arquivo de conexão com o banco de dados
try {
    require_once 'controles/db.php';
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Erro crítico: Não foi possível carregar o arquivo do banco de dados.']);
    exit;
}

// Verifica se o token está na sessão para autenticar
$token_enviado = $_SESSION['token'] ?? '';
$admin_id = $_SESSION['admin_id'] ?? '';

if (empty($token_enviado) || empty($admin_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Sessão inválida.']);
    exit;
}

$conexao = conectar_bd();
if (!$conexao) {
    echo json_encode(['status' => 'error', 'message' => 'Falha na conexão com o banco de dados.']);
    exit;
}

try {
    // Busca os dados do admin, incluindo 'creditos_usados', 'nivel_admin' e 'Vencimento'
    $sql = "SELECT creditos_usados, nivel_admin, Vencimento FROM admin WHERE id = :admin_id AND token = :token";
    $stmt = $conexao->prepare($sql);
    $stmt->bindParam(':admin_id', $admin_id, PDO::PARAM_INT);
    $stmt->bindParam(':token', $token_enviado, PDO::PARAM_STR);
    $stmt->execute();
    $admin_data = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$admin_data) {
        // Token inválido ou ID não encontrado
        echo json_encode(['status' => 'error', 'message' => 'Usuário não autenticado.']);
        exit;
    }

    $creditos_usados = (float)$admin_data['creditos_usados'];
    // Seu saldo é armazenado como NEGATIVO, então invertemos o sinal para exibir o saldo disponível
    $saldo_disponivel = -$creditos_usados;

    // Formatação
    $saldo_formatado = number_format($saldo_disponivel, 2, ',', '.');
    $nivel_admin = (int)$admin_data['nivel_admin'];
    $vencimento = $admin_data['Vencimento'] ? date('d/m/Y', strtotime($admin_data['Vencimento'])) : null;
    $tipo_admin = ($nivel_admin === 1) ? 'ADMINISTRADOR' : 'REVENDEDOR';
    
    // Admins isentos (como o ID 11 que você configurou anteriormente) podem ser diferenciados aqui
    // Se você é o admin principal e é isento, seu saldo pode ser mostrado como 'ILIMITADO' ou R$ 0,00
    // Para simplificar, vou usar a lógica de nível para diferenciar.
    if ($nivel_admin === 1) { // Se for o Administrador Principal
        $saldo_formatado = 'ILIMITADO';
    }

    echo json_encode([
        'status' => 'success',
        'creditos' => $saldo_formatado,
        'tipo_admin' => $tipo_admin,
        'vencimento' => $vencimento
    ]);

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Erro ao buscar dados: ' . $e->getMessage()]);
}

// Fechar conexão
$conexao = null;
?>