<?php
// Define limites mais altos para arquivos grandes
ini_set('memory_limit', '1024M'); 
ini_set('display_errors', 0);
error_reporting(0);

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

if (empty($data['url'])) {
    http_response_code(400);
    echo json_encode(['error' => 'URL não fornecida.']);
    exit;
}

$url = $data['url'];

// 1. Usa cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 60); 
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); 
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 

// ==================================================
//         CORREÇÃO: "FINGIR" SER UM NAVEGADOR
// ==================================================
// Esta linha faz o script se passar por um navegador Chrome
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36');
// ==================================================

$content = curl_exec($ch);
$curl_error = curl_error($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// 2. Verifica se o cURL falhou (timeout, etc)
if ($curl_error) {
    http_response_code(500);
    echo json_encode(['error' => 'PROXY_ERRO: Falha de cURL: ' . $curl_error]);
    exit;
}

// 3. Verifica se o código HTTP é 200 (OK)
if ($http_code != 200) {
    http_response_code(500); 
    echo json_encode(['error' => "PROXY_ERRO: O servidor da URL respondeu com um erro: $http_code (Ex: 404 Not Found, 403 Forbidden). Verifique o link."]);
    exit;
}

// 4. Verifica se o conteúdo está vazio
if (empty($content)) {
    http_response_code(500);
    echo json_encode(['error' => 'PROXY_ERRO: O arquivo da URL está vazio (mas o status foi 200 OK).']);
    exit;
}

// 5. Tenta forçar UTF-8
if (!mb_check_encoding($content, 'UTF-8')) {
    $content = mb_convert_encoding($content, 'UTF-8', 'ISO-8859-1');
}

// 6. Limpa o conteúdo (BOM e espaços em branco)
$content = preg_replace('/^\xEF\xBB\xBF/', '', $content); // Remove BOM
$content = preg_replace('/^\s+/', '', $content); // Remove linhas em branco do início

// 7. Tenta codificar o JSON
$json_output = json_encode(['content' => $content]);

if ($json_output === false) {
    http_response_code(500);
    echo json_encode([
        'error' => 'PROXY_ERRO: Falha ao codificar JSON. O arquivo M3U é muito grande (Excedeu o limite de memória do PHP).',
        'json_last_error' => json_last_error_msg() 
    ]);
    exit;
}

// Sucesso
echo $json_output;
?>