<?php
// Define o cabeçalho como texto puro
header('Content-Type: text/plain; charset=UTF-8');
require_once 'controles/db.php';

// --- CONFIGURAÇÃO DE SEGURANÇA ---
// Chave secreta para garantir que apenas seus LBs possam pedir a configuração
$secret_key = 'Jean909110'; // Use a mesma chave dos outros agentes

if (!isset($_GET['token']) || $_GET['token'] !== $secret_key) {
    http_response_code(403);
    die("# ACESSO NEGADO: Token inválido.");
}

// --- GERAÇÃO DA CONFIGURAÇÃO ---
try {
    $pdo = conectar_bd();
    
    // Pega o domínio do painel principal (pode ser dinâmico vindo de uma tabela de configurações no futuro)
    $painel_principal_domain = 'topiptv.tvsbr.top'; // Ou o domínio que você usa

    // Busca todos os servidores cadastrados para pegar os domínios e portas de cliente
    $servidores = $pdo->query("SELECT * FROM servers")->fetchAll(PDO::FETCH_ASSOC);
    
    if(empty($servidores)){
        die("# ERRO: Nenhum servidor encontrado no painel.");
    }
    
    // Monta a lista de server_name (IP + Domínio de cada LB)
    // Usaremos o primeiro servidor para o exemplo, mas isso pode ser adaptado
    $primeiro_servidor = $servidores[0];
    $server_name_list = $primeiro_servidor['server_ip'] . ' ' . $primeiro_servidor['server_ip']; // Exemplo simples
    $porta_stream = $primeiro_servidor['server_port'];
    $porta_agente = $primeiro_servidor['agent_port'];
    
    // Pega a versão do PHP (pode ser uma configuração global no seu painel)
    $php_version = '8.1'; // Defina a versão do PHP usada nos seus LBs

// Usando HEREDOC para criar o template da configuração
$nginx_config = <<<NGINX
# ===================================================================
# CONFIGURAÇÃO GERADA AUTOMATICAMENTE PELO PAINEL
# Data: {date("Y-m-d H:i:s")}
# ===================================================================

# BLOCO 1: PARA O AGENTE DE STATUS E LOGIN NA PORTA {$porta_agente}
server {
    listen {$porta_agente};
    listen [::]:{$porta_agente};
    server_name {$server_name_list};
    root /var/www/html;
    index index.php index.html;
    location / { try_files \$uri \$uri/ /index.php?\$query_string; }
    location /player_api.php {
        proxy_pass http://{$painel_principal_domain};
        proxy_set_header Host {$painel_principal_domain};
        proxy_set_header X-Real-IP \$remote_addr;
        proxy_set_header X-Forwarded-For \$proxy_add_x_forwarded_for;
        proxy_set_header User-Agent "NginxProxy"; 
    }
    location ~ \.php$ {
        include snippets/fastcgi-php.conf;
        fastcgi_pass unix:/var/run/php/php{$php_version}-fpm.sock;
    }
}
# BLOCO 2: PARA O STREAMING NA PORTA {$porta_stream}
server {
    listen {$porta_stream};
    listen [::]:{$porta_stream};
    server_name {$server_name_list};
    access_log off;
    location / {
        proxy_pass http://{$painel_principal_domain};
        proxy_set_header Host {$painel_principal_domain};
        proxy_set_header X-Real-IP \$remote_addr;
        proxy_set_header X-Forwarded-For \$proxy_add_x_forwarded_for;
        proxy_set_header User-Agent "NginxProxy";
    }
}
NGINX;

    // Imprime a configuração final
    echo $nginx_config;

} catch (Exception $e) {
    http_response_code(500);
    die("# ERRO INTERNO: " . $e->getMessage());
}
?>