<?php
// 1. LIMPEZA E CONFIGURAO
ob_start(); 
ini_set('display_errors', 0); 
error_reporting(0); 
header('Content-Type: application/json; charset=utf-8');
session_start();

$retorno = [];

try {
    // 2. CONEXO COM BANCO DE DADOS
    // Busca o arquivo de conexo subindo nveis de pasta
    $pdo = null;
    $caminhos_db = [
        __DIR__ . '/../controles/db.php',   
        __DIR__ . '/../db.php',             
        __DIR__ . '/controles/db.php'       
    ];

    foreach ($caminhos_db as $arquivo) {
        if (file_exists($arquivo)) {
            require_once($arquivo);
            if (function_exists('conectar_bd')) {
                try { $pdo = conectar_bd(); break; } catch (Exception $e) {}
            }
        }
    }

    if (!$pdo) {
        throw new Exception("Erro Crtico: No foi possvel conectar ao banco de dados.");
    }

    // 3. DADOS DO USURIO DE TESTE
    $horas = 3; 
    $rand = rand(1000, 9999);
    $usuario = "teste" . $rand;
    $senha = "t" . $rand;
    
    $timestamp = strtotime("+$horas hours");
    $vencimento_sql = date('Y-m-d H:i:s', $timestamp);
    $vencimento_exibir = date('d/m/Y H:i', $timestamp);

    // 4. BUSCA PACOTE (BOUQUET)
    $stmt = $pdo->query("SELECT id FROM bouquets LIMIT 1");
    $pacote = $stmt->fetch(PDO::FETCH_ASSOC);
    $bouquet_id = $pacote ? $pacote['id'] : 0;

    if ($bouquet_id == 0) throw new Exception("Nenhum pacote de canais encontrado no painel.");

    // 5. INSERE CLIENTE NO BANCO (CORRIGIDO: USANDO ? PARA EVITAR ERRO HY093)
    $admin_id = isset($_SESSION['admin_id']) ? $_SESSION['admin_id'] : 1; 

    // Note que usamos 7 interrogaes (?) para os 7 campos variveis
    $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, bouquet_id, plano, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
            VALUES (?, ?, ?, ?, '', ?, ?, ?, 1, NOW(), 1, 0)";
    
    $stmt_insert = $pdo->prepare($sql);
    $stmt_insert->execute([
        $admin_id,      // 1 ?
        $usuario,       // 2 ? (name)
        $usuario,       // 3 ? (usuario)
        $senha,         // 4 ? (senha)
        $bouquet_id,    // 5 ? (bouquet_id)
        $bouquet_id,    // 6 ? (plano)
        $vencimento_sql // 7 ? (Vencimento)
    ]);

    // 6. CONFIGURAO DA URL DO PAINEL
    $url_painel = (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'];
    
    try {
        $q = $pdo->query("SELECT server_ip, server_port FROM servers WHERE status = 1 LIMIT 1");
        $s = $q->fetch(PDO::FETCH_ASSOC);
        if ($s) {
            $ip = $s['server_ip'];
            $port = $s['server_port'];
            if (strpos($ip, 'http') === false) $ip = "http://" . $ip;
            if ($port != 80 && !empty($port)) $ip .= ":" . $port;
            $url_painel = $ip;
        }
    } catch (Exception $e) {}

    // ==================================================================================
    // 7. CARREGA O TEMPLATE
    // ==================================================================================
    
    $conteudo_template = "";
    
    // Procura na raiz (pai da api)
    $caminho_template = dirname(__DIR__) . '/template_mensagem.txt';

    if (file_exists($caminho_template)) {
        $conteudo_template = file_get_contents($caminho_template);
    } else {
        // Tenta caminho relativo simples
        if (file_exists('../template_mensagem.txt')) {
            $conteudo_template = file_get_contents('../template_mensagem.txt');
        }
    }

    if (empty($conteudo_template)) {
        $conteudo_template = "Teste Criado!\nUsuario: #username#\nSenha: #password#\nValidade: #exp_date#\nURL: #url#";
    }

    // 8. SUBSTITUIO DE VARIVEIS
    $m3u_encurtado = "$url_painel/m3u-ts/$usuario/$senha";
    $m3u_hls_encurtado = "$url_painel/m3u-hls/$usuario/$senha";
    $ssiptv_encurtado = "$url_painel/ssiptv/$usuario/$senha";
    
    $m3u_link = "$url_painel/get.php?username=$usuario&password=$senha&type=m3u_plus&output=ts";
    $m3u_link_hls = "$url_painel/get.php?username=$usuario&password=$senha&type=m3u_plus&output=m3u8";

    $de = ['#username#', '#password#', '#url#', '#exp_date#', '#m3u_encurtado#', '#m3u_hls_encurtado#', '#ssiptv_encurtado#', '#m3u_link#', '#m3u_link_hls#'];
    $para = [$usuario, $senha, $url_painel, $vencimento_exibir, $m3u_encurtado, $m3u_hls_encurtado, $ssiptv_encurtado, $m3u_link, $m3u_link_hls];

    $msg_final = str_replace($de, $para, $conteudo_template);

    // ==================================================================================

    // 9. RETORNO PARA O MODAL
    $html = '<div class="alert alert-success text-center">Teste Criado com Sucesso!</div>';
    $html .= '<label class="fw-bold">Copie a mensagem abaixo:</label>';
    $html .= '<textarea class="form-control mt-2" rows="12" id="msgCopy" style="font-size:13px; color:#333; background:#f8f9fa;">'.$msg_final.'</textarea>';
    
    $ft = '<button type="button" class="btn btn-primary" onclick="var copyText = document.getElementById(\'msgCopy\'); copyText.select(); document.execCommand(\'copy\'); alert(\'Copiado!\');">Copiar</button>';
    $ft .= '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>';

    $retorno = [
        'modal_titulo' => 'Teste Gerado',
        'modal_body' => $html,
        'modal_footer' => $ft,
        'data_table' => 'atualizar'
    ];

} catch (Exception $e) {
    $retorno = [
        'modal_titulo' => 'Erro',
        'modal_body' => '<div class="alert alert-danger">'.$e->getMessage().'</div>',
        'modal_footer' => '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>'
    ];
}

ob_end_clean();
echo json_encode($retorno);
exit;
?>