<?php
session_start();
require_once('controles/db.php');
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['title'=>'Erro', 'msg'=>'Sessão expirada', 'icon'=>'error']);
    exit;
}

// --- FUNÇÕES AUXILIARES PARA O TEMPLATE (Incorporadas aqui para não depender de outros arquivos) ---

function obter_url_painel($conexao) {
    // Tenta pegar do Load Balance primeiro
    try {
        $stmt = $conexao->prepare("SELECT server_ip, server_port FROM servers WHERE status = 1 LIMIT 1");
        $stmt->execute();
        if ($s = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $url = rtrim($s['server_ip'], '/');
            $port = $s['server_port'];
            if (strpos($url, 'http') !== 0) $url = ($port == 443 ? 'https://' : 'http://') . $url;
            if (!empty($port) && $port != 80 && $port != 443) $url .= ':' . $port;
            return $url;
        }
    } catch (Exception $e) {}
    
    // Se não tiver Load Balance, usa a URL atual do navegador/servidor
    return (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
}

function formatar_mensagem_template($pdo, $user, $pass, $vencimento) {
    $url = obter_url_painel($pdo);
    $exp_format = date('d/m/Y H:i', strtotime($vencimento));
    
    // Caminho padrão onde o ZenPanel/Office salva o template editado
    $arquivo_template = $_SERVER['DOCUMENT_ROOT'] . '/template_mensagem.txt';
    
    if (file_exists($arquivo_template)) {
        $template = file_get_contents($arquivo_template);
    } else {
        // Fallback se não tiver template salvo
        $template = "✅ *TESTE CRIADO* ✅\n\n👤 Usuário: #username#\n🔑 Senha: #password#\n📅 Vence: #exp_date#\n\n🔗 URL: #url#";
    }

    // Faz as substituições das tags
    $replacements = [
        '#username#' => $user,
        '#password#' => $pass,
        '#url#' => $url,
        '#exp_date#' => $exp_format,
        '#m3u_link#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=ts",
        '#m3u_link_hls#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=m3u8",
        '#ssiptv_link#' => "$url/get.php?username=$user&password=$pass&type=m3u_plus&output=ts",
        '#name#' => $user // Caso use tag de nome
    ];
    
    return str_replace(array_keys($replacements), array_values($replacements), $template);
}

// --- CÓDIGO PRINCIPAL DA GERAÇÃO ---

try {
    $pdo = conectar_bd();
    
    $tempo_horas = 3; // Duração do teste
    $rand = rand(1000, 9999);
    $usuario = "teste" . $rand;
    $senha = "t" . $rand;
    $vencimento = date('Y-m-d H:i:s', strtotime("+$tempo_horas hours"));

    // Pega o primeiro pacote disponível
    $stmt = $pdo->query("SELECT id FROM bouquets LIMIT 1");
    $pacote = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$pacote) {
        echo json_encode(['title'=>'Erro', 'msg'=>'Nenhum pacote de canais encontrado!', 'icon'=>'error']);
        exit;
    }
    $bouquet_id = $pacote['id'];

    // Insere no Banco
    $admin_id = $_SESSION['admin_id'];
    $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, WhatsApp, bouquet_id, Vencimento, conexoes, Criado_em, is_trial, is_p2p) 
            VALUES (?, ?, ?, ?, '', ?, ?, 1, NOW(), 1, 0)";
    
    $pdo->prepare($sql)->execute([$admin_id, $usuario, $usuario, $senha, $bouquet_id, $vencimento]);

    // GERA A MENSAGEM USANDO O TEMPLATE DO SISTEMA
    $msg = formatar_mensagem_template($pdo, $usuario, $senha, $vencimento);

    // Monta o Modal de Sucesso
    $html = '<div class="alert alert-success text-center fw-bold">Teste Gerado com Sucesso!</div>';
    $html .= '<textarea class="form-control" rows="12" readonly style="font-family:monospace; font-size: 0.85rem;">'.$msg.'</textarea>';
    
    $ft = '<button class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
           <button class="btn btn-primary" onclick="navigator.clipboard.writeText(`'.$msg.'`);alert(\'Copiado!\')"><i class="fas fa-copy"></i> Copiar</button>
           <a href="https://wa.me/?text='.urlencode($msg).'" target="_blank" class="btn btn-success"><i class="fab fa-whatsapp"></i> WhatsApp</a>';

    echo json_encode([
        'modal_titulo' => 'Teste Rápido', 
        'modal_body' => $html, 
        'modal_footer' => $ft, 
        'data_table' => 'atualizar'
    ]);

} catch (Exception $e) {
    echo json_encode(['title'=>'Erro', 'msg'=>$e->getMessage(), 'icon'=>'error']);
}
?>