<?php
// ARQUIVO: /api/migrar_acao.php
set_time_limit(0); 
ini_set('display_errors', 0);
header('Content-Type: application/json');
session_start();

// Verifica Login
if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'status' => 'error', 'message' => 'Sessão expirada.']);
    exit;
}

require_once('controles/db.php');
$pdo = conectar_bd();
$admin_id = $_SESSION['admin_id'];
$nivel_admin = $_SESSION['nivel_admin'];

// ==================================================================
// ROTINA 1: SALVAR CONFIGURAÇÃO
// ==================================================================
if (isset($_POST['action']) && $_POST['action'] == 'salvar_config') {
    
    $valor_recebido = $_POST['cobrar_credito'];
    // Força ser string '0' ou '1'
    $cobrar = ($valor_recebido == 1 || $valor_recebido == '1') ? '1' : '0';

    try {
        // 1. Tenta Atualizar direto
        $stmt = $pdo->prepare("UPDATE painel_config SET valor = ? WHERE chave = 'migracao_cobrar_credito'");
        $stmt->execute([$cobrar]);
        
        // 2. Verifica se a linha existe (CORREÇÃO: Busca por 'chave' e não por 'id')
        $check = $pdo->prepare("SELECT chave FROM painel_config WHERE chave = 'migracao_cobrar_credito'");
        $check->execute();
        
        // Se não retornou nada, significa que não existe, então insere.
        if ($check->rowCount() == 0) {
            $stmtInsert = $pdo->prepare("INSERT INTO painel_config (chave, valor) VALUES ('migracao_cobrar_credito', ?)");
            $stmtInsert->execute([$cobrar]);
        }
        
        echo json_encode(['status' => 'success', 'message' => 'Configuração salva!']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'Erro SQL: ' . $e->getMessage()]);
    }
    exit; 
}

// ==================================================================
// ROTINA 2: EXECUTAR MIGRAÇÃO
// ==================================================================

// --- 1. Verifica se deve cobrar ---
$cobrar = false;
$custo_por_cliente = 1;

// Busca valor no banco
$stmt_conf = $pdo->prepare("SELECT valor FROM painel_config WHERE chave = 'migracao_cobrar_credito'");
$stmt_conf->execute();
$conf_valor = $stmt_conf->fetchColumn();

// Lógica: Se for '0' desativa. Se for '1' ou não existir, ativa.
$config_ativa = ($conf_valor === '0' || $conf_valor === 0) ? 0 : 1; 

if ($config_ativa == 1 && $nivel_admin != 1 && $admin_id != 11) {
    $cobrar = true;
}

// --- 2. Pega Planos Padrão ---
$stmt_plano = $pdo->prepare("SELECT id FROM planos WHERE admin_id = ? LIMIT 1");
$stmt_plano->execute([$admin_id]);
$default_plano = $stmt_plano->fetchColumn() ?: 0;
if(!$default_plano) $default_plano = $pdo->query("SELECT id FROM planos LIMIT 1")->fetchColumn() ?: 0;
$default_bouquet = $pdo->query("SELECT id FROM bouquets LIMIT 1")->fetchColumn() ?: 0;

// --- 3. Lê os dados da Importação ---
$input = json_decode(file_get_contents('php://input'), true);
$modo = $input['modo'] ?? 'individual';
$urls = [];

if ($modo === 'individual') {
    $urls[] = trim($input['api_url'] ?? '');
} else {
    $lines = preg_split('/\r\n|\r|\n/', $input['urls_massa'] ?? '');
    foreach ($lines as $line) if(trim($line)) $urls[] = trim($line);
}

if (empty($urls)) { echo json_encode(['success' => false, 'message' => 'Nenhuma URL válida.']); exit; }

$importados = 0;
$atualizados = 0;
$erros = 0;
$creditos_gastos = 0;

foreach ($urls as $url) {
    $url = trim($url);
    if (strpos($url, 'http') !== 0) $url = 'http://' . $url;
    
    $usuario = null; $senha = null;

    // Regex para pegar usuario e senha
    preg_match('/username=([^&]+)/', $url, $u_match);
    preg_match('/password=([^&]+)/', $url, $p_match);
    if (!empty($u_match[1]) && !empty($p_match[1])) {
        $usuario = $u_match[1]; $senha = $p_match[1];
    } else {
        if (preg_match('/\/(?:get|live|movie|series)\/([^\/]+)\/([^\/]+)/', $url, $matches)) {
            $usuario = $matches[1]; $senha = $matches[2];
        }
    }

    if ($usuario && $senha) {
        // Data padrão (30 dias)
        $vencimento_final = date('Y-m-d H:i:s', strtotime('+30 days'));
        
        // Tenta pegar data real via API
        $parsed = parse_url($url);
        $baseUrl = $parsed['scheme'] . '://' . $parsed['host'];
        if (isset($parsed['port'])) $baseUrl .= ':' . $parsed['port'];
        
        $apiCheckUrl = $baseUrl . "/player_api.php?username=$usuario&password=$senha";

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $apiCheckUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10, 
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_USERAGENT => 'Mozilla/5.0'
        ]);
        $resp = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($resp && $httpCode == 200) {
            $data = json_decode($resp, true);
            if (isset($data['user_info']['exp_date'])) {
                $ts = $data['user_info']['exp_date'];
                if (is_numeric($ts) && $ts > 946684800) { 
                    $vencimento_final = date('Y-m-d H:i:s', $ts);
                }
            }
        }

        try {
            $check = $pdo->prepare("SELECT id FROM clientes WHERE usuario = ?");
            $check->execute([$usuario]);
            
            if ($check->rowCount() > 0) {
                // Atualiza (Grátis)
                $pdo->prepare("UPDATE clientes SET senha = ?, Vencimento = ? WHERE usuario = ?")->execute([$senha, $vencimento_final, $usuario]);
                $atualizados++;
            } else {
                // Novo (Verifica Saldo)
                if ($cobrar) {
                    $stmt_saldo = $pdo->prepare("SELECT creditos FROM admin WHERE id = ?");
                    $stmt_saldo->execute([$admin_id]);
                    if ($stmt_saldo->fetchColumn() < $custo_por_cliente) {
                        $erros++;
                        continue;
                    }
                }

                $sql = "INSERT INTO clientes (admin_id, name, usuario, senha, Vencimento, is_trial, conexoes, is_p2p, Criado_em, plano, bouquet_id) 
                        VALUES (?, ?, ?, ?, ?, 0, 1, 0, NOW(), ?, ?)";
                $pdo->prepare($sql)->execute([$admin_id, $usuario, $usuario, $senha, $vencimento_final, $default_plano, $default_bouquet]);

                if ($cobrar) {
                    $pdo->prepare("UPDATE admin SET creditos = creditos - ? WHERE id = ?")->execute([$custo_por_cliente, $admin_id]);
                    $creditos_gastos += $custo_por_cliente;
                }
                $importados++;
            }
        } catch (Exception $e) {
            $erros++;
        }
    } else {
        $erros++;
    }
}

$msg = "Feito!<br>✅ Novos: <b>$importados</b> " . ($cobrar ? "(Custo: $creditos_gastos)" : "(Grátis)") . "<br>🔄 Atualizados: <b>$atualizados</b>";
if ($erros > 0) $msg .= "<br>❌ Falhas: <b>$erros</b>";

echo json_encode(['success' => true, 'message' => $msg]);
?>