<?php
// Define um tempo limite maior para o download, caso a lista seja grande ou a conexão lenta
set_time_limit(300);

// Pega a URL da lista M3U que o javascript enviou
$m3u_url = $_GET['url'] ?? '';

// Validação rigorosa da URL
if (empty($m3u_url) || !filter_var($m3u_url, FILTER_VALIDATE_URL)) {
    http_response_code(400); // Bad Request
    die("URL inválida ou não fornecida.");
}

// Inicia o cURL para baixar o conteúdo de forma segura
$ch = curl_init();

// Opções essenciais do cURL
curl_setopt($ch, CURLOPT_URL, $m3u_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);    // Retorna o conteúdo como uma string
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);    // Segue redirecionamentos (essencial para listas M3U)
curl_setopt($ch, CURLOPT_MAXREDIRS, 5);           // Limita o número de redirecionamentos
curl_setopt($ch, CURLOPT_TIMEOUT, 120);            // Timeout de 2 minutos para a conexão

// [MELHORIA] Opções de segurança para conexões SSL (https://)
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

// [BOA PRÁTICA] Simula um User-Agent conhecido para evitar bloqueios
curl_setopt($ch, CURLOPT_USERAGENT, 'VLC/3.0.0');

// Executa a requisição
$content = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

// Verifica se houve erro no download
if ($content === false || $http_code >= 400) {
    http_response_code(502); // Bad Gateway: indica que nosso servidor não conseguiu falar com o outro
    // Loga o erro para depuração no servidor, se desejar
    // error_log("Proxy falhou para a URL: {$m3u_url}. Código: {$http_code}. Erro: {$error}");
    die("Erro ao baixar a lista do fornecedor. Código de Status: $http_code.");
}

// Se tudo deu certo, envia o conteúdo da lista M3U de volta para o javascript
// [MELHORIA] Usar text/plain é mais seguro e compatível, e utf-8 garante a leitura de caracteres especiais
header('Content-Type: text/plain; charset=utf-8');
echo $content;

exit();
?>