<?php
// Arquivo: /api/revendedores.php
// VERSÃO FINAL "FORÇA BRUTA"

ob_start();
ini_set('display_errors', 0);
error_reporting(0);
@session_start();

require_once('controles/db.php');
ob_clean(); 

header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['error' => 'Sessão expirada']);
    exit;
}

$pdo = conectar_bd();
$admin_id = $_SESSION['admin_id'];

// --- GET ---
if (isset($_GET['acao']) && $_GET['acao'] == 'obter_contagens_revendedores') {
    try {
        $filtro = " AND admin = 0 AND criado_por = $admin_id ";
        $ativos = $pdo->query("SELECT COUNT(id) FROM admin WHERE creditos > 0 $filtro")->fetchColumn();
        $vencidos = $pdo->query("SELECT COUNT(id) FROM admin WHERE (creditos <= 0 OR creditos IS NULL) $filtro")->fetchColumn();
        echo json_encode(['ativos'=>$ativos, 'vencidos'=>$vencidos, 'bloqueados'=>0]);
    } catch (Exception $e) { echo json_encode(['ativos'=>0]); }
    exit;
}

if (isset($_GET['acao']) && $_GET['acao'] == 'listar_lista_revendedores') {
    try {
        $stmt = $pdo->prepare("SELECT id, user FROM admin WHERE admin = 0 AND criado_por = ? ORDER BY user ASC");
        $stmt->execute([$admin_id]);
        echo json_encode(['data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
    } catch (Exception $e) { echo json_encode(['data'=>[]]); }
    exit;
}

require_once('controles/funcoes_revendedores.php');

if (isset($_REQUEST['listar_revendedores'])) {
    echo json_encode(listar_revendedores($_REQUEST));
    exit;
}

// --- POST ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['acao'] ?? $_POST['action'] ?? null;
    
    // Fallback para descobrir ação
    if (!$action) {
        foreach($_POST as $k => $v) { if($k != 'id' && function_exists($k)) { $action = $k; break; } }
    }

    if ($action && function_exists($action)) {
        
        // --- CORREÇÃO ESPECÍFICA PARA EXCLUSÃO ---
        // Pega o ID diretamente do POST global, ignorando arrays intermediários
        if ($action == 'confirme_delete_revendedor') {
            $id_direto = isset($_POST['id']) ? $_POST['id'] : 0;
            echo json_encode(confirme_delete_revendedor(['id' => $id_direto]));
        }
        // -----------------------------------------
        
        elseif (in_array($action, ['add_creditos', 'edite_revendedor', 'delete_revendedor', 'add_revendedor'])) {
            $id = $_POST['id'] ?? 0;
            echo json_encode($action($id));
        } 
        elseif (strpos($action, 'confirme_') === 0) {
            echo json_encode($action($_POST));
        }
    } else {
        echo json_encode(['title'=>'Erro', 'msg'=>'Ação inválida', 'icon'=>'error']);
    }
    exit;
}
?>