<?php
/**
 * Arquivo: /api/revendedores.php
 * VERSÃO 20 - LÓGICA DE CONTAGEM 100% CORRIGIDA (USA 'criado_por' e 'creditos')
 * - Contagem NÃO usa 'is_banned' ou 'status' (colunas não existem na sua tabela 'admin')
 */

// --- Configuracoes Iniciais ---
ini_set('display_errors', 1);
error_reporting(E_ALL);
@session_start();

// --- Includes Essenciais ---
require_once('controles/db.php'); // Só o DB por agora

// --- Verificacao de Seguranca (Sessao) ---
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['title' => 'Erro!', 'msg' => 'Sessao expirada ou invalida. Faca login novamente.', 'icon' => 'warning']);
    exit;
}

header('Content-Type: application/json; charset=utf-8');

// =================================================================
// --- ROTEADOR DE AÇÕES ---
// =================================================================

// ==================================================
// BLOCO DE CONTAGEM (ISOLADO - SÓ PRECISA DO DB.PHP)
// LÓGICA CORRIGIDA PARA A TABELA 'admin' (SEM 'is_banned')
// ==================================================
if (isset($_GET['acao']) && $_GET['acao'] == 'obter_contagens_revendedores') {
    
    $pdo = conectar_bd(); 
    $resposta = ['ativos' => 0, 'vencidos' => 0, 'bloqueados' => 0];

    try {
        if ($pdo === null) {
             throw new Exception("Não foi possível conectar ao banco de dados.");
        }
        
        $admin_id_logado = $_SESSION['admin_id'];
        
        // Filtro base: É um revendedor (admin=0) E foi criado pelo admin logado
        $filtro_base_sql = " AND admin = 0 AND criado_por = :admin_id";
        $params_base = [':admin_id' => $admin_id_logado];

        // 1. Revendedores BLOQUEADOS
        // (Lógica: Como não temos 'is_banned', vamos contar '0' por enquanto)
        // Se você adicionar a coluna 'is_banned' (INT(1) DEFAULT 0) na tabela 'admin',
        // esta query funcionará:
        // $sql_bloqueados = "SELECT COUNT(*) FROM admin WHERE is_banned = 1" . $filtro_base_sql;
        // $query_bloqueados = $pdo->prepare($sql_bloqueados);
        // $query_bloqueados->execute($params_base);
        // $cont_bloqueados = $query_bloqueados->fetchColumn();
        $cont_bloqueados = 0; // Temporário

        // 2. Revendedores ATIVOS
        // (Lógica: creditos > 0 E pertence a este admin)
        // (Assumindo que 'bloqueado' não interfere, já que a coluna não existe)
        $sql_ativos = "SELECT COUNT(*) FROM admin WHERE creditos > 0" . $filtro_base_sql;
        $query_ativos = $pdo->prepare($sql_ativos);
        $query_ativos->execute($params_base);
        $cont_ativos = $query_ativos->fetchColumn();

        // 3. Revendedores VENCIDOS (Sem Créditos)
        // (Lógica: creditos <= 0 E pertence a este admin)
        $sql_vencidos = "SELECT COUNT(*) FROM admin WHERE (creditos <= 0 OR creditos IS NULL)" . $filtro_base_sql;
        $query_vencidos = $pdo->prepare($sql_vencidos);
        $query_vencidos->execute($params_base);
        $cont_vencidos = $query_vencidos->fetchColumn();
        
        $resposta = [
            'ativos' => $cont_ativos,
            'vencidos' => $cont_vencidos,
            'bloqueados' => $cont_bloqueados
        ];

    } catch (Exception $e) {
        $msg = $e->getMessage();
        $resposta = ['title' => 'Erro de BD!', 'msg' => 'Não foi possível buscar as contagens (Revendedores). Erro: ' . $msg, 'icon' => 'error'];
    }

    echo json_encode($resposta, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_IGNORE);
    exit; // Termina o script aqui
}
// ==================================================
// FIM DO BLOCO DE CONTAGEM
// ==================================================


// --- SE NÃO FOR 'obter_contagens', CARREGA O RESTO ---
// (Isto vai carregar o ficheiro que acabámos de corrigir no Passo 1)
require_once('controles/funcoes_revendedores.php'); 


// --- Roteamento de Acoes (GET - DataTable) ---
if ($_SERVER['REQUEST_METHOD'] === 'GET' && (isset($_GET['draw']) || isset($_GET['listar_revendedores']))) {
    if (function_exists('listar_revendedores')) {
        $resultado = listar_revendedores($_REQUEST);
    } else {
        error_log("Erro critico: funcao listar_revendedores() nao encontrada.");
        $resultado = ["draw" => 0, "recordsTotal" => 0, "recordsFiltered" => 0, "data" => [], "error" => "Erro Interno: Funcao de listagem nao encontrada."];
    }
    
    $json_output = json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_IGNORE);
    echo $json_output;
    exit;
}

// --- Roteamento de Acoes (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $params = $_POST;
    
    // CORREÇÃO PHP 5.6 (Substitui array_key_first)
    reset($_POST);
    $action = key($_POST);
    
    if (!function_exists($action)) {
        $action = isset($_POST['acao']) ? $_POST['acao'] : (isset($_POST['action']) ? $_POST['action'] : null);
    }

    $resultado = ['title' => 'Erro!', 'msg' => 'Acao POST desconhecida: ' . htmlspecialchars($action), 'icon' => 'error'];

    if ($action && function_exists($action)) {
        $id_actions = ['add_creditos', 'edite_revendedor', 'delete_revendedor'];
        
        if (in_array($action, $id_actions)) {
            $id = isset($_POST['id']) ? $_POST['id'] : 0;
            $resultado = $action($id);
        }
        elseif (strpos($action, 'confirme_') === 0) {
            $resultado = $action($params);
        }
        elseif ($action === 'add_revendedor' || $action === 'edite_admin' || $action === 'edite_admin_revenda') {
            $resultado = $action();
        }
    }
    
    $json_output = json_encode($resultado, JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_IGNORE);
    echo $json_output;
    exit;
}

// Resposta padrão
echo json_encode(['title' => 'Método Inválido!', 'msg' => 'O método de requisição não é suportado.', 'icon' => 'error'], JSON_UNESCAPED_UNICODE | JSON_INVALID_UTF8_IGNORE);
?>
