<?php
/**
 * ARQUIVO API/TESTES.PHP - COMPLETO E CORRIGIDO (VERSÃO 17)
 * - Adicionada a lógica dos cards ('obter_contagens_testes') no topo.
 * - Corrigido o erro de PHP (array_key_first) para compatibilidade.
 * - Lógica de contagem isolada para evitar erros de 'Invalid JSON'.
 */

// --- CONFIGURAÇÃO E INICIALIZAÇÃO ---
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();

// --- DEPENDÊNCIA BÁSICA (SÓ O BANCO DE DADOS) ---
// (Necessário para o 'obter_contagens_testes' funcionar isolado)
require_once('./controles/db.php');

// --- VERIFICAÇÃO DE SEGURANÇA ---
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['title' => 'Erro de Autenticação!', 'msg' => 'Acesso negado. Por favor, faça login novamente.', 'icon' => 'error'], JSON_INVALID_UTF8_IGNORE);
    exit();
}

header('Content-Type: application/json; charset=utf-8');

// =================================================================
// --- ROTEADOR DE AÇÕES ---
// =================================================================

// ==================================================
// BLOCO DE CONTAGEM (ISOLADO - SÓ PRECISA DO DB.PHP)
// (Baseado na V15/V16 de clientes.php, que funcionou)
// ==================================================
if (isset($_GET['acao']) && $_GET['acao'] == 'obter_contagens_testes') {
    
    $pdo = conectar_bd(); 
    $resposta = ['ativos' => 0, 'vencidos' => 0, 'bloqueados' => 0];

    try {
        if ($pdo === null) {
             throw new Exception("Não foi possível conectar ao banco de dados.");
        }
        
        $admin_id = $_SESSION['admin_id'];
        $agora_php_formatado = date("Y-m-d H:i:s"); 
        
        // MUDANÇA PRINCIPAL: is_trial = 1
        $filtro_base_sql = " AND admin_id = :admin_id AND is_trial = 1 AND is_p2p = 0";
        $params_base = [':admin_id' => $admin_id];

        // 1. Testes BLOQUEADOS
        $sql_bloqueados = "SELECT COUNT(*) FROM clientes WHERE is_banned = 1" . $filtro_base_sql;
        $query_bloqueados = $pdo->prepare($sql_bloqueados);
        $query_bloqueados->execute($params_base);
        $cont_bloqueados = $query_bloqueados->fetchColumn();

        // 2. Testes ATIVOS
        $sql_ativos = "SELECT COUNT(*) FROM clientes WHERE (is_banned IS NULL OR is_banned = 0) AND Vencimento >= :agora" . $filtro_base_sql;
        $query_ativos = $pdo->prepare($sql_ativos);
        $query_ativos->execute(array_merge($params_base, [':agora' => $agora_php_formatado]));
        $cont_ativos = $query_ativos->fetchColumn();

        // 3. Testes VENCIDOS (Expirados)
        $sql_vencidos = "SELECT COUNT(*) FROM clientes WHERE (is_banned IS NULL OR is_banned = 0) AND Vencimento < :agora" . $filtro_base_sql;
        $query_vencidos = $pdo->prepare($sql_vencidos);
        $query_vencidos->execute(array_merge($params_base, [':agora' => $agora_php_formatado]));
        $cont_vencidos = $query_vencidos->fetchColumn();
        
        $resposta = [
            'ativos' => $cont_ativos,
            'vencidos' => $cont_vencidos,
            'bloqueados' => $cont_bloqueados
        ];

    } catch (Exception $e) {
        $msg = $e->getMessage();
        $msg_limpa = str_replace(dirname(__FILE__), '...', $msg);
        $resposta = ['title' => 'Erro de BD!', 'msg' => 'Não foi possível buscar as contagens. Erro: ' . $msg_limpa, 'icon' => 'error'];
    }

    echo json_encode($resposta, JSON_INVALID_UTF8_IGNORE);
    exit; // Termina o script aqui
}
// ==================================================
// FIM DO BLOCO DE CONTAGEM
// ==================================================


// --- SE NÃO FOR 'obter_contagens', CARREGA AS OUTRAS FUNÇÕES ---
// (O resto do seu script precisa disto)
require_once('./controles/clientes.php'); // <-- O seu ficheiro original incluía isto
require_once('./controles/funcoes_testes.php'); // <-- E isto


// --- Lida com requisições GET (Carregar a lista da tabela) ---
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (function_exists('listar_testes')) {
        echo json_encode(listar_testes($_REQUEST), JSON_INVALID_UTF8_IGNORE);
        exit();
    } else {
        echo json_encode(["draw" => 0, "recordsTotal" => 0, "recordsFiltered" => 0, "data" => [], "error" => "Função 'listar_testes' não encontrada."], JSON_INVALID_UTF8_IGNORE);
        exit();
    }
}

// --- Lida com requisições POST (todas as ações de botões) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // --- MANIPULADOR DINÂMICO CORRIGIDO (PHP 5.6+) ---
    // (Substitui o array_key_first que causa o erro fatal)
    reset($_POST);
    $action = key($_POST); 
    // --- FIM DA CORREÇÃO ---

    if ($action && function_exists($action)) {
        try {
            // Ações que recebem o array $_POST inteiro (formulários de confirmação)
            $full_post_actions = [
                'confirme_adicionar_testes', 
                'confirme_converter_teste',
                'confirme_delete_teste', 
                'confirme_add_tempo_testes', // Ação de clientes.php
                'confirme_delete_cliente'  // Ação de clientes.php
            ];
            
            // Ações que NÃO recebem nenhum argumento (cliques simples)
            $no_arg_actions = [
                'gerar_teste_rapido',
                'adicionar_testes'
            ];

            $result = null;

            if (in_array($action, $full_post_actions)) {
                $result = $action($_POST);
            } elseif (in_array($action, $no_arg_actions)) {
                $result = $action();
            } else { 
                $value = $_POST[$action];
                $result = $action($value);
            }
            
            echo json_encode($result, JSON_INVALID_UTF8_IGNORE);

        } catch (Exception $e) {
             error_log("Erro na API (" . $action . "): " . $e->getMessage());
             echo json_encode(['title' => 'Erro na Execução!', 'msg' => 'A ação encontrou um erro: ' . $e->getMessage(), 'icon' => 'error'], JSON_INVALID_UTF8_IGNORE);
        }
        
    } else {
        echo json_encode(['title' => 'Ação Inválida!', 'msg' => 'A operação solicitada não foi reconhecida pelo sistema.', 'icon' => 'error'], JSON_INVALID_UTF8_IGNORE);
    }
    exit();
}

// Resposta padrão
echo json_encode(['title' => 'Método Inválido!', 'msg' => 'O método de requisição não é suportado.', 'icon' => 'error'], JSON_INVALID_UTF8_IGNORE);
?>
