<?php
session_start();
// O seu menu.php é chamado aqui
require_once("menu.php"); 

// O caminho da API TEM de começar com /
$api_path = '/api/clientes.php'; 
?>
<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Área de Clientes</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="//cdn.datatables.net/2.0.7/css/dataTables.dataTables.min.css">
</head>
<body>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card border-success shadow-sm">
                <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-success">Clientes Ativos</h5><h3 id="count-ativos" class="mb-0">0</h3></div><i class="fas fa-user-check fa-3x text-success" style="opacity: 0.5;"></i></div></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-warning shadow-sm">
                <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-warning">Clientes Vencidos</h5><h3 id="count-vencidos" class="mb-0">0</h3></div><i class="fas fa-user-clock fa-3x text-warning" style="opacity: 0.5;"></i></div></div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-danger shadow-sm">
                <div class="card-body"><div class="d-flex justify-content-between align-items-center"><div><h5 class="card-title text-danger">Clientes Bloqueados</h5><h3 id="count-bloqueados" class="mb-0">0</h3></div><i class="fas fa-user-lock fa-3x text-danger" style="opacity: 0.5;"></i></div></div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4>Lista de Clientes</h4>
            <div>
                <button class="btn btn-primary" onclick='modal_master("<?php echo $api_path; ?>", "adicionar_clientes")'>
                    <i class="fas fa-plus"></i> Adicionar Cliente
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="tabela_clientes" class="display table table-striped table-hover" style="width:100%;">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>Nome</th>
                            <th>Usuário</th>
                            <th>Status</th>
                            <th>Vencimento</th>
                            <th style="min-width: 190px;">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_master" tabindex="-1" aria-hidden="true"><div class="modal-dialog modal-dialog-centered" role="document"><div class="modal-content"><div class="modal-header" id="modal_master-header"><h5 class="modal-title" id="modal_master-titulo"></h5><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div><div id="modal_master-body" class="modal-body p-4"></div><div id="modal_master-footer" class="modal-footer"></div></div></div></div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="//cdn.datatables.net/2.0.7/js/dataTables.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="/js/app.js"></script> 

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const API_URL = '<?php echo $api_path; ?>'; // '/api/clientes.php'
        
        // Toggle de Tema (O seu código)
        const themeToggleBtn = document.getElementById('theme-toggle');
        const themeIcon = document.getElementById('theme-icon'); 
        const htmlElement = document.documentElement;
        const applyTheme = (theme) => {
            htmlElement.setAttribute('data-bs-theme', theme);
            if (themeIcon) {
                themeIcon.className = theme === 'dark' ? 'fas fa-sun' : 'fas fa-moon';
            }
        };
        const savedTheme = localStorage.getItem('theme') || 'light';
        applyTheme(savedTheme);
        if (themeToggleBtn) {
            themeToggleBtn.addEventListener('click', () => {
                const newTheme = htmlElement.getAttribute('data-bs-theme') === 'dark' ? 'light' : 'dark';
                localStorage.setItem('theme', newTheme);
                applyTheme(newTheme);
            });
        }

        // ==================================================
        // CARREGAR AS CONTAGENS DOS CARDS (COM QUEBRA-CACHE)
        // ==================================================
        function carregarContagens() {
            $.ajax({
                url: API_URL, 
                type: 'GET',
                data: { 
                    acao: 'obter_contagens',
                    _cache: new Date().getTime() // O quebra-cache
                }, 
                dataType: 'json',
                success: function(response) {
                    if (response && typeof response === 'object' && !response.title) {
                        $('#count-ativos').text(response.ativos || 0);
                        $('#count-vencidos').text(response.vencidos || 0);
                        $('#count-bloqueados').text(response.bloqueados || 0);
                    } else if (response && response.title) {
                        console.error("Erro da API de Contagem:", response.msg);
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Erro fatal ao chamar API de Contagem:", xhr.responseText);
                    $('#count-ativos').text('X');
                    $('#count-vencidos').text('X');
                    $('#count-bloqueados').text('X');
                }
            });
        }
        
        carregarContagens();
        
        // ==================================================
        // O BLOCO DUPLICADO FOI REMOVIDO DAQUI.
        // O seu /js/app.js vai tratar da tabela.
        // ==================================================
        
    });
</script>

</body>
</html>
