<?php
// 1. Inclui o menu
require_once("menu.php");

// --- VERIFICAÇÃO DE CONFIGURAÇÃO ---
if (file_exists('api/controles/db.php')) {
    require_once('api/controles/db.php');
}
$pdo = conectar_bd();

// 1. Verifica se a cobrança está ativa no banco (1 = Sim, 0 = Não)
$stmt = $pdo->prepare("SELECT valor FROM painel_config WHERE chave = 'migracao_cobrar_credito'");
$stmt->execute();
$res = $stmt->fetchColumn();
// Se não existir configuração, assume 1 (cobrar) por segurança
$config_cobrar = ($res !== false) ? (int)$res : 1;

// 2. Verifica se é Admin Master (ID 11 ou Nivel 1) - Estes nunca pagam
$sou_admin_master = ($_SESSION['nivel_admin'] == 1 || $_SESSION['admin_id'] == 11);

// 3. Define se vai cobrar DESTE usuário específico
// Só cobra se a config for 1 E não for admin master
$vai_cobrar = ($config_cobrar == 1 && !$sou_admin_master);
?>

<style>
    /* CSS Adaptado para o Tema */
    .card-migracao {
        background-color: var(--bs-card-bg);
        border: 1px solid var(--bs-border-color);
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }

    .modo-selector {
        display: flex;
        gap: 15px;
        margin-bottom: 20px;
    }

    .modo-card {
        flex: 1;
        border: 2px solid var(--bs-border-color);
        border-radius: 10px;
        padding: 20px;
        cursor: pointer;
        transition: all 0.3s;
        text-align: center;
        background-color: var(--bs-card-bg);
    }

    .modo-card:hover {
        border-color: #0d6efd;
        transform: translateY(-2px);
    }

    .modo-card.active {
        border-color: #0d6efd;
        background-color: rgba(13, 110, 253, 0.1);
    }

    .modo-card i {
        font-size: 3rem;
        margin-bottom: 10px;
        color: #6c757d;
    }

    .modo-card.active i {
        color: #0d6efd;
    }
    
    h5, .form-label { color: var(--bs-heading-color); }
    p.text-muted, small.text-muted { color: var(--bs-secondary-color) !important; }

    /* Dark Mode */
    body.dark-mode .modo-card { background-color: #1e1e1e; border-color: #444; }
    body.dark-mode .modo-card.active { background-color: rgba(13, 110, 253, 0.2); border-color: #0d6efd; }
    body.dark-mode .modo-card h5 { color: #ffffff !important; }
    body.dark-mode .modo-card p { color: #b0b3b8 !important; }
    body.dark-mode .form-control { background-color: #2a2a2a; border-color: #444; color: #fff; }
    body.dark-mode .card-migracao { background-color: #1e1e1e; border-color: #333; }

    @media (max-width: 768px) {
        .card-migracao { border-radius: 0 !important; border: none !important; box-shadow: none !important; }
        .page-header { padding-left: 15px; padding-right: 15px; }
    }
</style>

<div class="container-fluid p-0 p-md-4">
    
    <div class="page-header mb-4 mt-3"> 
        <h1 class="h3 mb-0"><i class="bi bi-arrow-left-right me-2"></i>Migrar Clientes</h1>
        <p class="text-muted">Importe clientes de outros servidores via Link M3U ou API.</p>
    </div>

    <div class="card card-migracao shadow-sm">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0 text-white"><i class="bi bi-1-circle me-2"></i>Passo 1: Configuração</h5>
        </div>
        <div class="card-body p-4">
            <form id="formMigracao">
                
                <div class="modo-selector">
                    <div class="modo-card active" onclick="selecionarModo('individual')" id="cardIndividual">
                        <i class="bi bi-person"></i>
                        <h5>Individual</h5>
                        <p class="text-muted mb-0">Migrar 1 cliente</p>
                    </div>
                    <div class="modo-card" onclick="selecionarModo('massa')" id="cardMassa">
                        <i class="bi bi-people"></i>
                        <h5>Em Massa</h5>
                        <p class="text-muted mb-0">Lista de clientes</p>
                    </div>
                </div>
                
                <input type="hidden" name="modo" id="inputModo" value="individual">

                <div id="campoIndividual">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">URL do Cliente <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-lg" name="api_url" id="api_url" placeholder="Cole a URL aqui...">
                    </div>
                </div>

                <div id="campoMassa" style="display:none;">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">URLs dos Clientes <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="urls_massa" id="urls_massa" rows="8" placeholder="Uma URL por linha..."></textarea>
                    </div>
                </div>

                <?php if($vai_cobrar): ?>
                    <div class="alert alert-warning"><i class="bi bi-coin me-2"></i> <strong>Atenção:</strong> Esta operação consumirá créditos.</div>
                <?php else: ?>
                    <div class="alert alert-success"><i class="bi bi-check-circle me-2"></i> <strong>Grátis:</strong> A migração está gratuita no momento.</div>
                <?php endif; ?>

                <div class="d-flex justify-content-between align-items-center mt-4">
                    <a href="dashboard.php" class="btn btn-secondary"><i class="bi bi-arrow-left me-2"></i>Voltar</a>
                    <button type="submit" class="btn btn-primary btn-lg" id="btnImportar"><i class="bi bi-cloud-upload me-2"></i>Importar Agora</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once("footer.php"); ?>

<script>
    // Passa o status da cobrança para o JavaScript
    const VAI_COBRAR = <?= $vai_cobrar ? 'true' : 'false' ?>;

    function selecionarModo(modo) {
        document.querySelectorAll('.modo-card').forEach(c => c.classList.remove('active'));
        document.getElementById('campoIndividual').style.display = 'none';
        document.getElementById('campoMassa').style.display = 'none';
        
        if (modo === 'individual') {
            document.getElementById('cardIndividual').classList.add('active');
            document.getElementById('campoIndividual').style.display = 'block';
            document.getElementById('inputModo').value = 'individual';
        } else {
            document.getElementById('cardMassa').classList.add('active');
            document.getElementById('campoMassa').style.display = 'block';
            document.getElementById('inputModo').value = 'massa';
        }
    }

    document.getElementById('formMigracao').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const modo = document.getElementById('inputModo').value;
        let qtd = 1;

        // Validação e Contagem
        if (modo === 'individual') {
            if(!document.getElementById('api_url').value.trim()) return Swal.fire('Erro', 'Digite a URL.', 'error');
        } else {
            const texto = document.getElementById('urls_massa').value.trim();
            if(!texto) return Swal.fire('Erro', 'Cole as URLs.', 'error');
            qtd = texto.split(/\r\n|\r|\n/).filter(line => line.trim() !== '').length;
        }

        // --- LÓGICA DOS ALERTAS ---
        if (VAI_COBRAR) {
            // ALERTA DE COBRANÇA
            Swal.fire({
                title: 'Cobrança de Créditos',
                html: `Você vai importar <b>${qtd}</b> cliente(s).<br>Custo Total: <b style="color:red">${qtd} crédito(s)</b>.<br><br>Deseja continuar?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sim, Pagar e Importar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) executarMigracao();
            });
        } else {
            // ALERTA DE GRATUIDADE
            Swal.fire({
                title: 'Migração Gratuita',
                html: `Você vai importar <b>${qtd}</b> cliente(s).<br><b style="color:green">Custo: 0 créditos (Grátis).</b><br><br>Confirmar importação?`,
                icon: 'info',
                showCancelButton: true,
                confirmButtonColor: '#198754',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sim, Importar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) executarMigracao();
            });
        }
    });

    function executarMigracao() {
        const btn = document.getElementById('btnImportar');
        const originalText = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm"></span> Processando...';

        const formData = {
            modo: document.getElementById('inputModo').value,
            api_url: document.getElementById('api_url').value,
            urls_massa: document.getElementById('urls_massa').value
        };

        fetch('api/migrar_acao.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(formData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                Swal.fire('Sucesso!', data.message, 'success');
                document.getElementById('formMigracao').reset();
                selecionarModo('individual');
            } else {
                Swal.fire('Erro!', data.message, 'error');
            }
        })
        .catch(error => {
            console.error(error);
            Swal.fire('Erro', 'Falha na conexão.', 'error');
        })
        .finally(() => {
            btn.disabled = false;
            btn.innerHTML = originalText;
        });
    }
</script>