<?php
// 1. Inclui o seu menu
require_once("menu.php");
?>

<style>
    /* ... (Todo o seu CSS que já estava aqui - sem mudança) ... */
    
    .stream-logo {
        width: 24px; height: 24px; border-radius: 4px; margin-right: 8px;
        object-fit: cover; vertical-align: middle; background-color: #eee;
    }
    [data-theme="dark"] .stream-logo { background-color: #444; }
    .content-name { vertical-align: middle; }
    .bi-tv, .bi-film, .bi-collection-play { vertical-align: -2px; }
</style>

<div class="container-fluid py-4">
    <div class="page-header">
        <h1><i class="bi bi-broadcast me-2"></i>Usuários Online em Tempo Real</h1>
    </div>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-circle-fill text-success fs-1 pulse-dot"></i>
                    <h3 class="mt-2 mb-0" id="stat-online">0</h3>
                    <p class="text-muted mb-0">Conexões Ativas</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-person-fill fs-1 text-primary"></i>
                    <h3 class="mt-2 mb-0" id="stat-users">0</h3>
                    <p class="text-muted mb-0">Usuários Únicos</p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <i class="bi bi-globe fs-1 text-info"></i>
                    <h3 class="mt-2 mb-0" id="stat-ips">0</h3>
                    <p class="text-muted mb-0">IPs Únicos</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0"><i class="bi bi-wifi me-2"></i>Conexões Ativas Agora</h5>
            <div>
                <span class="badge bg-light text-dark" id="timer-badge">Atualizando em 10s...</span>
                <button type="button" class="btn btn-success btn-sm" id="btnAtualizar">
                    <i class="bi bi-arrow-clockwise me-1"></i>Atualizar
                </button>
            </div>
        </div>
        
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Usuário (ID)</th>
                            <th>IP</th>
                            <th>User Agent (Aplicativo)</th>
                            <th>Conteúdo Assistindo</th>
                            <th>Última Atividade</th>
                            <th class="text-center">Ação</th>
                        </tr>
                    </thead>
                    <tbody id="online-users-table">
                        <tr><td colspan="6" class="text-center p-4">Carregando...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
// 4. Inclui o seu footer
require_once("footer.php"); 
?>

<script>
    $(document).ready(function() {
        // ... (Variáveis e função fetchOnlineUsers - sem mudança) ...
        let timerInterval;
        let countdown = 10; 
        const timerBadge = $('#timer-badge');
        const tableBody = $('#online-users-table');
        const btnAtualizar = $('#btnAtualizar');

        function fetchOnlineUsers() {
            btnAtualizar.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');
            
            $.ajax({
                url: 'api/api_conexoes.php',
                type: 'POST',
                dataType: 'json',
                data: {
                    action: 'get_online_users',
                    token: (typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '')
                },
                success: function(response) {
                    if (response.status === 'success') {
                        updateTable(response.data);
                        updateStats(response.stats);
                    } else {
                        tableBody.html(`<tr><td colspan="6" class="text-center p-4 text-danger">${response.message || 'Erro ao carregar dados.'}</td></tr>`);
                    }
                },
                error: function(jqXHR) {
                    let errorMsg = 'Erro de comunicação com a API.';
                    if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                        errorMsg = jqXHR.responseJSON.message;
                    }
                    tableBody.html(`<tr><td colspan="6" class="text-center p-4 text-danger">${errorMsg}</td></tr>`);
                },
                complete: function() {
                    btnAtualizar.prop('disabled', false).html('<i class="bi bi-arrow-clockwise me-1"></i>Atualizar');
                    resetTimer();
                }
            });
        }

        // --- Função para Atualizar a Tabela [COM MUDANÇAS v11] ---
        function updateTable(users) {
            tableBody.empty(); 
            if (users.length === 0) {
                tableBody.html('<tr><td colspan="6" class="text-center p-4 text-muted">Nenhum usuário online no momento.</td></tr>');
                return;
            }

            users.forEach(user => {
                let userAgent = user.user_agent || 'Desconhecido';
                if (userAgent.length > 50) {
                    userAgent = userAgent.substring(0, 50) + '...';
                }

                // ... (Lógica do Conteúdo - sem mudança) ...
                let conteudoHtml = '<span class="text-muted">N/A</span>';
                if (user.stream_display_name) {
                    let logoIcon = 'bi-question-circle'; 
                    let tipoBadge = '';
                    if (user.stream_type === 'live') {
                        tipoBadge = '<span class="badge bg-danger ms-2">Canal</span>';
                        logoIcon = 'bi-tv';
                    } else if (user.stream_type === 'movie') {
                        tipoBadge = '<span class="badge bg-primary ms-2">Filme</span>';
                        logoIcon = 'bi-film';
                    } else if (user.stream_type === 'series') {
                        tipoBadge = '<span class="badge bg-success ms-2">Série</span>';
                        logoIcon = 'bi-collection-play';
                    }
                    let logoHtml = `<i class="bi ${logoIcon} me-2"></i>`;
                    conteudoHtml = `${logoHtml} <span class="content-name">${user.stream_display_name}</span> ${tipoBadge}`;
                }
                
                // ==================================================
                // [NOVA LÓGICA v11] - Badge de Múltiplas Conexões
                // ==================================================
                let userHtml = `<strong>${user.usuario || 'N/A'}</strong> (${user.userid || 'N/A'})`;
                
                // A API agora envia 'user.total_conexoes'
                if (user.total_conexoes > 1) {
                    userHtml += ` <span class="badge bg-warning text-dark ms-2" title="Este usuário tem ${user.total_conexoes} conexões ativas">${user.total_conexoes} Conexões</span>`;
                }
                // ==================================================
                
                const row = `
                    <tr>
                        <td>${userHtml}</td> <td>${user.ip || 'N/A'}</td>
                        <td><small>${userAgent}</small></td>
                        <td>${conteudoHtml}</td> 
                        <td>${user.ultima_atividade || 'N/A'}</td>
                        <td class="text-center">
                            <button class="btn btn-danger btn-sm btn-kick" data-id="${user.id}" data-user="${user.usuario}" title="Derrubar Conexão">
                                <i class="bi bi-x-circle-fill"></i>
                            </button>
                        </td>
                    </tr>
                `;
                tableBody.append(row);
            });
        }

        // ... (Função updateStats - sem mudança) ...
        function updateStats(stats) {
            $('#stat-online').text(stats.conexoes_ativas);
            $('#stat-users').text(stats.usuarios_unicos);
            $('#stat-ips').text(stats.ips_unicos);
        }

        // ... (Função btn-kick - sem mudança) ...
        tableBody.on('click', '.btn-kick', function() {
            const connectionId = $(this).data('id');
            const userName = $(this).data('user') || 'este usuário';
            
            Swal.fire({
                title: 'Tem certeza?',
                text: `Você quer derrubar a conexão de ${userName}?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sim, derrubar!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    clearInterval(timerInterval);
                    timerBadge.text('Pausado...');
                    $.ajax({
                        url: 'api/api_conexoes.php', 
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            action: 'kick_user',
                            id: connectionId,
                            token: (typeof SESSION_TOKEN !== 'undefined' ? SESSION_TOKEN : '')
                        },
                        success: function(response) {
                            if (response.status === 'success') {
                                Swal.fire('Derrubado!', response.message, 'success');
                            } else {
                                Swal.fire('Erro!', response.message, 'error');
                            }
                        },
                        error: function() {
                            Swal.fire('Erro!', 'Não foi possível se comunicar com a API.', 'error');
                        },
                        complete: function() {
                            fetchOnlineUsers(); 
                        }
                    });
                }
            });
        });

        // ... (Funções de Timer e Carga Inicial - sem mudança) ...
        function startTimer() {
            countdown = 10;
            timerBadge.text(`Atualizando em ${countdown}s...`).removeClass('bg-danger').addClass('bg-light text-dark');
            clearInterval(timerInterval); 
            timerInterval = setInterval(() => {
                countdown--;
                if (countdown > 0) {
                    timerBadge.text(`Atualizando em ${countdown}s...`);
                } else {
                    clearInterval(timerInterval);
                    timerBadge.text('Atualizando...');
                    fetchOnlineUsers();
                }
            }, 1000);
        }
        function resetTimer() {
            clearInterval(timerInterval);
            startTimer();
        }
        btnAtualizar.on('click', function() {
            clearInterval(timerInterval);
            timerBadge.text('Atualizando...');
            fetchOnlineUsers();
        });
        fetchOnlineUsers();
    });
</script>