<?php
session_start();
// É crucial que a conexão com o banco de dados e as funções de busca sejam carregadas
require_once('./api/controles/db.php');
require_once('./api/controles/dashboard.php'); // Onde estão as funções Dashboard(), testes(), etc.

// 1. Carrega os dados que são para TODOS (Clientes e Vencimentos)
$dadosAtivos = Dashboard();
$dadosTestes = testes();
$dadosVencimentos = getDadosVencimentos(7); // Busca dados para os próximos 7 dias

// 2. SÓ CARREGA os dados de Admin SE o utilizador for Admin
$conteudos = ['TotalLiveStreams' => 0, 'TotalMovieStreams' => 0, 'TotalSeries' => 0, 'TotalEpisodes' => 0]; // Valores padrão
$is_admin = (isset($_SESSION['nivel_admin']) && $_SESSION['nivel_admin'] == 1);

if ($is_admin) {
    // Esta função só é chamada se for o Admin, evitando erros para Revendedores
    $conteudos = conteudos(); 
}

// 3. Carrega o Menu (que inicia o HTML)
require_once("menu.php"); 
?>

<style>
/* Estilos para a seção de Vencimentos (O SEU ESTILO ORIGINAL) */
.summary-card.v2 {
    display: flex;
    align-items: center;
    padding: 20px;
    border-radius: 8px;
    color: #fff;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    background-color: var(--bs-card-bg);
}
.summary-card.v2:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
}
.summary-card.v2 .icon { font-size: 2.5rem; margin-right: 15px; opacity: 0.8; }
.summary-card.v2 .info { flex-grow: 1; }
.summary-card.v2 .value { font-size: 1.8rem; font-weight: bold; margin-bottom: 0; }
.summary-card.v2 .label { font-size: 0.9rem; opacity: 0.9; }
.summary-card.v2.card-danger { background: linear-gradient(45deg, #dc3545, #e04a5a); }
.summary-card.v2.card-warning {
    background: linear-gradient(45deg, #ffc107, #ffcd39);
    color: #343a40;
}
.summary-card.v2.card-warning .icon,
.summary-card.v2.card-warning .label { color: rgba(52, 58, 64, 0.8); }
.summary-card.v2.card-success { background: linear-gradient(45deg, #198754, #21a566); }

/* Alerta e Tabela (Seu estilo original) */
.alert-elegant {
    border-left: 5px solid var(--bs-warning);
    border-radius: 8px;
    background-color: var(--bs-body-bg);
    color: var(--bs-body-color);
    box-shadow: 0 2px 4px rgba(0,0,0,.05);
}
.alert-elegant .fas { color: var(--bs-warning); }
.status-badge {
    padding: .3em .6em;
    border-radius: .375rem;
    font-size: 0.75em;
    font-weight: bold;
    text-transform: uppercase;
}
.status-badge.status-bloqueado { background-color: #f8d7da; color: #721c24; }
.status-badge.status-ativo { background-color: #d4edda; color: #155724; }
.table-vencimentos thead th {
    border-bottom: 2px solid var(--bs-border-color);
    background-color: var(--bs-body-bg);
}
.table-vencimentos tbody tr { transition: background-color 0.1s ease-in-out; }
.table-vencimentos tbody tr:hover { background-color: var(--bs-tertiary-bg); }
.table-vencimentos td { vertical-align: middle; }


/* CSS DOS NOVOS CARDS (V24 - NÚMEROS CORRIGIDOS) */
.stat-card {
    border: none;
    border-left-width: 5px;
    border-left-style: solid;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
    border-radius: 8px; 
}
.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 6px 16px rgba(0, 0, 0, 0.08);
}
.stat-card .card-body {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem; 
}
.stat-info .stat-label {
    font-size: 0.9rem;
    color: #adb5bd; 
    text-transform: uppercase;
    font-weight: 700;
}
.stat-info .stat-value {
    font-size: 2.25rem;
    font-weight: 700;
    margin: 0;
    color: var(--bs-heading-color); 
}
.stat-icon {
    font-size: 3.5rem;
    opacity: 0.15;
}

/* Variações de Cor (Label e Ícone) */
.stat-card.card-tv { border-color: #fd7e14; }
.stat-card.card-tv .stat-label,
.stat-card.card-tv .stat-icon { color: #fd7e14; }

.stat-card.card-filmes { border-color: #20c997; }
.stat-card.card-filmes .stat-label,
.stat-card.card-filmes .stat-icon { color: #20c997; }

.stat-card.card-series { border-color: #d63384; }
.stat-card.card-series .stat-label,
.stat-card.card-series .stat-icon { color: #d63384; }

.stat-card.card-episodios { border-color: #6f42c1; }
.stat-card.card-episodios .stat-label,
.stat-card.card-episodios .stat-icon { color: #6f42c1; }

.stat-card.card-clientes { border-color: #0d6efd; }
.stat-card.card-clientes .stat-label,
.stat-card.card-clientes .stat-icon { color: #0d6efd; }

.stat-card.card-vendidos { border-color: #6c757d; }
.stat-card.card-vendidos .stat-label,
.stat-card.card-vendidos .stat-icon { color: #6c757d; }

.stat-card.card-receber { border-color: #198754; }
.stat-card.card-receber .stat-label,
.stat-card.card-receber .stat-icon { color: #198754; }

.stat-card.card-testes { border-color: #ffc107; }
.stat-card.card-testes .stat-label,
.stat-card.card-testes .stat-icon { color: #ffc107; }

.stat-card.card-novos { border-color: #0dcaf0; }
.stat-card.card-novos .stat-label,
.stat-card.card-novos .stat-icon { color: #0dcaf0; }

.stat-card.card-vencidos { border-color: #dc3545; }
.stat-card.card-vencidos .stat-label,
.stat-card.card-vencidos .stat-icon { color: #dc3545; }


/* CSS para os Gráficos de Recursos (CPU/RAM/DISCO) */
.resource-card .circular-progress {
    position: relative;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    display: grid;
    place-items: center;
    background: conic-gradient(var(--bs-primary) calc(var(--value, 0) * 1%), var(--bs-tertiary-bg) 0);
    transition: background 0.3s;
}
.resource-card .circular-progress:before {
    content: "";
    position: absolute;
    width: 100px;
    height: 100px;
    background-color: var(--bs-card-bg);
    border-radius: 50%;
}
.resource-card .progress-value {
    position: relative;
    font-size: 1.5rem;
    font-weight: 600;
    color: var(--bs-primary);
}

/* CSS DO RODAPÉ (V25) */
.version-footer {
    text-align: center;
    padding: 20px 0;
    color: var(--bs-secondary-color); 
    font-size: 0.85rem;
    border-top: 1px solid var(--bs-border-color-translucent);
    margin-top: 2rem;
}
.version-footer p {
    margin: 5px 0;
}
.update-button {
    font-weight: 600;
    color: var(--bs-primary); 
    text-decoration: none;
    background-color: var(--bs-tertiary-bg);
    padding: 5px 12px;
    border-radius: 20px; 
    transition: all 0.2s ease;
    font-size: 0.8rem;
    margin: 5px 0; 
    display: inline-block; 
}
.update-button:hover {
    background-color: var(--bs-primary);
    color: var(--bs-white); 
}
.modal-changelog .modal-body {
    height: 60vh;
}
.modal-changelog iframe {
    width: 100%;
    height: 100%;
    border: none;
}

</style>

<div class="container-fluid p-0"> 
    <div class="page-header">
        <h1 class="h3 mb-0"><i class="fas fa-tachometer-alt me-2"></i>Dashboard</h1>
        <p class="text-muted mb-0">Bem-vindo, <?php echo isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : ''; ?>!</p>
    </div>

    <?php if ($is_admin): ?>
    <div class="row">
        <div class="col-12"><h4 class="mb-3">Resumo do Conteúdo</h4></div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card stat-card card-tv h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Canais</div><p class="stat-value"><?php echo $conteudos['TotalLiveStreams']; ?></p></div><div class="stat-icon"><i class="fa-solid fa-tv"></i></div></div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card stat-card card-filmes h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Filmes</div><p class="stat-value"><?php echo $conteudos['TotalMovieStreams']; ?></p></div><div class="stat-icon"><i class="fa-solid fa-film"></i></div></div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card stat-card card-series h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Séries</div><p class="stat-value"><?php echo $conteudos['TotalSeries']; ?></p></div><div class="stat-icon"><i class="fa-solid fa-clapperboard"></i></div></div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-4">
            <div class="card stat-card card-episodios h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Episódios</div><p class="stat-value"><?php echo $conteudos['TotalEpisodes']; ?></p></div><div class="stat-icon"><i class="fa-solid fa-photo-film"></i></div></div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    
    <div class="row mt-3">
        <div class="col-12"><h4 class="mb-3">Resumo de Clientes</h4></div>
        
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="card stat-card card-clientes h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Clientes IPTV Ativos</div><p class="stat-value"><?php echo $dadosAtivos['clientesAtivos']; ?></p></div><div class="stat-icon"><i class="fa-solid fa-users"></i></div></div>
            </div>
        </div>

        <div class="col-md-6 col-lg-4 mb-4">
            <div class="card stat-card card-novos h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Clientes P2P Ativos</div><p class="stat-value"><?php echo $dadosAtivos['clientesP2PAtivos'] ?? 0; ?></p></div><div class="stat-icon"><i class="fa-solid fa-user-shield"></i></div></div>
            </div>
        </div>
        
        <div class="col-md-6 col-lg-4 mb-4">
            <div class="card stat-card card-testes h-100">
                <div class="card-body"><div class="stat-info"><div class="stat-label">Testes Ativos</div><p class="stat-value"><?php echo $dadosTestes['TestesAtivos']; ?></p></div><div class="stat-icon"><i class="fa-solid fa-vial"></i></div></div>
            </div>
        </div>
        
        </div>
    <?php if ($is_admin): ?>
    <div class="row mt-4">
        <div class="col-12"><h4 class="mb-3">Recursos do Servidor</h4></div>
        <div class="col-md-4 mb-4">
            <div class="card resource-card h-100">
                <div class="card-body text-center"><div class="circular-progress" id="cpu-progress"><span class="progress-value">0%</span></div><h6 class="mt-3 mb-0">Utilização de CPU</h6></div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card resource-card h-100">
                <div class="card-body text-center"><div class="circular-progress" id="ram-progress"><span class="progress-value">0%</span></div><h6 class="mt-3 mb-0">Utilização de RAM</h6></div>
            </div>
        </div>
        <div class="col-md-4 mb-4">
            <div class="card resource-card h-100">
                <div class="card-body text-center"><div class="circular-progress" id="disk-progress"><span class="progress-value">0%</span></div><h6 class="mt-3 mb-0">Uso do Disco '/'</h6></div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <div class="row mt-4">
        <div class="col-12 d-flex justify-content-between align-items-center mb-3">
            <h4 class="mb-0"><i class="fas fa-calendar-alt me-2"></i>Vencimento dos Clientes</h4>
            <div class="d-flex gap-2">
                <select id="refresh-interval" class="form-select form-select-sm" style="width: auto;">
                    <option value="30">30 segundos</option><option value="60">1 minuto</option><option value="300">5 minutos</option><option value="0" selected>Nunca</option>
                </select>
                <button id="update-btn" class="btn btn-sm btn-primary">
                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                    <i class="fas fa-sync-alt"></i>
                    <span class="ms-1 d-none d-md-inline">Atualizar</span>
                </button>
            </div>
        </div>
    </div>
    
    <div class="alert alert-warning alert-elegant mb-4" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>Clientes com vencimento próximo ou atrasado.
    </div>
    
    <div class="row">
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card summary-card v2 card-danger h-100">
                <div class="icon"><i class="fas fa-user-times"></i></div>
                <div class="info">
                    <div class="value" id="nao-renovados-count"><?php echo $dadosVencimentos['nao_renovados_count']; ?></div>
                    <div class="label">Não Renovados (Atrasados)</div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-6 mb-4">
            <div class="card summary-card v2 card-warning h-100">
                <div class="icon"><i class="fas fa-user-clock"></i></div>
                <div class="info">
                    <div class="value" id="proximos-vencimentos-count"><?php echo $dadosVencimentos['proximos_vencimentos_count']; ?></div>
                    <div class="label">Próximos Vencimentos</div>
                </div>
            </div>
        </div>
        <div class="col-lg-4 col-md-12 mb-4">
            <div class="card summary-card v2 card-success h-100">
                <div class="icon"><i class="fas fa-wallet"></i></div>
                <div class="info">
                    <div class="value" id="valor-total-receber">R$ <?php echo number_format($dadosVencimentos['valor_total_a_receber'], 2, ',', '.'); ?></div>
                    <div class="label">Valor Total a Receber</div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card mt-3">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 table-vencimentos">
                    <thead>
                        <tr>
                            <th class="py-3 px-3">NOME DO CLIENTE</th>
                            <th>TELEFONE</th>
                            <th>VENCIMENTO</th>
                            <th>STATUS</th>
                            <th>VALOR</th>
                            <th class="text-end px-3">AÇÕES</th>
                        </tr>
                    </thead>
                    <tbody id="tabela-vencimentos-body">
                        <tr><td colspan="6" class="text-center text-muted py-4">A carregar dados dos clientes...</td></tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    </div>

<div class="version-footer">
    <p>Versão atual: 4.1.23</p>
    <p class="copyright">© <?php echo date("Y"); ?> <?php echo isset($config['title']) ? htmlspecialchars($config['title']) : 'Office Xtream'; ?> | Todos os direitos reservados.</p>
</div>
<div class="modal fade modal-changelog" id="changelogModal" tabindex="-1" aria-labelledby="changelogModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="changelogModalLabel">Notas de Atualização</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <iframe id="changelog-iframe" src="about:blank" title="Changelog"></iframe>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function() {
    
    const IS_ADMIN = <?php echo json_encode($is_admin); ?>;

    // SÓ EXECUTA O SCRIPT DO SERVIDOR SE FOR ADMIN
    if (IS_ADMIN) {
        const cpuProgress = document.getElementById('cpu-progress');
        const ramProgress = document.getElementById('ram-progress');
        const diskProgress = document.getElementById('disk-progress');
        
        if (cpuProgress && ramProgress && diskProgress) {
            const cpuValue = cpuProgress.querySelector('.progress-value');
            const ramValue = ramProgress.querySelector('.progress-value');
            const diskValue = diskProgress.querySelector('.progress-value');
            
            function updateServerStats() {
                fetch('api/get_server_stats.php')
                    .then(response => response.ok ? response.json() : Promise.reject('Resposta de rede não foi ok'))
                    .then(data => {
                        cpuValue.textContent = data.cpu + '%'; cpuProgress.style.setProperty('--value', data.cpu);
                        ramValue.textContent = data.ram + '%'; ramProgress.style.setProperty('--value', data.ram);
                        diskValue.textContent = data.disk + '%'; diskProgress.style.setProperty('--value', data.disk);
                    })
                    .catch(error => { 
                        console.error('Erro ao buscar estatísticas do servidor:', error); 
                        cpuValue.textContent = 'N/A'; ramValue.textContent = 'N/A'; diskValue.textContent = 'N/A'; 
                    });
            }
            updateServerStats(); 
            setInterval(updateServerStats, 5000); 
        }
    }

    // SCRIPT PARA A SEÇÃO DE VENCIMENTOS (Roda para todos)
    const intervalSelect = document.getElementById('refresh-interval');
    const updateBtn = document.getElementById('update-btn');
    const tabelaBody = document.getElementById('tabela-vencimentos-body');
    let refreshTimer = null;

    // Esta função (updateVencimentosSection) continua aqui,
    // mas ela só será usada para a CARGA INICIAL da tabela.
    async function updateVencimentosSection() {
        if(!updateBtn || !tabelaBody) return; 
        
        // Mostra um 'placeholder' enquanto carrega pela primeira vez
        tabelaBody.innerHTML = '<tr><td colspan="6" class="text-center text-muted py-4">A carregar dados dos clientes...</td></tr>';
        
        // Esconde o botão de atualizar durante a carga inicial
        updateBtn.classList.add('d-none'); 

        try {
            const response = await fetch('api/get_vencimentos_data.php');
            if (!response.ok) { throw new Error(`Erro na rede: ${response.statusText}`); }
            const data = await response.json();

            // Atualiza os 3 cards de vencimentos
            document.getElementById('nao-renovados-count').textContent = data.nao_renovados_count;
            document.getElementById('proximos-vencimentos-count').textContent = data.proximos_vencimentos_count;
            document.getElementById('valor-total-receber').textContent = `R$ ${parseFloat(data.valor_total_a_receber).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}`;

            tabelaBody.innerHTML = ''; 

            if (data.lista_vencidos && data.lista_vencidos.length > 0) {
                data.lista_vencidos.forEach(cliente => {
                    const nomeCliente = cliente.name || cliente.usuario;
                    const telefoneLimpo = '55' + (cliente.telefone || '').replace(/\D/g, '');
                    const valorTotal = parseFloat(cliente.V_total).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    const vencimentoFormatado = new Date(cliente.Vencimento.replace(/-/g, '\/')).toLocaleDateString('pt-BR');

                    let statusHtml = '';
                    if (cliente.status === 'Atrasado') {
                        statusHtml = `
                            <td>
                                ${vencimentoFormatado}
                                <small class="d-block text-danger">(atrasado ${cliente.dias_atrasado} dias)</small>
                            </td>
                            <td><span class="status-badge status-bloqueado">Bloqueado (${cliente.dias_atrasado} dias)</span></td>
                        `;
                    } else {
                        let textoDias = cliente.dias_para_vencer === 0 ? 'Vence hoje' : (cliente.dias_para_vencer === 1 ? 'Vence amanhã' : `Vence em ${cliente.dias_para_vencer} dias`);
                        statusHtml = `
                            <td>
                                ${vencimentoFormatado}
                                <small class="d-block text-success">(${textoDias})</small>
                            </td>
                            <td><span class="status-badge status-ativo">Ativo</span></td>
                        `;
                    }
                    
                    const rowHTML = `
                        <tr>
                            <td class="px-3">
                                <strong>${nomeCliente}</strong>
                                <small class="d-block text-muted">${cliente.usuario}</small>
                            </td>
                            <td>${cliente.telefone || 'N/A'}</td>
                            ${statusHtml}
                            <td>R$ ${valorTotal}</td>
                            <td class="text-end px-3">
                                <a href="https://wa.me/${telefoneLimpo}" target="_blank" class="btn btn-sm btn-outline-success">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                                <button class="btn btn-sm btn-outline-success ms-1" title="Renovar" onclick="modal_master('/api/clientes.php', 'renovar_cliente', ${cliente.id})">
                                    <i class="fas fa-retweet"></i>
                                </button>
                            </td>
                        </tr>
                    `;
                    tabelaBody.insertAdjacentHTML('beforeend', rowHTML);
                });
            } else {
                tabelaBody.innerHTML = '<tr><td colspan="6" class="text-center text-muted py-4">Nenhum cliente vencido ou vencendo nos próximos 7 dias.</td></tr>';
            }
        } catch (error) {
            console.error('Erro ao atualizar seção de vencimentos:', error);
            tabelaBody.innerHTML = `<tr><td colspan="6" class="text-center text-danger py-4">Erro ao carregar dados: ${error.message}</td></tr>`;
        } finally {
            // Mostra o botão de volta quando a carga inicial termina
            updateBtn.classList.remove('d-none');
        }
    }
    
    // --- INÍCIO DA CORREÇÃO ---
    // Nova função para mostrar o spinner e RECARREGAR A PÁGINA
    function reloadPageWithSpinner() {
        if (!updateBtn) return;

        const spinner = updateBtn.querySelector('.spinner-border');
        const btnContent = updateBtn.querySelector('span.ms-1');
        const btnIcon = updateBtn.querySelector('i.fa-sync-alt');

        // Mostra o spinner e desabilita o botão
        if (spinner) spinner.classList.remove('d-none');
        if (btnContent) btnContent.classList.add('d-none');
        if (btnIcon) btnIcon.classList.add('d-none');
        updateBtn.disabled = true;

        // Recarrega a página
        location.reload();
    }

    // Altera o clique do botão para chamar a nova função de recarregar
    updateBtn.addEventListener('click', reloadPageWithSpinner);

    // Altera o seletor de intervalo para também recarregar
    intervalSelect.addEventListener('change', function() {
        if (refreshTimer) {
            clearInterval(refreshTimer);
            refreshTimer = null;
        }
        const interval = parseInt(this.value, 10);
        if (interval > 0) {
            // Em vez de chamar updateVencimentosSection, ele vai chamar o reload
            refreshTimer = setInterval(reloadPageWithSpinner, interval * 1000);
        }
    });
    // --- FIM DA CORREÇÃO ---


    // Carga inicial (Mantém como estava, para carregar a tabela na 1ª vez)
    // Isso é importante para a página não ficar vazia esperando o usuário clicar
    updateVencimentosSection();
    
});
</script>
<?php 
require_once("footer.php"); // Carrega o rodapé e fecha o HTML
?>