﻿<?php
// Inclui o menu e o cabeçalho do seu painel
require_once 'menu.php';

// CORREÇÃO: Pega o token da sessão atual para usar no JavaScript
// Se não tiver token na sessão, deixa vazio (vai dar erro na API, mas evita erro de JS)
$token_sessao = isset($_SESSION['token']) ? $_SESSION['token'] : '';
?>

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    var SESSION_TOKEN = "<?php echo $token_sessao; ?>";
</script>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Excluir Listas Expiradas / Testes</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8 col-md-10 mx-auto">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-4">Configurações de Exclusão em Massa</h5>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i> Atenção: Esta ferramenta remove permanentemente usuários do banco de dados. Use com cautela.
                    </div>
                    
                    <form id="form_excluir_listas">
                        <div class="mb-4">
                            <label for="daterange" class="form-label fw-bold">1. Selecione o período de vencimento:</label>
                            <input type="text" id="daterange" name="daterange" class="form-control" placeholder="Clique para selecionar as datas" autocomplete="off" />
                        </div>

                        <div class="mb-4">
                            <label class="form-label fw-bold">2. O que você deseja excluir?</label>
                            
                            <div class="form-check mb-2">
                                <input class="form-check-input" type="checkbox" name="tipos[]" value="testes" id="check_testes">
                                <label class="form-check-label" for="check_testes">
                                    <strong>Testes Vencidos</strong> (usuários trial com vencimento passado)
                                </label>
                            </div>
                            
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="tipos[]" value="expiradas" id="check_expiradas">
                                <label class="form-check-label" for="check_expiradas">
                                    <strong>Clientes Expirados</strong> (usuários oficiais com vencimento passado)
                                </label>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-danger w-100 py-2 fw-bold">
                            <i class="fas fa-trash-alt me-2"></i> EXCLUIR SELECIONADOS
                        </button>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(function() {
    // 1. Configuração do Calendário (Em Português)
    $('#daterange').daterangepicker({
        opens: 'center',
        autoUpdateInput: false, // Começa vazio para obrigar o usuário a escolher
        locale: {
          format: 'DD/MM/YYYY',
          separator: ' - ',
          applyLabel: 'Aplicar',
          cancelLabel: 'Limpar',
          fromLabel: 'De',
          toLabel: 'Até',
          customRangeLabel: 'Personalizado',
          weekLabel: 'S',
          daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sáb'],
          monthNames: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
          firstDay: 1
        }
    });

    // Eventos para preencher o input apenas quando clicar em Aplicar
    $('#daterange').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD/MM/YYYY') + ' - ' + picker.endDate.format('DD/MM/YYYY'));
    });
    $('#daterange').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });

    // 2. Envio do Formulário
    $('#form_excluir_listas').on('submit', function(e) {
        e.preventDefault(); 

        // Validações Básicas no Frontend
        if ($('#daterange').val() == '') {
            Swal.fire('Atenção', 'Por favor, selecione o intervalo de datas.', 'warning');
            return;
        }

        if ($('input[name="tipos[]"]:checked').length == 0) {
            Swal.fire('Atenção', 'Selecione pelo menos um tipo de lista (Testes ou Expiradas).', 'warning');
            return;
        }

        // Confirmação Forte
        Swal.fire({
            title: 'ATENÇÃO: AÇÃO IRREVERSÍVEL',
            html: "Você está prestes a apagar permanentemente as contas vencidas selecionadas.<br>Não há lixeira. Deseja continuar?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Sim, EXCLUIR TUDO',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var formData = $(this).serialize();
                // Garante que o token vai junto
                var token = (typeof SESSION_TOKEN !== 'undefined') ? SESSION_TOKEN : '';

                $.ajax({
                    type: 'POST',
                    url: 'api/acoes_excluir.php', // Caminho relativo para a API
                    data: formData + '&action=excluir_listas&token=' + token,
                    dataType: 'text', // IMPORTANTE: Recebe como TEXTO para debugar erros do servidor
                    beforeSend: function() {
                        Swal.fire({
                            title: 'Processando...',
                            html: 'Aguarde, limpando banco de dados.',
                            allowOutsideClick: false,
                            didOpen: () => { Swal.showLoading(); }
                        });
                    },
                    success: function(responseRaw) {
                        try {
                            // Tenta converter o texto recebido em JSON
                            var response = JSON.parse(responseRaw);
                            
                            if (response.status === 'success') {
                                Swal.fire('Sucesso!', response.message, 'success').then(() => {
                                    // Opcional: Recarregar página
                                    // location.reload();
                                });
                            } else {
                                Swal.fire('Erro!', response.message, 'error');
                            }
                        } catch (e) {
                            // SE CAIR AQUI, O SERVIDOR ENVIOU LIXO (Ex: "1" ou erro PHP na tela)
                            console.error("Erro ao processar JSON:", e);
                            console.log("Resposta Bruta:", responseRaw);
                            
                            Swal.fire({
                                icon: 'error',
                                title: 'Resposta Inválida do Servidor',
                                html: 'O servidor não retornou um JSON válido.<br><b>Conteúdo recebido:</b> <pre style="text-align:left; background:#eee; padding:5px; margin-top:10px;">' + responseRaw + '</pre>'
                            });
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error(xhr);
                        var msg = 'Erro de conexão (HTTP ' + xhr.status + ')';
                        if (xhr.status == 404) msg = 'Arquivo api/acoes_excluir.php não encontrado.';
                        Swal.fire('Erro Crítico', msg, 'error');
                    }
                });
            }
        });
    });
});
</script>