<?php
// Inclui o arquivo de conexão e verifica a sessão/login (DEVE SER IGUAL AO SEU SCRIPT PRINCIPAL)
$db_path = '../api/controles/db.php';
if (!file_exists($db_path)) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Arquivo de conexão não encontrado.']));
}
require_once($db_path);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['logged_in_fxtream']) || $_SESSION['logged_in_fxtream'] !== true) {
    http_response_code(401);
    die(json_encode(['status' => 'error', 'message' => 'Acesso não autorizado.']));
}

header('Content-Type: application/json');

try {
    $pdo = conectar_bd();
    if (!$pdo) {
        http_response_code(500);
        die(json_encode(['status' => 'error', 'message' => 'Falha ao conectar ao banco de dados.']));
    }
} catch (Exception $e) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Erro de BD: ' . $e->getMessage()]));
}

// ------------------------------------------------
// LÓGICA DE AÇÃO
// ------------------------------------------------

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'kill_individual':
        // Ação para matar uma conexão específica (por IP e Usuário)
        $usuario = $_POST['usuario'] ?? null;
        $ip = $_POST['ip'] ?? null;

        if (empty($usuario) || empty($ip)) {
            http_response_code(400);
            die(json_encode(['status' => 'error', 'message' => 'Dados incompletos para matar a conexão.']));
        }

        try {
            // Usa o usuário E o IP para garantir que apenas aquela conexão/sessão seja excluída
            $sql = "DELETE FROM conexoes WHERE usuario = :usuario AND ip = :ip";
            $stmt = $pdo->prepare($sql);
            $stmt->bindValue(':usuario', $usuario);
            $stmt->bindValue(':ip', $ip);
            $stmt->execute();

            $rowCount = $stmt->rowCount();

            if ($rowCount > 0) {
                echo json_encode(['status' => 'success', 'message' => "Conexão de **{$usuario}** (IP: **{$ip}**) finalizada."]);
            } else {
                echo json_encode(['status' => 'warning', 'message' => "Nenhuma conexão encontrada com os dados fornecidos."]);
            }

        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => 'Erro ao matar conexão: ' . $e->getMessage()]);
        }
        break;

    case 'kill_all':
        // Ação para matar TODAS as conexões ativas (respeitando o filtro de revendedor)
        $loggedInUserId = $_SESSION['admin_id'] ?? 0;
        $userLevel = $_SESSION['nivel_admin'] ?? 0;
        
        // Se for revendedor, só mata as conexões dos seus clientes.
        $reseller_filter_sql = '';
        if ($userLevel != 1) {
            // Filtra pelo admin_id do cliente associado à conexão
            $reseller_filter_sql = " JOIN clientes c ON conexoes.usuario = c.usuario WHERE c.admin_id = :admin_id ";
        } else {
            // Se for admin principal (nível 1), mata todas.
            $reseller_filter_sql = " WHERE 1=1 "; 
        }

        try {
            // NOTA: Usar JOIN no DELETE requer a sintaxe: DELETE t1 FROM t1 JOIN t2 ON ...
            $sql = "DELETE conexoes FROM conexoes {$reseller_filter_sql}";

            $stmt = $pdo->prepare($sql);
            if ($userLevel != 1) {
                $stmt->bindValue(':admin_id', $loggedInUserId, PDO::PARAM_INT);
            }
            $stmt->execute();

            $rowCount = $stmt->rowCount();

            echo json_encode(['status' => 'success', 'message' => "Todas as **{$rowCount}** conexões ativas foram finalizadas!"]);

        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => 'Erro ao matar todas as conexões: ' . $e->getMessage()]);
        }
        break;

    default:
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Ação inválida ou ausente.']);
        break;
}

?>