<?php
// ARQUIVO: /gerenciador/ajax/canais_mover_massa.php
header('Content-Type: application/json');

// O caminho para o db.php, subindo dois níveis (de /ajax/ para /gerenciador/ e para a raiz)
require_once('../../api/controles/db.php');

$response = ['success' => false, 'message' => 'Ocorreu um erro inesperado.'];

$channel_ids = $_POST['ids'] ?? [];
$category_id = isset($_POST['category_id']) ? (int)$_POST['category_id'] : 0;

if (empty($channel_ids) || $category_id === 0) {
    $response['message'] = 'Nenhum canal selecionado ou categoria de destino inválida.';
    http_response_code(400);
    echo json_encode($response);
    exit();
}

try {
    $pdo = conectar_bd();
    $pdo->beginTransaction();

    // Prepara a query para atualizar a categoria dos canais selecionados
    $placeholders = implode(',', array_fill(0, count($channel_ids), '?'));
    $sql = "UPDATE streams SET category_id = ? WHERE id IN ($placeholders)";
    $params = array_merge([$category_id], $channel_ids);

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);

    $pdo->commit();
    
    $response['success'] = true;
    $response['message'] = count($channel_ids) . ' canal(is) movido(s) com sucesso!';
    
} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = 'Erro no servidor: ' . $e->getMessage();
    http_response_code(500);
}

echo json_encode($response);
?>