<?php
// ARQUIVO: /gerenciador/ajax/filmes_excluir_massa.php
// (VERSÃO CORRIGIDA PARA LER JSON E COM CAMINHOS CERTOS)

header('Content-Type: application/json');

// 1. Captura os dados enviados pelo JavaScript (JSON)
$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

// Se não veio JSON, tenta pegar do POST normal (fallback)
if (json_last_error() !== JSON_ERROR_NONE) {
    $ids = $_POST['ids'] ?? null;
} else {
    $ids = $input['ids'] ?? null;
}

$response = ['success' => false, 'message' => 'Erro desconhecido.'];

if (empty($ids) || !is_array($ids)) {
    echo json_encode(['success' => false, 'message' => 'Nenhum filme selecionado.']);
    exit;
}

// Limpa os IDs para garantir que são números
$ids_para_excluir = array_map('intval', $ids);
$ids_para_excluir = array_filter($ids_para_excluir, fn($id) => $id > 0);

if (empty($ids_para_excluir)) {
    echo json_encode(['success' => false, 'message' => 'IDs inválidos.']);
    exit;
}

try {
    // 2. Conexão ao Banco de Dados
    // Ajuste o caminho conforme a estrutura real das suas pastas
    // Se este arquivo está em /gerenciador/ajax/, subir 2 níveis chega na raiz
    $db_path = '../../api/controles/db.php';
    
    if (!file_exists($db_path)) {
        throw new Exception("Arquivo de banco de dados não encontrado em: $db_path");
    }
    
    require_once($db_path);
    $pdo = conectar_bd();

    if (!$pdo) {
        throw new Exception("Falha na conexão com o banco de dados.");
    }

    // 3. Executa a exclusão
    // Cria uma string de interrogações para o SQL (ex: ?,?,?)
    $placeholders = implode(',', array_fill(0, count($ids_para_excluir), '?'));
    
    // Tabela 'streams' é onde ficam os filmes no Xtream UI
    $sql = "DELETE FROM streams WHERE id IN ($placeholders)";
    $stmt = $pdo->prepare($sql);
    
    if ($stmt->execute($ids_para_excluir)) {
        $count = $stmt->rowCount();
        echo json_encode([
            'success' => true, 
            'message' => "$count filme(s) excluído(s) com sucesso!"
        ]);
    } else {
        throw new Exception("O banco de dados recusou a exclusão.");
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false, 
        'message' => 'Erro: ' . $e->getMessage()
    ]);
}
?>