<?php
// ARQUIVO: /ajax/filmes_mover_massa.php
header('Content-Type: application/json');

require_once('../../api/controles/db.php');

$response = ['success' => false, 'message' => 'Ocorreu um erro inesperado.'];

$movie_ids = $_POST['ids'] ?? [];
$category_id = isset($_POST['category_id']) ? (int)$_POST['category_id'] : 0;

if (empty($movie_ids) || $category_id === 0) {
    $response['message'] = 'Nenhum filme selecionado ou categoria de destino inválida.';
    http_response_code(400);
    echo json_encode($response);
    exit();
}

try {
    $pdo = conectar_bd();
    $pdo->beginTransaction();

    $placeholders = implode(',', array_fill(0, count($movie_ids), '?'));
    $sql = "UPDATE streams SET category_id = ? WHERE id IN ($placeholders)";
    $params = array_merge([$category_id], $movie_ids);

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);

    $pdo->commit();
    
    $response['success'] = true;
    $response['message'] = count($movie_ids) . ' filme(s) movido(s) com sucesso!';
    
} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = 'Erro no servidor: ' . $e->getMessage();
    http_response_code(500);
}

echo json_encode($response);
?>