<?php
// ARQUIVO: /gerenciador/ajax/series_mover_massa.php
header('Content-Type: application/json');

// O caminho para o db.php, subindo dois níveis
require_once('../../api/controles/db.php');

$response = ['success' => false, 'message' => 'Ocorreu um erro inesperado.'];

$serie_ids = $_POST['ids'] ?? [];
$category_id = isset($_POST['category_id']) ? (int)$_POST['category_id'] : 0;

if (empty($serie_ids) || $category_id === 0) {
    $response['message'] = 'Nenhuma série selecionada ou categoria de destino inválida.';
    http_response_code(400);
    echo json_encode($response);
    exit();
}

try {
    $pdo = conectar_bd();
    $pdo->beginTransaction();

    // Prepara a query para atualizar a categoria das SÉRIES selecionadas
    $placeholders = implode(',', array_fill(0, count($serie_ids), '?'));
    $sql = "UPDATE series SET category_id = ? WHERE id IN ($placeholders)"; // <-- ATENÇÃO AQUI!
    $params = array_merge([$category_id], $serie_ids);

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);

    $pdo->commit();
    
    $response['success'] = true;
    $response['message'] = count($serie_ids) . ' série(s) movida(s) com sucesso!';
    
} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    $response['message'] = 'Erro no servidor: ' . $e->getMessage();
    http_response_code(500);
}

echo json_encode($response);
?>