<?php
// ARQUIVO: /gerenciador/episodio_adicionar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

$season_id = filter_input(INPUT_GET, 'season_id', FILTER_VALIDATE_INT);
if (!$season_id) { die("ID da temporada inválido."); }

$stmt_season = $pdo->prepare("SELECT series_id FROM series_seasons WHERE id = ?");
$stmt_season->execute([$season_id]);
$temporada = $stmt_season->fetch(PDO::FETCH_ASSOC);

if (!$temporada) { die("Temporada não encontrada."); }
$series_id = $temporada['series_id'];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Adicionar Novo Episódio</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header, body.dark-mode h4, body.dark-mode .form-label { color: #ffffff; }
        body.dark-mode .form-control { background-color: #2a2a2a; border-color: #3c3c3c; color: #e0e0e0; }
        body.dark-mode .form-control:focus { background-color: #2a2a2a; border-color: #0d6efd; color: #e0e0e0; }
    </style>
</head>
<body>
<div class="container mt-4">
    <div class="card">
        <div class="card-header"><h4><i class="fas fa-plus me-2"></i>Adicionar Episódio</h4></div>
        <div class="card-body">
            <form action="episodio_salvar.php" method="POST">
                <input type="hidden" name="season_id" value="<?= htmlspecialchars($season_id) ?>">
                <input type="hidden" name="series_id" value="<?= htmlspecialchars($series_id) ?>">
                <div class="row">
                    <div class="col-md-8 mb-3"><label for="title" class="form-label">Título</label><input type="text" class="form-control" id="title" name="title" required></div>
                    <div class="col-md-4 mb-3"><label for="episode_num" class="form-label">Número</label><input type="number" class="form-control" id="episode_num" name="episode_num" required></div>
                </div>
                <div class="mb-3"><label for="link" class="form-label">Link/Caminho</label><input type="text" class="form-control" id="link" name="link"></div>
                <div class="mb-3"><label for="plot" class="form-label">Sinopse</label><textarea class="form-control" id="plot" name="plot" rows="3"></textarea></div>
                <div class="row">
                    <div class="col-md-6 mb-3"><label for="duration_secs" class="form-label">Duração (segundos)</label><input type="number" class="form-control" id="duration_secs" name="duration_secs"></div>
                    <div class="col-md-6 mb-3"><label for="cover_big" class="form-label">URL da Capa</label><input type="text" class="form-control" id="cover_big" name="cover_big"></div>
                </div>
                <a href="episodios_gerenciar.php?season_id=<?= htmlspecialchars($season_id) ?>" class="btn btn-secondary">Cancelar</a>
                <button type="submit" class="btn btn-primary">Salvar Episódio</button>
            </form>
        </div>
    </div>
</div>
<script>(function() { const themeKey = 'theme'; function applyTheme() { const savedTheme = localStorage.getItem(themeKey); document.body.classList.toggle('dark-mode', savedTheme === 'dark'); } applyTheme(); })();</script>
</body>
</html>