<?php
// ARQUIVO: /gerenciador/episodio_atualizar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso negado.");
}

$id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
$season_id = filter_input(INPUT_POST, 'season_id', FILTER_VALIDATE_INT);
// Outros campos
$title = trim($_POST['title'] ?? '');
$episode_num = filter_input(INPUT_POST, 'episode_num', FILTER_VALIDATE_INT);
$link = trim($_POST['link'] ?? '');
$plot = trim($_POST['plot'] ?? '');
$duration_secs = filter_input(INPUT_POST, 'duration_secs', FILTER_VALIDATE_INT);
$cover_big = trim($_POST['cover_big'] ?? '');

if (!$id || !$season_id || !$title || $episode_num === false) {
    die("Dados obrigatórios faltando.");
}

try {
    $sql = "UPDATE series_episodes SET 
                title = ?, episode_num = ?, link = ?, plot = ?, duration_secs = ?, cover_big = ? 
            WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $title, $episode_num, $link, $plot, $duration_secs, $cover_big, $id
    ]);

    header("Location: episodios_gerenciar.php?season_id=" . $season_id);
    exit();
} catch (PDOException $e) {
    die("Erro ao atualizar o episódio: " . $e->getMessage());
}
?>