<?php
// ARQUIVO: /gerenciador/episodio_salvar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso negado.");
}

// Estes IDs são para o BD e para o redirecionamento
$season_id = filter_input(INPUT_POST, 'season_id', FILTER_VALIDATE_INT); // ID único da temporada (ex: 456), usado para voltar
$series_id = filter_input(INPUT_POST, 'series_id', FILTER_VALIDATE_INT); // ID da série (ex: 120)

// --- CORREÇÃO 1: Ler o campo 'season_number' do formulário ---
// Este é o NÚMERO da temporada (ex: 1), que deve ser salvo na coluna 'season'
$season_number = filter_input(INPUT_POST, 'season_number', FILTER_VALIDATE_INT);
// --- FIM DA CORREÇÃO 1 ---

// Outros campos do formulário
$title = trim($_POST['title'] ?? '');
$episode_num = filter_input(INPUT_POST, 'episode_num', FILTER_VALIDATE_INT);
$link = trim($_POST['link'] ?? '');
$plot = trim($_POST['plot'] ?? '');
$duration_secs = filter_input(INPUT_POST, 'duration_secs', FILTER_VALIDATE_INT);
$cover_big = trim($_POST['cover_big'] ?? '');
$added_timestamp = time(); // Data atual

// Validamos o season_number (se é 'false', significa que não foi enviado ou é inválido)
if (!$season_id || !$series_id || !$title || $episode_num === false || $season_number === false) {
    die("Dados obrigatórios faltando. (series_id, season_number, title, episode_num ou season_id de retorno)");
}

try {
    $sql = "INSERT INTO series_episodes 
                (series_id, season, episode_num, title, link, plot, duration_secs, cover_big, added, container_extension) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    
    // --- CORREÇÃO 2: Usar $season_number no lugar de $season_id ---
    // O segundo '?' corresponde à coluna 'season', que agora recebe o NÚMERO da temporada
    $stmt->execute([
        $series_id, $season_number, $episode_num, $title, $link, $plot, $duration_secs, $cover_big, $added_timestamp, 'mp4' // mp4 como padrão
    ]);
    // --- FIM DA CORREÇÃO 2 ---

    // Redireciona de volta usando o season_id (ID da tabela seasons), que está correto para a URL
    header("Location: episodios_gerenciar.php?season_id=" . $season_id);
    exit();
} catch (PDOException $e) {
    die("Erro ao salvar o episódio: " . $e->getMessage());
}
?>