<?php
// ARQUIVO: /gerenciador/episodio_salvar.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Acesso negado.");
}

$season_id = filter_input(INPUT_POST, 'season_id', FILTER_VALIDATE_INT);
$series_id = filter_input(INPUT_POST, 'series_id', FILTER_VALIDATE_INT);
// Outros campos do formulário
$title = trim($_POST['title'] ?? '');
$episode_num = filter_input(INPUT_POST, 'episode_num', FILTER_VALIDATE_INT);
$link = trim($_POST['link'] ?? '');
$plot = trim($_POST['plot'] ?? '');
$duration_secs = filter_input(INPUT_POST, 'duration_secs', FILTER_VALIDATE_INT);
$cover_big = trim($_POST['cover_big'] ?? '');
$added_timestamp = time(); // Data atual

if (!$season_id || !$series_id || !$title || $episode_num === false) {
    die("Dados obrigatórios faltando.");
}

try {
    $sql = "INSERT INTO series_episodes 
                (series_id, season, episode_num, title, link, plot, duration_secs, cover_big, added, container_extension) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $series_id, $season_id, $episode_num, $title, $link, $plot, $duration_secs, $cover_big, $added_timestamp, 'mp4' // mp4 como padrão
    ]);

    header("Location: episodios_gerenciar.php?season_id=" . $season_id);
    exit();
} catch (PDOException $e) {
    die("Erro ao salvar o episódio: " . $e->getMessage());
}
?>