<?php
// ARQUIVO: /gerenciador/filme_editar.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../api/controles/db.php';
$pdo = conectar_bd();

// =========================================================
// ⚠️ COLOQUE SUA CHAVE TMDB ABAIXO ENTRE AS ASPAS ⚠️
// =========================================================
$tmdb_api_key = "f99aa9ae1fe7619969cc7db0938c1ae5"; 
// Exemplo: $tmdb_api_key = "a1b2c3d4e5f6...";
// =========================================================

$tmdb_api_language = "pt-BR"; 

$error = '';
$success = '';
$filme = [];

// 1. Busca os dados do filme
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = (int)$_GET['id'];
    
    // Verifica colunas do banco
    $cols_check = $pdo->query("SHOW COLUMNS FROM streams LIKE 'direct_source'");
    $has_direct = $cols_check->fetch() ? true : false;
    $sql_field_link = $has_direct ? ", direct_source" : "";
    
    $stmt = $pdo->prepare("SELECT id, name, description, stream_icon, link, tmdb_id, year, category_id $sql_field_link FROM streams WHERE id = ? AND stream_type = 'movie'");
    $stmt->execute([$id]);
    $filme = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$filme) {
        die("Filme não encontrado.");
    }
    
    // Unifica o link
    if (empty($filme['link']) && !empty($filme['direct_source'])) {
        $filme['link'] = $filme['direct_source'];
    }
} else {
    header('Location: filmes.php');
    exit;
}

// 2. Processa a atualização
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $name = $_POST['name'] ?? '';
    $description = $_POST['plot'] ?? ''; 
    if(empty($description)) $description = $_POST['description'] ?? '';

    $stream_icon = $_POST['stream_icon'] ?? '';
    $link = $_POST['link'] ?? '';
    $tmdb_id = $_POST['tmdb_id'] ?? null;
    $year = $_POST['year'] ?? '';
    $category_id = $_POST['category_id'] ?? null;

    if (empty($name) || empty($link) || empty($category_id)) {
        $error = 'Nome, Link e Categoria são obrigatórios.';
    } else {
        $columns_update = "name = ?, description = ?, stream_icon = ?, tmdb_id = ?, year = ?, category_id = ?";
        $values_update = [$name, $description, $stream_icon, $tmdb_id, $year, $category_id];

        $cols_check = $pdo->query("SHOW COLUMNS FROM streams LIKE 'direct_source'");
        if ($cols_check->fetch()) {
            $columns_update .= ", direct_source = ?";
            $values_update[] = $link;
        } else {
            $columns_update .= ", link = ?";
            $values_update[] = $link;
        }

        $values_update[] = $id;

        $stmt = $pdo->prepare("UPDATE streams SET $columns_update WHERE id = ?");
        
        if ($stmt->execute($values_update)) {
            $success = "Filme atualizado com sucesso!";
            $filme['name'] = $name;
            $filme['description'] = $description;
            $filme['stream_icon'] = $stream_icon;
            $filme['link'] = $link;
            $filme['tmdb_id'] = $tmdb_id;
            $filme['year'] = $year;
            $filme['category_id'] = $category_id;
        } else {
            $error = "Erro ao atualizar no banco de dados.";
        }
    }
}

$categorias = $pdo->query("SELECT id, nome FROM categoria WHERE type = 'movie' ORDER BY nome")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Filme</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        /* TEMA CLARO */
        body { background-color: #f0f2f5; color: #333; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .form-label { font-weight: bold; color: #333; }
        .poster-preview { max-width: 100%; height: auto; max-height: 400px; border-radius: 8px; margin-top: 10px; display: block; object-fit: contain; background-color: #e9ecef; }
        
        /* TEMA ESCURO */
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header { background-color: #1e1e1e !important; border-bottom: 1px solid #2c2c2c; }
        body.dark-mode .card-header h4 { color: #ffffff; }
        
        body.dark-mode .form-label { color: #f0f0f0 !important; } 
        body.dark-mode .form-control, 
        body.dark-mode .form-select, 
        body.dark-mode .input-group-text { 
            background-color: #2a2a2a; 
            color: #ffffff !important; 
            border-color: #444; 
        }
        body.dark-mode .form-control::placeholder { color: #aaa; opacity: 1; }
        body.dark-mode .text-muted { color: #adb5bd !important; }
        
        /* TMDB */
        .tmdb-search-results {
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid var(--bs-border-color);
            border-radius: 5px;
            background-color: var(--bs-body-bg);
            margin-top: 5px;
        }
        body.dark-mode .tmdb-search-results { background-color: #2a2a2a; border-color: #444; }
        .tmdb-search-results .list-group-item { cursor: pointer; border: none; background-color: transparent; display: flex; align-items: center; color: inherit; }
        .tmdb-search-results .list-group-item:hover { background-color: rgba(13, 110, 253, 0.2); }
        
        body.dark-mode #theme-toggle-btn { background-color: #2a2a2a; color: #e0e0e0; border-color: #3c3c3c; }
    </style>
</head>
<body>
    <div class="container p-md-4 p-2">
        
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header p-3 d-flex justify-content-between align-items-center">
                <h4 class="mb-0"><i class="fas fa-edit me-2"></i>Editar Filme</h4>
                <div>
                    <button id="theme-toggle-btn" class="btn btn-outline-secondary me-2"><i class="fas fa-moon"></i></button>
                    <a href="filmes.php" class="btn btn-secondary">Voltar</a>
                </div>
            </div>
            <div class="card-body p-4">

                <h5 class="mb-3" style="color: inherit;">Buscar informações (TMDB)</h5>
                <div class="input-group mb-3">
                    <input type="text" id="tmdbSearchInput" class="form-control" placeholder="Digite o nome do filme...">
                    <button class="btn btn-info text-white" type="button" id="searchButton"><i class="fas fa-search"></i> Buscar</button>
                </div>
                <div id="tmdbResults" class="list-group mb-4"></div>

                <hr class="my-4">

                <form method="POST" id="editMovieForm">
                    <input type="hidden" name="id" value="<?= htmlspecialchars($filme['id'] ?? '') ?>">
                    
                    <div class="row g-3">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="name" class="form-label">Título do Filme:</label>
                                <input type="text" class="form-control form-control-lg" id="name" name="name" value="<?= htmlspecialchars($filme['name'] ?? '') ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="plot" class="form-label">Sinopse:</label>
                                <textarea class="form-control" id="plot" name="plot" rows="5"><?= htmlspecialchars($filme['description'] ?? '') ?></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="link" class="form-label">URL do Stream (Vídeo):</label>
                                <input type="url" class="form-control" id="link" name="link" value="<?= htmlspecialchars($filme['link'] ?? '') ?>" required>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="stream_icon" class="form-label">Capa (Poster URL):</label>
                                <input type="url" class="form-control" id="stream_icon" name="stream_icon" value="<?= htmlspecialchars($filme['stream_icon'] ?? '') ?>" oninput="document.getElementById('posterPreview').src = this.value">
                                <img id="posterPreview" src="<?= htmlspecialchars($filme['stream_icon'] ?? '') ?: 'https://via.placeholder.com/200x300?text=Sem+Imagem' ?>" class="poster-preview">
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 mt-2">
                        <div class="col-md-4">
                            <label for="tmdb_id" class="form-label">TMDB ID:</label>
                            <input type="text" class="form-control" id="tmdb_id" name="tmdb_id" value="<?= htmlspecialchars($filme['tmdb_id'] ?? '') ?>">
                        </div>
                        <div class="col-md-4">
                            <label for="year" class="form-label">Ano:</label>
                            <input type="text" class="form-control" id="year" name="year" value="<?= htmlspecialchars($filme['year'] ?? '') ?>">
                        </div>
                        <div class="col-md-4">
                            <label for="category_id" class="form-label">Categoria:</label>
                            <select class="form-select" id="category_id" name="category_id" required>
                                <option value="">Selecione</option>
                                <?php foreach ($categorias as $cat): ?>
                                    <option value="<?= htmlspecialchars($cat['id']) ?>" <?= ($filme['category_id'] == $cat['id']) ? 'selected' : '' ?>><?= htmlspecialchars($cat['nome']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="d-grid mt-4">
                        <button type="submit" class="btn btn-success btn-lg"><i class="fas fa-save me-2"></i> Salvar Alterações</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // TEMA
        (function() {
            const themeKey = 'theme';
            function applyTheme() {
                const isDark = localStorage.getItem(themeKey) === 'dark';
                document.body.classList.toggle('dark-mode', isDark);
                const btn = document.getElementById('theme-toggle-btn');
                if(btn) btn.innerHTML = isDark ? '<i class="fas fa-sun"></i>' : '<i class="fas fa-moon"></i>';
            }
            applyTheme();
            document.addEventListener('DOMContentLoaded', () => {
                const btn = document.getElementById('theme-toggle-btn');
                if (btn) btn.addEventListener('click', () => {
                    const isDark = document.body.classList.contains('dark-mode');
                    localStorage.setItem(themeKey, isDark ? 'light' : 'dark');
                    applyTheme();
                });
            });
        })();

        // TMDB
        const TMDB_API_KEY = "<?= $tmdb_api_key ?>"; 
        const TMDB_LANG = "<?= $tmdb_api_language ?>";

        async function searchTmdb() {
            const query = document.getElementById('tmdbSearchInput').value;
            const resultsDiv = document.getElementById('tmdbResults');
            
            if (query.length < 2) return;
            
            // Se a chave estiver vazia ou for o texto padrão, avisa
            if (!TMDB_API_KEY || TMDB_API_KEY === "SUA_CHAVE_TMDB_AQUI") {
                resultsDiv.innerHTML = '<div class="list-group-item list-group-item-danger">API Key não configurada no PHP. Edite o arquivo.</div>';
                resultsDiv.classList.remove('d-none');
                return;
            }

            resultsDiv.innerHTML = '<div class="list-group-item">Buscando...</div>';
            
            try {
                const res = await fetch(`https://api.themoviedb.org/3/search/movie?api_key=${TMDB_API_KEY}&language=${TMDB_LANG}&query=${encodeURIComponent(query)}`);
                const data = await res.json();
                
                resultsDiv.innerHTML = '';
                
                if (data.results && data.results.length > 0) {
                    data.results.slice(0, 5).forEach(movie => {
                        const poster = movie.poster_path ? `https://image.tmdb.org/t/p/w92${movie.poster_path}` : 'https://via.placeholder.com/50x75';
                        const year = movie.release_date ? movie.release_date.split('-')[0] : 'N/A';
                        
                        const item = document.createElement('a');
                        item.className = 'list-group-item list-group-item-action tmdb-result d-flex align-items-center';
                        item.href = '#';
                        item.innerHTML = `
                            <img src="${poster}" class="me-3 rounded" width="50">
                            <div>
                                <strong>${movie.title}</strong> (${year})
                                <div class="small text-muted">${movie.overview ? movie.overview.substring(0, 60) + '...' : ''}</div>
                            </div>
                        `;
                        item.onclick = (e) => {
                            e.preventDefault();
                            fillForm(movie);
                            resultsDiv.innerHTML = '';
                        };
                        resultsDiv.appendChild(item);
                    });
                } else {
                    resultsDiv.innerHTML = '<div class="list-group-item">Nenhum filme encontrado.</div>';
                }
            } catch (e) {
                resultsDiv.innerHTML = '<div class="list-group-item list-group-item-danger">Erro na busca. Verifique sua conexão ou API Key.</div>';
            }
        }

        function fillForm(movie) {
            document.getElementById('name').value = movie.title;
            document.getElementById('plot').value = movie.overview;
            document.getElementById('tmdb_id').value = movie.id;
            document.getElementById('year').value = movie.release_date ? movie.release_date.split('-')[0] : '';
            
            if (movie.poster_path) {
                const url = `https://image.tmdb.org/t/p/w600_and_h900_bestv2${movie.poster_path}`;
                document.getElementById('stream_icon').value = url;
                document.getElementById('posterPreview').src = url;
            }
        }

        document.getElementById('searchButton').addEventListener('click', searchTmdb);
        document.getElementById('tmdbSearchInput').addEventListener('keyup', (e) => {
            if(e.key === 'Enter') searchTmdb();
        });
    </script>
</body>
</html>