<?php
// ARQUIVO: /gerenciador/serie_episodios.php
require_once('../api/controles/db.php');
$pdo = conectar_bd();

$series_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$series_id) { die("ID da série inválido ou não fornecido."); }

$stmt_serie = $pdo->prepare("SELECT name FROM series WHERE id = ?");
$stmt_serie->execute([$series_id]);
$serie = $stmt_serie->fetch(PDO::FETCH_ASSOC);

if (!$serie) { die("Série não encontrada."); }

$stmt_seasons = $pdo->prepare("SELECT * FROM series_seasons WHERE series_id = ? ORDER BY season_number ASC");
$stmt_seasons->execute([$series_id]);
$temporadas = $stmt_seasons->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Temporadas e Episódios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body { background-color: #f0f2f5; }
        .card { border: none; border-radius: 0.75rem; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .action-btn { width: 38px; height: 38px; border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin: 0 3px; border: none; color: white; text-decoration: none; transition: transform 0.2s; cursor: pointer; }
        .btn-episodes { background-color: #ffc107; } .btn-edit { background-color: #0d6efd; } .btn-delete { background-color: #dc3545; }
        .poster-img { height: 70px; width: auto; max-width: 50px; object-fit: cover; border-radius: 5px; background-color: #e9ecef; }
        
        /* Estilos do tema escuro */
        body.dark-mode { background-color: #121212; color: #e0e0e0; }
        body.dark-mode .card { background-color: #1e1e1e; border: 1px solid #2c2c2c; }
        body.dark-mode .card-header, body.dark-mode h4 { color: #ffffff; }
        body.dark-mode .table { color: #e0e0e0; } 
        body.dark-mode .table-light { --bs-table-bg: #2a2a2a; --bs-table-border-color: #3c3c3c; color: #ffffff; }
        body.dark-mode .table-hover tbody tr:hover { background-color: #2c2c2c; }
        body.dark-mode .table .table-light th { color: #f8f9fa; font-weight: 600; }

        /* ===== CORREÇÕES FINAIS DE VISIBILIDADE ADICIONADAS AQUI ===== */
        body.dark-mode .table {
            --bs-table-bg: transparent; /* Torna o fundo da tabela transparente */
            --bs-table-border-color: #3c3c3c; /* Define a cor das linhas da tabela */
        }
        body.dark-mode td {
            color: #e0e0e0; /* Garante que o texto nas células seja claro */
        }
    </style>
</head>
<body>
    <div class="container-fluid p-md-4 p-2">
        <div class="card">
            <div class="card-header bg-white p-3 d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-0"><i class="fas fa-list-ol me-2"></i>Temporadas de: <strong><?= htmlspecialchars($serie['name']) ?></strong></h4>
                    <a href="series.php" class="btn btn-sm btn-outline-secondary mt-2"><i class="fas fa-arrow-left me-2"></i>Voltar para Séries</a>
                </div>
                <a href="temporada_adicionar.php?series_id=<?= htmlspecialchars($series_id) ?>" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Nova Temporada
                </a>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <button id="bulkDeleteButton" class="btn btn-danger" style="display: none;"><i class="fas fa-trash-alt me-2"></i>Excluir Selecionadas</button>
                </div>

                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="selectAllCheckbox"></th>
                                <th>Capa</th>
                                <th>Nome da Temporada</th>
                                <th class="text-center">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($temporadas)): ?>
                                <tr><td colspan="4" class="text-center">Nenhuma temporada encontrada para esta série.</td></tr>
                            <?php else: foreach ($temporadas as $temp): ?>
                            <tr id="temporada-row-<?= htmlspecialchars($temp['id']) ?>">
                                <td><input type="checkbox" class="form-check-input row-checkbox" data-id="<?= htmlspecialchars($temp['id']) ?>"></td>
                                <td><img src="<?= htmlspecialchars($temp['cover'] ?? 'placeholder.jpg') ?>" class="poster-img" alt="Capa"></td>
                                <td><?= htmlspecialchars($temp['name']) ?> (Temporada <?= htmlspecialchars($temp['season_number']) ?>)</td>
                                <td class="text-center">
                                    <a href="episodios_gerenciar.php?season_id=<?= htmlspecialchars($temp['id']) ?>" class="action-btn btn-episodes" title="Gerenciar Episódios"><i class="fas fa-film"></i></a>
                                    <a href="temporada_editar.php?id=<?= htmlspecialchars($temp['id']) ?>" class="action-btn btn-edit" title="Editar Temporada"><i class="fas fa-pencil-alt"></i></a>
                                    <button onclick="deleteTemporada(<?= htmlspecialchars($temp['id']) ?>, '<?= htmlspecialchars(addslashes($temp['name'])) ?>')" class="action-btn btn-delete" title="Excluir Temporada"><i class="fas fa-trash"></i></button>
                                </td>
                            </tr>
                            <?php endforeach; endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // --- JAVASCRIPT DO TEMA (sem alterações) ---
    (function() { const themeKey = 'theme'; function applyTheme() { const savedTheme = localStorage.getItem(themeKey); document.body.classList.toggle('dark-mode', savedTheme === 'dark'); } applyTheme(); window.addEventListener('storage', e => { if (e.key === themeKey) applyTheme(); }); setInterval(applyTheme, 2000); })();

    // --- LÓGICA PARA AÇÕES EM MASSA (sem alterações) ---
    const selectAllCheckbox = document.getElementById('selectAllCheckbox');
    const bulkDeleteButton = document.getElementById('bulkDeleteButton');

    function updateBulkActions() {
        const checkedCount = document.querySelectorAll('.row-checkbox:checked').length;
        const hasSelection = checkedCount > 0;
        bulkDeleteButton.style.display = hasSelection ? 'inline-block' : 'none';
        bulkDeleteButton.innerText = `Excluir Selecionadas (${checkedCount})`;
    }

    selectAllCheckbox.addEventListener('click', function() {
        document.querySelectorAll('.row-checkbox').forEach(cb => { cb.checked = this.checked; });
        updateBulkActions();
    });

    document.querySelectorAll('.row-checkbox').forEach(cb => {
        cb.addEventListener('click', function() {
            if (!this.checked) selectAllCheckbox.checked = false;
            updateBulkActions();
        });
    });

    // AÇÃO DE EXCLUSÃO EM MASSA (sem alterações)
    bulkDeleteButton.addEventListener('click', async function() {
        const checkedIds = Array.from(document.querySelectorAll('.row-checkbox:checked')).map(cb => cb.dataset.id);
        if (checkedIds.length === 0 || !confirm(`Tem certeza que deseja excluir ${checkedIds.length} temporada(s)? Todos os episódios relacionados serão apagados permanentemente.`)) return;
        try {
            const formData = new FormData();
            checkedIds.forEach(id => formData.append('ids[]', id));
            const response = await fetch('ajax/temporadas_excluir_massa.php', { method: 'POST', body: formData });
            const result = await response.json();
            alert(result.message);
            if (result.success) location.reload();
        } catch (error) {
            console.error('Erro:', error);
            alert('Erro de comunicação ao tentar excluir as temporadas.');
        }
    });

    // FUNÇÃO PARA EXCLUIR UMA ÚNICA TEMPORADA (sem alterações)
    async function deleteTemporada(id, name) {
        if (!confirm(`Tem certeza que deseja excluir a temporada "${name}"? Todos os seus episódios serão perdidos.`)) return;
        try {
            const formData = new FormData();
            formData.append('id', id);
            const response = await fetch('ajax/temporada_excluir.php', { method: 'POST', body: formData });
            const result = await response.json();
            alert(result.message);
            if (result.success) {
                document.getElementById(`temporada-row-${id}`).remove();
                updateBulkActions();
            }
        } catch (e) {
            alert('Erro de comunicação com o servidor.');
        }
    }
    updateBulkActions();
    </script>
</body>
</html>