<?php
/**
 * ARQUIVO: /gerenciador/ajax/temporada_excluir.php
 * DESCRIÇÃO: Script para exclusão de uma única temporada.
 */
header('Content-Type: application/json');
require_once('../../api/controles/db.php');
$pdo = conectar_bd();

if (!$pdo) {
    echo json_encode(['success' => false, 'message' => 'Erro ao conectar com o banco de dados.']);
    exit;
}

$id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);

if (!$id) {
    echo json_encode(['success' => false, 'message' => 'ID da temporada inválido.']);
    exit;
}

try {
    $pdo->beginTransaction();

    // Passo 1: Excluir os episódios da temporada
    $stmt_episodes = $pdo->prepare("DELETE FROM series_episodes WHERE season_id = ?");
    $stmt_episodes->execute([$id]);

    // Passo 2: Excluir a temporada
    $stmt_season = $pdo->prepare("DELETE FROM series_seasons WHERE id = ?");
    $stmt_season->execute([$id]);

    if ($stmt_season->rowCount() > 0) {
        $pdo->commit();
        echo json_encode(['success' => true, 'message' => 'Temporada e seus episódios excluídos com sucesso!']);
    } else {
        $pdo->rollBack();
        echo json_encode(['success' => false, 'message' => 'Temporada não encontrada.']);
    }

} catch (PDOException $e) {
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => 'Erro no banco de dados: ' . $e->getMessage()]);
}
?>