﻿<?php
session_start();
require_once("./api/controles/db.php");
$conexao = conectar_bd();

// ======================================================================
// ESTRUTURA DE API NO TOPO DO ARQUIVO
// ======================================================================

$action = $_POST['action'] ?? $_GET['action'] ?? '';
$admin_id = $_SESSION['admin_id'] ?? 0; // Pega o admin_id da sessăo

if (empty($admin_id) && $action != 'get_list') {
     header('Content-Type: application/json; charset=utf-8');
     http_response_code(403); // Forbidden
     echo json_encode(['status' => 'error', 'message' => 'Acesso negado. Sessăo inválida.']);
     exit();
}


if ($action) {
    switch ($action) {
        case 'get_list':
            header('Content-Type: text/html; charset=utf-8');
            $type = $_GET['type'] ?? 'live';
            if (!in_array($type, ['live', 'movie', 'series'])) { $type = 'live'; }

            $stmt = $conexao->prepare("SELECT `id`, `nome` FROM `categoria` WHERE `type` = ? AND `admin_id` = ? ORDER BY `position` ASC");
            $stmt->execute([$type, $admin_id]);
            
            // ==================================
            // CORREÇĂO DOS ÍCONES (API)
            // ==================================
            foreach ($stmt->fetchAll() as $cat) {
                echo '<li data-id="' . $cat['id'] . '">
                          <input type="checkbox" class="category-checkbox form-check-input" data-id="' . $cat['id'] . '">
                          <span class="drag-handle"><i class="fas fa-bars"></i></span>
                          <span class="category-name">' . htmlspecialchars($cat['nome']) . '</span>
                          <div class="item-actions">
                              <button class="edit-btn" data-id="' . $cat['id'] . '" title="Editar"><i class="fas fa-edit"></i></button>
                              <button class="delete-btn" data-id="' . $cat['id'] . '" title="Excluir"><i class="fas fa-trash"></i></button>
                          </div>
                      </li>';
            }
            // ==================================
            break;

        case 'add_category':
        case 'save_order':
        case 'get_category_details':
        case 'save_edit':
        case 'delete_category':
        case 'delete_bulk':
            header('Content-Type: application/json; charset=utf-8');

            if ($action == 'add_category') {
                $nome = trim($_POST['nome'] ?? '');
                $type = trim($_POST['type'] ?? 'live');
                if (empty($nome)) {
                    http_response_code(400);
                    echo json_encode(['status' => 'error', 'message' => 'O nome da categoria é obrigatório.']);
                    exit();
                }
                try {
                    $stmt_pos = $conexao->prepare("SELECT MAX(position) as max_position FROM categoria WHERE `type` = ? AND `admin_id` = ?");
                    $stmt_pos->execute([$type, $admin_id]);
                    $new_position = ($stmt_pos->fetchColumn() ?: 0) + 1;

                    $stmt = $conexao->prepare("INSERT INTO categoria (nome, `type`, position, admin_id) VALUES (?, ?, ?, ?)");
                    $stmt->execute([$nome, $type, $new_position, $admin_id]);
                    echo json_encode(['status' => 'success', 'message' => 'Categoria adicionada com sucesso!']);
                } catch (Exception $e) {
                    http_response_code(500);
                    echo json_encode(['status' => 'error', 'message' => 'Năo foi possível adicionar a categoria.', 'debug' => $e->getMessage()]);
                }
            }
            if ($action == 'save_order') {
                $order_data = json_decode($_POST['order'] ?? '[]', true);
                if (empty($order_data)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'Dados inválidos.']); exit(); }
                $conexao->beginTransaction();
                try {
                    $stmt = $conexao->prepare("UPDATE `categoria` SET `position` = ? WHERE `id` = ? AND `admin_id` = ?");
                    foreach ($order_data as $index => $id) { $stmt->execute([$index + 1, intval($id['id'] ?? $id), $admin_id]); }
                    $conexao->commit();
                    echo json_encode(['status' => 'success', 'message' => 'Ordem salva com sucesso!']);
                } catch (Exception $e) { $conexao->rollBack(); http_response_code(500); echo json_encode(['status' => 'error', 'message' => 'Erro ao salvar a ordem.']); }
            }
            if ($action == 'get_category_details') {
                $id = intval($_POST['id'] ?? 0);
                $stmt = $conexao->prepare("SELECT `id`, `nome` FROM `categoria` WHERE `id` = ? AND `admin_id` = ?");
                $stmt->execute([$id, $admin_id]);
                $category = $stmt->fetch();
                if ($category) { echo json_encode(['status' => 'success', 'data' => $category]); } 
                else { http_response_code(404); echo json_encode(['status' => 'error', 'message' => 'Categoria năo encontrada.']); }
            }
            if ($action == 'save_edit') {
                $id = intval($_POST['id'] ?? 0);
                $nome = trim($_POST['nome'] ?? '');
                if (empty($id) || empty($nome)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'ID e Nome săo obrigatórios.']); exit(); }
                $stmt = $conexao->prepare("UPDATE `categoria` SET `nome` = ? WHERE `id` = ? AND `admin_id` = ?");
                $stmt->execute([$nome, $id, $admin_id]);
                echo json_encode(['status' => 'success', 'message' => 'Categoria atualizada!']);
            }
            if ($action == 'delete_category') {
                $id = intval($_POST['id'] ?? 0);
                $stmt = $conexao->prepare("DELETE FROM `categoria` WHERE `id` = ? AND `admin_id` = ?");
                $stmt->execute([$id, $admin_id]);
                echo json_encode(['status' => 'success']);
            }
            if ($action == 'delete_bulk') {
                $ids = $_POST['ids'] ?? [];
                if (empty($ids) || !is_array($ids)) { http_response_code(400); echo json_encode(['status' => 'error', 'message' => 'Nenhum ID selecionado.']); exit(); }
                $placeholders = implode(',', array_fill(0, count($ids), '?'));
                $stmt = $conexao->prepare("DELETE FROM `categoria` WHERE `id` IN ($placeholders) AND `admin_id` = ?");
                $ids[] = $admin_id; // Adiciona o admin_id ao final do array de parâmetros
                $stmt->execute($ids);
                echo json_encode(['status' => 'success', 'message' => (count($ids)-1) . ' categorias foram apagadas.']);
            }
            break;
    }
    exit(); // Termina o script após a açăo da API
}

// ======================================================================
// PÁGINA HTML (Só é renderizada se nenhuma açăo de API for chamada)
// ======================================================================
require_once("menu.php");

// Busca a lista inicial (live) para o admin logado
$stmt_iniciais = $conexao->prepare("SELECT `id`, `nome` FROM `categoria` WHERE `type` = 'live' AND `admin_id` = ? ORDER BY `position` ASC");
$stmt_iniciais->execute([$admin_id]);
$categorias_iniciais = $stmt_iniciais->fetchAll();
?>

<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    /* CSS de Tema (Claro/Escuro) */
    .card { color: #212529; background-color: #fff; }
    .list-container { border-color: #dee2e6; }
    #sortable-list li { border-color: #dee2e6; background-color: #fff; }
    .controls-container { background-color: #f8f9fa; border-bottom-color: #dee2e6; }
    .tab-button { color: #6c757d; }
    .tab-button.active { color: #0d6efd; border-color: #dee2e6; background-color: #fff; }
    .tabs { border-bottom-color: #dee2e6; }
    .modal-content-custom { background: #fff; color: #212529; }
    .item-actions button { color: #6c757d; }
    [data-theme="dark"] .card { background-color: #2a2e33 !important; color: #e4e6eb !important; border-color: #3a3f44 !important; }
    [data-theme="dark"] .list-container { border-color: #3a3f44; }
    [data-theme="dark"] #sortable-list li { border-color: #3a3f44; background-color: #2c2c2c; }
    [data-theme="dark"] .controls-container { background-color: #343a40; border-bottom-color: #3a3f44; }
    [data-theme="dark"] .tab-button { color: #adb5bd; }
    [data-theme="dark"] .tab-button.active { color: #589bff; border-color: #3a3f44; background-color: #2a2e33; }
    [data-theme="dark"] .tabs { border-bottom-color: #3a3f44; }
    [data-theme="dark"] .modal-content-custom { background: #2c2c2c; color: #e4e6eb; }
    [data-theme="dark"] .item-actions button { color: #adb5bd; }
    [data-theme="dark"] .drag-handle { color: #adb5bd; }
    [data-theme="dark"] h4.text-muted { color: #adb5bd !important; }

    /* CSS de Layout */
    .tabs { margin-bottom: 20px; display: flex; border-bottom: 2px solid var(--border-color); }
    .tab-button { background: transparent; border: 1px solid transparent; border-bottom: none; padding: 10px 20px; cursor: pointer; font-size: 16px; }
    .tab-button.active { border-color: var(--border-color); border-bottom: 2px solid var(--bg-card); position: relative; top: 1px; font-weight: bold; border-radius: 5px 5px 0 0; }
    .list-container { border: 1px solid var(--border-color); padding: 10px; border-radius: 4px; }
    #sortable-list { list-style: none; padding: 0; margin: 0; min-height: 100px; }
    #sortable-list li { cursor: move; padding: 10px 15px; margin-bottom: 5px; border: 1px solid var(--border-color); background-color: var(--bg-card); border-radius: 4px; display: flex; align-items: center; justify-content: space-between; }
    .category-checkbox { margin-right: 15px; transform: scale(1.4); }
    .drag-handle { display: inline-block; width: 20px; cursor: grab; font-size: 20px; }
    .category-name { flex-grow: 1; margin-left: 10px; }
    .item-actions button { background: none; border: none; cursor: pointer; font-size: 16px; /* Ajustado o tamanho */ margin-left: 10px;}
    .ui-sortable-placeholder { border: 2px dashed #0d6efd; background-color: rgba(13, 110, 253, 0.1); height: 45px; visibility: visible !important; }
    .controls-container { display: flex; justify-content: space-between; align-items: center; padding: 10px; background-color: var(--bg-card); border-bottom: 1px solid var(--border-color); }
    .bulk-actions { display: flex; align-items: center; }
    #selectAll { margin-right: 10px; transform: scale(1.4); }
    .main-actions { text-align: center; padding-top: 20px; }
    .action-button { font-size: 16px; font-weight: bold; padding: 12px 25px; color: #fff; border: none; border-radius: 5px; cursor: pointer; }
    #saveButton { background-color: #28a745; }
    #deleteSelectedButton { background-color: #dc3545; margin-left: 10px; }
    .modal-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); display: none; justify-content: center; align-items: center; z-index: 1050; }
    .modal-content-custom { background: var(--bg-card); padding: 30px; border-radius: 8px; width: 90%; max-width: 500px; }
    .modal-content-custom h2 { margin-top: 0; }
    .modal-content-custom input[type="text"] { width: 100%; padding: 10px; font-size: 16px; margin-bottom: 20px; box-sizing: border-box; }
    .modal-actions { text-align: right; }
    .modal-actions button { margin-left: 10px; }
</style>

<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="text-muted text-uppercase mb-0">Gerenciador de Categorias</h4>
        <button id="addCategoryBtn" class="btn btn-success"><i class="fas fa-plus me-1"></i> Adicionar Categoria</button>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="tabs">
                <button class="tab-button active" data-type="live">Canais</button>
                <button class="tab-button" data-type="movie">Filmes</button>
                <button class="tab-button" data-type="series">Séries</button>
            </div>
            <div class="list-container">
                <div class="controls-container">
                    <div class="bulk-actions">
                        <input type="checkbox" id="selectAll" title="Selecionar Tudo" class="form-check-input">
                        <button id="deleteSelectedButton" class="btn btn-sm btn-danger ms-2">Apagar Selecionados</button>
                    </div>
                </div>
                <ul id="sortable-list">
                    <?php foreach ($categorias_iniciais as $cat): ?>
                        <li data-id="<?php echo $cat['id']; ?>">
                            <input type="checkbox" class="category-checkbox form-check-input" data-id="<?php echo $cat['id']; ?>">
                            <span class="drag-handle"><i class="fas fa-bars"></i></span>
                            <span class="category-name"><?php echo htmlspecialchars($cat['nome']); ?></span>
                            <div class="item-actions">
                                <button class="edit-btn" data-id="<?php echo $cat['id']; ?>" title="Editar"><i class="fas fa-edit"></i></button>
                                <button class="delete-btn" data-id="<?php echo $cat['id']; ?>" title="Excluir"><i class="fas fa-trash"></i></button>
                            </div>
                        </li>
                    <?php endforeach; ?>
                    </ul>
            </div>
            <div class="main-actions">
                <button id="saveButton" class="action-button">Salvar Ordem da Lista Atual</button>
            </div>
        </div>
    </div>
</div>

<div id="editModal" class="modal-overlay">
    <div class="modal-content-custom">
        <h2>Editar Categoria</h2>
        <input type="hidden" id="edit_id">
        <input type="text" id="edit_nome" placeholder="Nome da Categoria" class="form-control">
        <div class="modal-actions">
            <button id="cancelEditButton" class="btn btn-secondary">Cancelar</button>
            <button id="saveEditButton" class="btn btn-primary">Salvar Alteraçőes</button>
        </div>
    </div>
</div>

<div id="addModal" class="modal-overlay">
    <div class="modal-content-custom">
        <h2>Adicionar Nova Categoria</h2>
        <input type="text" id="add_nome" placeholder="Nome da Nova Categoria" class="form-control">
        <div class="modal-actions">
            <button id="cancelAddButton" class="btn btn-secondary">Cancelar</button>
            <button id="saveAddButton" class="btn btn-success">Salvar Categoria</button>
        </div>
    </div>
</div>
    
<script>
$(document).ready(function() {
    const list = $("#sortable-list");
    const editModal = $('#editModal');
    const addModal = $('#addModal'); 
    const selectAllCheckbox = $('#selectAll');

    // ==================================
    // CORREÇĂO DOS ÍCONES (JAVASCRIPT)
    // ==================================
    // Substitui os emojis (texto) por ícones Font Awesome (HTML)
    function updateListIcons() {
        list.find('.drag-handle').html('<i class="fas fa-bars"></i>');
        list.find('.edit-btn').html('<i class="fas fa-edit"></i>');
        list.find('.delete-btn').html('<i class="fas fa-trash"></i>');
    }
    // ==================================

    function makeSortable() { 
        list.sortable({ 
            handle: ".drag-handle", 
            placeholder: "ui-sortable-placeholder" 
        }); 
    }
    
    makeSortable();
    // updateListIcons(); // [REMOVIDO] Năo precisamos mais disso aqui, o HTML já está correto

    function loadList(type) {
        list.html('<li>Carregando...</li>');
        const tokenParam = (typeof SESSION_TOKEN !== 'undefined') ? '&token=' + SESSION_TOKEN : '';
        
        // [CORREÇĂO] Passa o admin_id na requisiçăo AJAX GET
        $.get('gerenciar_categorias.php', { action: 'get_list', type: type, time: new Date().getTime(), admin_id: <?php echo $admin_id; ?> }, function(responseHtml) {
            list.html(responseHtml);
            makeSortable();
            // updateListIcons(); // [REMOVIDO] A API já retorna o HTML com os ícones corretos
            selectAllCheckbox.prop('checked', false);
        }).fail(function() { list.html('<li><span style="color: red;">Erro ao carregar.</span></li>'); });
    }

    $('.tab-button').on('click', function() {
        $('.tab-button').removeClass('active');
        $(this).addClass('active');
        loadList($(this).data('type'));
    });

    function postWithToken(data) {
        if (typeof SESSION_TOKEN !== 'undefined') {
            data.token = SESSION_TOKEN;
        }
        // [CORREÇĂO] Adiciona o admin_id em todos os POSTs
        data.admin_id = <?php echo $admin_id; ?>;
        return $.post('gerenciar_categorias.php', data, null, 'json');
    }

    $('#saveButton').on('click', function() {
        let order = list.find('li').map(function() { return $(this).data('id'); }).get();
        
        postWithToken({ action: 'save_order', order: JSON.stringify(order) })
            .done(function(res) {
                Swal.fire('Sucesso!', res.message, 'success');
            })
            .fail(function() { Swal.fire('Erro!', 'Năo foi possível salvar a ordem.', 'error'); });
    });

    list.on('click', '.edit-btn', function() {
        let id = $(this).data('id');
        
        postWithToken({ action: 'get_category_details', id: id })
            .done(function(res) {
                if (res.status === 'success') {
                    $('#edit_id').val(res.data.id);
                    $('#edit_nome').val(res.data.nome);
                    editModal.css('display', 'flex');
                } else { Swal.fire('Erro!', res.message, 'error'); }
            })
            .fail(function() { Swal.fire('Erro!', 'Năo foi possível buscar os dados.', 'error'); });
    });

    $('#saveEditButton').on('click', function() {
        let id = $('#edit_id').val();
        let nome = $('#edit_nome').val();
        
        postWithToken({ action: 'save_edit', id: id, nome: nome })
            .done(function(res) {
                if (res.status === 'success') {
                    editModal.hide();
                    Swal.fire('Sucesso!', res.message, 'success');
                    list.find('li[data-id="' + id + '"] .category-name').text(nome);
                } else { Swal.fire('Erro!', res.message, 'error'); }
            })
            .fail(function() { Swal.fire('Erro!', 'Năo foi possível salvar.', 'error'); });
    });
    
    $('#cancelEditButton').on('click', () => editModal.hide());

    list.on('click', '.delete-btn', function() {
        let id = $(this).data('id');
        let li_item = $(this).closest('li');
        Swal.fire({
            title: 'Tem certeza?', text: "Esta açăo năo pode ser desfeita!", icon: 'warning',
            showCancelButton: true, confirmButtonText: 'Sim, apagar!', cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                postWithToken({ action: 'delete_category', id: id })
                    .done(function(res) {
                        if (res.status === 'success') {
                            li_item.fadeOut(400, function() { $(this).remove(); });
                        } else { Swal.fire('Erro!', res.message, 'error'); }
                    })
                    .fail(function() { Swal.fire('Erro!', 'Năo foi possível apagar.', 'error'); });
            }
        });
    });

    selectAllCheckbox.on('click', function() {
        list.find('.category-checkbox').prop('checked', $(this).prop('checked'));
    });

    $('#deleteSelectedButton').on('click', function() {
        let selectedIds = list.find('.category-checkbox:checked').map(function() { return $(this).data('id'); }).get();
        if (selectedIds.length === 0) {
            Swal.fire('Atençăo', 'Selecione pelo menos uma categoria para apagar.', 'info'); return;
        }
        Swal.fire({
            title: 'Tem certeza?', text: `Vocę está prestes a apagar ${selectedIds.length} categorias!`, icon: 'warning',
            showCancelButton: true, confirmButtonText: 'Sim, apagar!', cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                postWithToken({ action: 'delete_bulk', ids: selectedIds })
                    .done(function(res) {
                        if (res.status === 'success') {
                            loadList($('.tab-button.active').data('type'));
                            Swal.fire('Apagado!', res.message, 'success');
                        } else { Swal.fire('Erro!', res.message, 'error'); }
                    })
                    .fail(function() { Swal.fire('Erro!', 'Năo foi possível apagar os itens selecionados.', 'error'); });
            }
        });
    });

    $('#addCategoryBtn').on('click', function() {
        $('#add_nome').val(''); 
        addModal.css('display', 'flex');
    });

    $('#cancelAddButton').on('click', function() {
        addModal.hide();
    });

    $('#saveAddButton').on('click', function() {
        let nome = $('#add_nome').val();
        let type = $('.tab-button.active').data('type');

        if (!nome) {
            Swal.fire('Atençăo', 'O nome da categoria năo pode ser vazio.', 'warning');
            return;
        }

        postWithToken({ action: 'add_category', nome: nome, type: type })
            .done(function(res) {
                if (res.status === 'success') {
                    addModal.hide();
                    Swal.fire('Sucesso!', res.message, 'success');
                    loadList(type); 
                } else {
                    Swal.fire('Erro!', res.message, 'error');
                }
            })
            .fail(function() {
                Swal.fire('Erro!', 'Năo foi possível adicionar a categoria.', 'error');
            });
    });
});
</script>

<?php
// Inclui o rodapé
require_once("footer.php"); 
?>