<?php
// player_m3u_xui_compatible.php CORRIGIDO
set_time_limit(300);
ini_set('memory_limit', '-1');

// Desativa exibição de erros na tela para não corromper o arquivo
ini_set('display_errors', 0);
error_reporting(0);

header('Content-Type: application/octet-stream');

$username = $_GET['username'] ?? null;
$password = $_GET['password'] ?? null;
$output = $_GET['output'] ?? 'ts';

if (empty($username) || empty($password)) {
    http_response_code(400);
    die("Username e password são obrigatórios.");
}

// Ajuste o caminho conforme necessário
require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');

try {
    $conexao = conectar_bd();

    $query_user = "SELECT * FROM clientes WHERE usuario = :username AND senha = :password";
    $stmt_user = $conexao->prepare($query_user);
    $stmt_user->execute([':username' => $username, ':password' => $password]);
    if ($stmt_user->rowCount() === 0) {
        http_response_code(401);
        die("Username e password incorretos.");
    }

    $stmt_servers = $conexao->prepare("SELECT server_ip, server_port FROM servers WHERE status = 1");
    $stmt_servers->execute();
    $active_servers = $stmt_servers->fetchAll(PDO::FETCH_ASSOC);

    $selected_server_url = 'http://' . $_SERVER['HTTP_HOST'];
    if (!empty($active_servers)) {
        $selected_server = $active_servers[array_rand($active_servers)];
        $selected_server_url = "http://" . $selected_server['server_ip'] . ":" . $selected_server['server_port'];
    }

    $tempFile = tempnam(sys_get_temp_dir(), 'playlist_m3u_');
    $fileHandle = fopen($tempFile, 'w');

    // CORREÇÃO 1: Aspas escapadas (\") dentro da string
    fwrite($fileHandle, "#EXTM3U\n");
    fwrite($fileHandle, "#EXT-X-SESSION-DATA:DATA-ID=\"com.Office.Xtream.4.1.23\"\n");

    // Canais ao vivo (LIVE)
    $query_live = "SELECT s.id, s.name, s.stream_icon, s.epg_channel_id, c.nome AS category_name
                   FROM streams s LEFT JOIN categoria c ON s.category_id = c.id
                   WHERE s.stream_type = 'live'";
    $stmt_live = $conexao->prepare($query_live);
    $stmt_live->execute();
    while ($stream = $stmt_live->fetch(PDO::FETCH_ASSOC)) {
        $tvg_id = htmlspecialchars($stream['epg_channel_id'] ?? '', ENT_QUOTES);
        $logo = htmlspecialchars($stream['stream_icon'] ?? '', ENT_QUOTES);
        $group = htmlspecialchars($stream['category_name'] ?? 'Canais', ENT_QUOTES);
        $name = htmlspecialchars($stream['name'], ENT_QUOTES);

        // CORREÇÃO 2: Aspas escapadas nas propriedades tvg
        fwrite($fileHandle, "#EXTINF:-1 tvg-id=\"{$tvg_id}\" tvg-name=\"{$name}\" tvg-logo=\"{$logo}\" group-title=\"{$group}\",{$name}\n");
        fwrite($fileHandle, "{$selected_server_url}/live/{$username}/{$password}/{$stream['id']}.{$output}\n");
    }

    // Filmes (VOD)
    $query_movies = "SELECT s.id, s.name, s.stream_icon, s.container_extension, c.nome AS category_name
                     FROM streams s LEFT JOIN categoria c ON s.category_id = c.id
                     WHERE s.stream_type = 'movie'";
    $stmt_movies = $conexao->prepare($query_movies);
    $stmt_movies->execute();
    while ($movie = $stmt_movies->fetch(PDO::FETCH_ASSOC)) {
        $logo = htmlspecialchars($movie['stream_icon'] ?? '', ENT_QUOTES);
        $group = htmlspecialchars($movie['category_name'] ?? 'Filmes', ENT_QUOTES);
        $name = htmlspecialchars($movie['name'], ENT_QUOTES);

        // CORREÇÃO 3: Aspas escapadas
        fwrite($fileHandle, "#EXTINF:-1 tvg-name=\"{$name}\" tvg-logo=\"{$logo}\" group-title=\"{$group}\",{$name}\n");
        fwrite($fileHandle, "{$selected_server_url}/movie/{$username}/{$password}/{$movie['id']}.{$movie['container_extension']}\n");
    }

    // Séries
    $query_series = "SELECT e.id, e.title, e.container_extension, e.season, e.episode_num, s.name AS series_name, c.nome AS category_name, s.cover
                     FROM series_episodes e
                     LEFT JOIN series s ON e.series_id = s.id
                     LEFT JOIN categoria c ON s.category_id = c.id";
    $stmt_series = $conexao->prepare($query_series);
    $stmt_series->execute();
    while ($episode = $stmt_series->fetch(PDO::FETCH_ASSOC)) {
        $season_num = str_pad($episode['season'], 2, '0', STR_PAD_LEFT);
        $episode_num = str_pad($episode['episode_num'], 2, '0', STR_PAD_LEFT);
        $ep_identifier = "S{$season_num}E{$episode_num}";
        $series_name = htmlspecialchars($episode['series_name'], ENT_QUOTES);
        $ep_title = htmlspecialchars($episode['title'], ENT_QUOTES);
        $display_name = "{$series_name} | {$ep_identifier} - {$ep_title}";
        $logo = htmlspecialchars($episode['cover'] ?? '', ENT_QUOTES);
        $group = htmlspecialchars($episode['category_name'] ?? 'Séries', ENT_QUOTES);

        // CORREÇÃO 4: Aspas escapadas
        fwrite($fileHandle, "#EXTINF:-1 tvg-name=\"{$display_name}\" tvg-logo=\"{$logo}\" group-title=\"{$series_name}\",{$display_name}\n");
        fwrite($fileHandle, "{$selected_server_url}/series/{$username}/{$password}/{$episode['id']}.{$episode['container_extension']}\n");
    }

    fclose($fileHandle);

    header('Content-Disposition: attachment; filename="'.$username.'.m3u"');
    header('Content-Length: ' . filesize($tempFile));
    header('Pragma: no-cache');
    header('Expires: 0');

    readfile($tempFile);
    unlink($tempFile);

} catch (PDOException $e) {
    if (!empty($tempFile) && file_exists($tempFile)) {
        unlink($tempFile);
    }
    http_response_code(500);
    error_log("Erro no player_m3u.php: " . $e->getMessage());
    die("Erro no servidor.");
}
exit;
?>