<?php
// Inicia a sessão para verificar se o usuário já está logado E para salvar o idioma
session_start();

// --- LÓGICA DE IDIOMA ---
$default_lang = 'pt';
$allowed_langs = ['pt', 'en'];

// 1. Se o usuário CLICOU em um idioma (ex: ?lang=en), atualiza a sessão e recarrega
if (isset($_GET['lang']) && in_array($_GET['lang'], $allowed_langs)) {
    $_SESSION['lang'] = $_GET['lang'];
    header('Location: index.php'); // Redireciona para limpar o ?lang= da URL
    exit;
}

// 2. Define o idioma a ser usado: da sessão, ou o padrão 'pt'
$lang = $_SESSION['lang'] ?? $default_lang;
if (!in_array($lang, $allowed_langs)) {
    $lang = $default_lang;
}

// 3. Carrega o arquivo de idioma correspondente
$lang_file = __DIR__ . '/lang/lang_' . $lang . '.php';

if (!file_exists($lang_file)) {
    // Se o arquivo não existir (ex: lang_en.php deletado), carrega o padrão
    $lang_file = __DIR__ . '/lang/lang_' . $default_lang . '.php';
}
require_once($lang_file); // $t será definido a partir deste arquivo
// --- FIM DA LÓGICA DE IDIOMA ---


// Se o usuário já estiver logado, redireciona para o dashboard
if (isset($_SESSION['logged_in_fxtream']) && $_SESSION['logged_in_fxtream'] === true) {
    header('Location: dashboard.php');
    exit;
}

// Carrega a configuração do painel para usar o título e o logo
$config_file = 'config.json';
if (file_exists($config_file)) {
    $config = json_decode(file_get_contents($config_file), true);
} else {
    // Fallback caso o config.json não exista
    $config = [
        'title' => 'ZenPanel',
        'logo_path' => '/favicon.svg' // Use um logo padrão ou o do ZenPanel
    ];
}
?>
<!DOCTYPE html>
<!-- O 'lang' agora é dinâmico -->
<html lang="<?php echo htmlspecialchars($t['html_lang']); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- O 'title' agora é dinâmico -->
    <title><?php echo htmlspecialchars($t['login_title']); ?> - <?php echo htmlspecialchars($config['title']); ?></title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <link rel="icon" href="<?php echo htmlspecialchars($config['logo_path']); ?>" type="image/x-icon">
    
    <style>
        /* ... [Todo o seu CSS permanece o mesmo] ... */
        :root {
            --primary: #2563eb;
            --primary-dark: #1d4ed8;
            --primary-light: #3b82f6;
            --gradient: linear-gradient(45deg, #2193b0, #6dd5ed);
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
            --gray-600: #4b5563;
            --gray-700: #374151;
            --gray-900: #111827;
        }
        
        * { margin: 0; padding: 0; box-sizing: border-box; }
        
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            background-size: cover;
            background-position: center;
            height: 100vh;
            overflow: hidden;
        }
        
        .login-container { display: flex; height: 100vh; overflow: hidden; }
        
        .left-side {
            position: relative;
            width: 40%;
            overflow: hidden;
            background: var(--gradient);
        }
        
        .left-side::before, .left-side::after {
            content: "";
            position: absolute;
            left: 0;
            width: 200%;
            height: 200%;
            bottom: 0;
            background-color: rgba(255, 255, 255, 0.15);
            border-radius: 38%;
            transform-origin: 50% 49%;
        }
        
        .left-side::before { animation: drift 12s infinite linear; }
        .left-side::after { animation: drift 15s infinite linear; opacity: 0.5; }
        
        @keyframes drift {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
        
        .wave1, .wave2, .wave3 {
            position: absolute;
            width: 200%;
            height: 200%;
            bottom: 0;
            left: 0;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 38%;
        }
        
        .wave1 { animation: drift 20s infinite linear; opacity: 0.3; }
        .wave2 { animation: drift 25s infinite linear reverse; opacity: 0.2; }
        .wave3 { animation: drift 30s infinite linear; opacity: 0.1; }
        
        .left-content {
            position: relative;
            z-index: 10;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            text-align: center;
            padding: 40px;
        }
        
        .logo-icon {
            width: 120px;
            height: 120px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
            font-size: 48px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            overflow: hidden;
        }
        
        /* Estilo para a imagem do logo funcionar bem */
        .logo-icon img {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
            padding: 10px; /* Ajuste o padding se o logo ficar cortado */
        }
        
        .logo-icon i { font-size: 48px; }
        
        .left-content h1 {
            font-weight: 700;
            font-size: 32px;
            margin-bottom: 10px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .left-content p {
            opacity: 0.9;
            font-weight: 400;
            font-size: 16px;
            max-width: 400px;
        }
        
        .right-side {
            width: 60%;
            padding: 40px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            background-color: var(--gray-50);
        }
        
        .login-card {
            background: white;
            padding: 40px;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            width: 100%;
            max-width: 420px;
            position: relative;
            overflow: hidden;
        }
        
        .login-card::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 6px;
            height: 100%;
            background: var(--gradient);
            border-top-left-radius: 16px;
            border-bottom-left-radius: 16px;
        }
        
        .login-header { margin-bottom: 30px; text-align: center; }
        .login-header h2 { margin: 0; color: var(--gray-900); font-size: 24px; font-weight: 600; }
        .login-header p { margin-top: 8px; color: var(--gray-600); font-size: 14px; }
        
        .form-group { position: relative; margin-bottom: 25px; width: 100%; }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-size: 14px;
            color: var(--gray-700);
            font-weight: 500;
        }
        
        .input-wrapper { position: relative; }
        
        .form-control {
            width: 100%;
            padding: 14px 16px 14px 48px;
            border: 2px solid var(--gray-200);
            border-radius: 10px;
            font-size: 14px;
            transition: all 0.2s ease;
            background: white;
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(33, 147, 176, 0.15);
            background: white;
        }
        
        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--gray-600);
            z-index: 2;
        }
        
        .password-toggle {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: var(--gray-600);
            cursor: pointer;
            padding: 4px;
            z-index: 2;
        }
        .password-toggle:hover { color: var(--primary); }

        .btn-login {
            width: 100%;
            background: var(--gradient);
            color: white;
            border: none;
            padding: 14px 24px;
            border-radius: 10px;
            font-weight: 600;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(33, 147, 176, 0.3);
        }
        
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(33, 147, 176, 0.4);
        }
        .btn-login:active { transform: translateY(0); }
        
        .btn-login::after {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            background-image: radial-gradient(circle, #fff 10%, transparent 10.01%);
            background-repeat: no-repeat;
            background-position: 50%;
            transform: scale(10, 10);
            opacity: 0;
            transition: transform .3s, opacity .5s;
        }
        
        .btn-login:active::after {
            transform: scale(0, 0);
            opacity: .3;
            transition: 0s;
        }
        
        .alert {
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            border: none;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .alert-error { background: #fef2f2; color: #dc2626; border-left: 4px solid #dc2626; }
        .alert-success { background: #f0fdf4; color: #16a34a; border-left: 4px solid #16a34a; }
        
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid var(--gray-200);
        }
        
        .footer-text { color: var(--gray-600); font-size: 12px; }
        
        /* Loading state */
        .btn-loading { position: relative; color: transparent !important; } /* Adicionado !important */
        
        .btn-loading::after {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            top: 50%;
            left: 50%;
            margin-left: -8px;
            margin-top: -8px;
            border: 2px solid transparent;
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        
        /* Seletor de Idiomas (Mantido do ZenPanel) */
        .language-selector-wrapper { position: absolute; top: 20px; right: 20px; z-index: 1000; }
        .btn-language {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 8px 12px;
            font-size: 14px;
            color: var(--gray-700);
            transition: all 0.2s ease;
            backdrop-filter: blur(10px);
        }
        .btn-language:hover {
            background: white;
            border-color: var(--primary);
            color: var(--primary);
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        .language-text { font-weight: 500; }
        .dropdown-menu { border: none; border-radius: 8px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15); padding: 8px; min-width: 160px; }
        .dropdown-item { border-radius: 6px; padding: 10px 12px; font-size: 14px; display: flex; align-items: center; transition: all 0.2s ease; }
        .dropdown-item:hover { background: var(--gray-100); color: var(--primary); }
        .dropdown-item.active { background: rgba(33, 147, 176, 0.1); color: var(--primary); font-weight: 500; }
        .flag-icon { margin-right: 8px; font-size: 16px; }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .language-selector-wrapper { top: 10px; right: 10px; }
            .btn-language { padding: 6px 10px; font-size: 13px; }
            .language-text { display: none; }
            .btn-language .bi-translate { margin-right: 0; font-size: 16px; }
            .login-container { flex-direction: column; }
            .left-side { width: 100%; height: 25vh; }
            .right-side { width: 100%; height: 75vh; padding: 20px; justify-content: flex-start; overflow-y: auto; }
            .login-card { padding: 30px 25px; max-width: 100%; margin: 0 auto; width: 95%; }
            .left-content { padding: 20px; }
            .logo-icon { width: 80px; height: 80px; font-size: 32px; margin-bottom: 15px; }
            .left-content h1 { font-size: 22px; }
            .left-content p { font-size: 14px; }
        }
        
        @media (max-width: 480px) {
            .login-card { padding: 25px 20px; }
            .right-side { padding: 15px; }
            .form-control { padding: 12px 16px 12px 44px; }
        }
        
        @media (max-height: 500px) and (orientation: landscape) {
            .login-container { flex-direction: row; }
            .left-side { width: 30%; height: 100vh; }
            .right-side { width: 70%; height: 100vh; justify-content: center; }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="left-side">
            <div class="wave1"></div>
            <div class="wave2"></div>
            <div class="wave3"></div>
            
            <div class="left-content">
                <div class="logo-icon">
                    <img src="<?php echo htmlspecialchars($config['logo_path']); ?>" alt="Logo">
                </div>
                <h1><?php echo htmlspecialchars($config['title']); ?></h1>
                <p><?php echo htmlspecialchars($t['panel_description']); ?></p> </div>
        </div>
        
        <div class="right-side">
            <div class="language-selector-wrapper">
                <div class="dropdown">
                    <!-- O botão e os itens do dropdown agora são dinâmicos -->
                    <button class="btn btn-language dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false" title="<?php echo htmlspecialchars($t['change_language_title']); ?>">
                        <i class="bi bi-translate me-1"></i>
                        <span class="language-text"><?php echo htmlspecialchars($t['current_language_name']); ?></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item <?php if ($lang === 'pt') echo 'active'; ?>" href="?lang=pt">
                                <span class="flag-icon">🇵🇹</span> Português
                                <?php if ($lang === 'pt') echo '<i class="bi bi-check2 ms-2 text-primary"></i>'; ?>
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item <?php if ($lang === 'en') echo 'active'; ?>" href="?lang=en">
                                <span class="flag-icon">🇬🇧</span> Inglês
                                <?php if ($lang === 'en') echo '<i class="bi bi-check2 ms-2 text-primary"></i>'; ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="login-card">
                <div class="login-header">
                    <!-- Textos dinâmicos -->
                    <h2><?php echo htmlspecialchars($t['welcome_back']); ?></h2>
                    <p><?php echo htmlspecialchars($t['login_prompt']); ?></p>
                </div>
                
                <form method="POST" action="" id="loginForm">
                    <div class="form-group">
                        <!-- Textos dinâmicos -->
                        <label class="form-label"><?php echo htmlspecialchars($t['username']); ?></label>
                        <div class="input-wrapper">
                            <i class="bi bi-person input-icon"></i>
                            <input type="text" class="form-control" name="username" placeholder="<?php echo htmlspecialchars($t['username_placeholder']); ?>" required autofocus>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <!-- Textos dinâmicos -->
                        <label class="form-label"><?php echo htmlspecialchars($t['password']); ?></label>
                        <div class="input-wrapper">
                            <i class="bi bi-lock input-icon"></i>
                            <input type="password" class="form-control" id="password" name="password" placeholder="<?php echo htmlspecialchars($t['password_placeholder']); ?>" required>
                            <button type="button" class="password-toggle" id="togglePassword">
                                <i class="bi bi-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn-login" id="loginButton">
                        <i class="bi bi-box-arrow-in-right"></i>
                        <!-- Textos dinâmicos -->
                        <span><?php echo htmlspecialchars($t['login_button']); ?></span>
                    </button>
                </form>
                
                <div class="footer">
                    <div class="footer-text">
                        © 2025 <?php echo htmlspecialchars($config['title']); ?> 4.1.23
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Lógica de Mostrar/Ocultar Senha (do ZenPanel)
            const togglePassword = document.getElementById('togglePassword');
            const password = document.getElementById('password');
            
            if (togglePassword && password) {
                togglePassword.addEventListener('click', function() {
                    const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
                    password.setAttribute('type', type);
                    
                    const icon = this.querySelector('i');
                    icon.classList.toggle('bi-eye');
                    icon.classList.toggle('bi-eye-slash');
                });
            }
            
            // Lógica de Login com Fetch e SweetAlert (do seu painel TOP IPTV)
            const loginForm = document.getElementById('loginForm'); // Apontando para o ID do form do ZenPanel
            
            if (loginForm) {
                loginForm.addEventListener('submit', function(event) {
                    event.preventDefault(); // Impede o envio padrão do formulário
                    
                    // Lógica de loading do ZenPanel
                    const button = document.getElementById('loginButton');
                    button.classList.add('btn-loading');
                    button.disabled = true;
                    
                    const formData = new FormData(this);
                    
                    fetch('api/login.php', { // Mantém o endpoint da sua API
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.icon === 'success') {
                            Swal.fire({
                                // Título dinâmico
                                title: '<?php echo htmlspecialchars($t['alert_success_title']); ?>',
                                text: data.title, // Este texto vem da API (ainda estará em PT)
                                icon: 'success',
                                timer: 1500,
                                showConfirmButton: false,
                                background: '#f9fafb', // Fundo claro para combinar com o ZenPanel
                                color: '#111827'    // Texto escuro
                            }).then(() => {
                                window.location.href = data.url; // Redireciona
                            });
                        } else {
                            Swal.fire({
                                // Título dinâmico
                                title: '<?php echo htmlspecialchars($t['alert_error_title']); ?>',
                                text: data.title, // Este texto vem da API (ainda estará em PT)
                                icon: 'error',
                                background: '#f9fafb',
                                color: '#111827'
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Erro:', error);
                        Swal.fire({
                            // Títulos dinâmicos
                            title: '<?php echo htmlspecialchars($t['alert_connection_error_title']); ?>',
                            text: '<?php echo htmlspecialchars($t['alert_connection_error_text']); ?>',
                            icon: 'error',
                            background: '#f9fafb',
                            color: '#111827'
                        });
                    })
                    .finally(() => {
                        // Restaura o botão (lógica do ZenPanel)
                        button.classList.remove('btn-loading');
                        button.disabled = false;
                    });
                });
            }
        });
    </script>
</body>
</html>