// Arquivo: /js/app.js - VERSÃO FINAL CORRIGIDA (inclui Teste Rápido e Info de Clientes Existentes)

$(document).ready(function() {
    // Inicializa a tabela de Clientes se ela existir na página
    if ($('#tabela_clientes').length) {
        $('#tabela_clientes').DataTable({
            ajax: { url: 'api/clientes.php?listar_clientes=1', type: 'GET' },
            processing: true, serverSide: true, responsive: true,
            language: { url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
            columns: [
                { data: "id" }, { data: "name" }, { data: "usuario" },
                { data: "status" }, { data: "vencimento" },
                { data: "acao", orderable: false, searchable: false }
            ],
            order: [[0, 'desc']]
        });
    }

    // Inicializa a tabela de Testes se ela existir na página
    if ($('#tabela_testes').length) {
        $('#tabela_testes').DataTable({
            ajax: { url: 'api/testes.php?listar_testes=1', type: 'GET' },
            processing: true, serverSide: true, responsive: true,
            language: { url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
            columns: [
                { data: 'id' }, { data: 'name' }, { data: 'usuario' },
                { data: 'status' }, { data: 'vencimento' }, { data: 'acao', orderable: false }
            ],
            order: [[0, 'desc']]
        });
    }

    // Inicializa a tabela de Revendedores se ela existir na página
    if ($('#tabela_revendedores').length) {
        $('#tabela_revendedores').DataTable({
            ajax: { url: 'api/revendedores.php?listar_revendedores=1', type: 'GET' },
            processing: true, serverSide: true, responsive: true,
            language: { url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/pt-BR.json' },
            columns: [
                { data: "id" }, { data: "usuario" }, { data: "creditos" },
                { data: "qnt_clientes" }, { data: "acao", orderable: false, searchable: false }
            ],
            order: [[0, 'desc']]
        });
    }
});


/**
 * Função Mestra para abrir o modal e carregar seu conteúdo via AJAX.
 * ===================================================================
 * ### CORREÇÃO 2 APLICADA AQUI (Clientes Existentes) ###
 * Esta função agora é "inteligente":
 * 1. Se o PHP responder com 'dados_cliente_msg', ela abre o modal de info (infoClienteModal).
 * 2. Se o PHP responder com 'modal_titulo', ela abre o modal genérico (modal_master).
 * ===================================================================
 */
function modal_master(url, action, value = '') {
    const modalMasterEl = document.getElementById('modal_master');
    const modal = new bootstrap.Modal(modalMasterEl);
    const modalTitle = document.getElementById('modal_master-titulo');
    const modalBody = document.getElementById('modal_master-body');
    const modalFooter = document.getElementById('modal_master-footer');
    const modalHeader = document.getElementById('modal_master-header');

    // Mostra o modal de loading (genérico)
    modalTitle.innerHTML = 'Carregando...';
    modalBody.innerHTML = '<div class="text-center p-4"><div class="spinner-border text-primary" role="status"></div></div>';
    modalFooter.innerHTML = '';
    modalHeader.className = 'modal-header bg-primary text-white rounded-top-4';
    
    // Mostra o modal genérico temporariamente (apenas se não estiver já visível)
    if (!modalMasterEl.classList.contains('show')) {
         modal.show();
    }

    let postData = {}; postData[action] = value || true;
    
    $.ajax({
        url: url, type: 'POST', data: postData, dataType: 'json',
        success: function(response) {
            
            // CASO 1: Resposta é para o MODAL DE INFORMAÇÕES DO CLIENTE
            if (response.icon === 'success' && response.dados_cliente_msg) {
                modal.hide(); // Esconde o modal de "Carregando..."

                const modalClienteId = 'infoClienteModal'; 
                const divClienteId = 'dadosClienteParaCopiar';
                const modalClienteEl = document.getElementById(modalClienteId);
                const divContent = document.getElementById(divClienteId);

                if (modalClienteEl && divContent) {
                    const customModal = new bootstrap.Modal(modalClienteEl);
                    const msg_html = response.dados_cliente_msg.replace(/\n/g, '<br>');
                    
                    divContent.innerHTML = msg_html;
                    // Define AMBOS os atributos para o botão "Copiar" funcionar
                    divContent.setAttribute('data-copy-text', response.dados_cliente_msg);
                    divContent.setAttribute('data-raw-text', response.dados_cliente_msg);
                    
                    const modalTitle = document.getElementById(modalClienteId + '-titulo');
                    if (modalTitle) {
                        modalTitle.innerHTML = "Informações do Cliente"; // Título genérico
                    }
                    customModal.show();
                } else {
                    console.error('Modal de cliente (' + modalClienteId + ') ou div (' + divClienteId + ') não encontrado(s).');
                    Swal.fire('Erro', 'Modal de informações não encontrado.', 'error');
                }

            // CASO 2: Resposta é para o MODAL GENÉRICO (Editar, Deletar, etc.)
            } else if (response.modal_titulo) {
                if (response.modal_titulo) modalTitle.innerHTML = response.modal_titulo;
                if (response.modal_body) modalBody.innerHTML = response.modal_body;
                if (response.modal_footer) modalFooter.innerHTML = response.modal_footer;
                if (response.modal_header_class) modalHeader.className = response.modal_header_class;
                // O modal de loading já está aberto, só atualizamos o conteúdo
            
            // CASO 3: Erro retornado pelo PHP
            } else if (response.title && response.icon) {
                 modal.hide(); // Esconde o modal de "Carregando..."
                 Swal.fire(response.title, response.msg, response.icon);
            } else {
                modal.hide(); // Esconde o modal de "Carregando..."
                Swal.fire('Erro de Resposta', 'O servidor enviou uma resposta inesperada.', 'error');
            }
        },
        error: function() { 
            modal.hide();
            Swal.fire('Erro de Comunicação', 'Não foi possível carregar os dados do modal.', 'error'); 
        }
    });
}


/**
 * Função de envio de formulário que trata todos os tipos de resposta do backend.
 */
function enviarFormulario(formId, apiUrl) {
    const form = document.getElementById(formId);
    if (!form) { Swal.fire('Erro de Script', 'Formulário não encontrado: ' + formId, 'error'); return; }
    const formData = new FormData(form);

    Swal.fire({ title: 'Processando...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });

    $.ajax({
        url: apiUrl, // URL já vem completa (ex: api/clientes.php)
        type: 'POST', data: formData, processData: false, contentType: false, dataType: 'json',
        success: function(response) {
            const masterModalEl = document.getElementById('modal_master');
            const masterModal = masterModalEl ? bootstrap.Modal.getInstance(masterModalEl) : null;
            
            const afterModalClose = () => {
                Swal.close();
                
                // 1. Lógica de Redirecionamento (ex: converter teste)
                if (response.redirect_url) {
                    Swal.fire({ title: response.title, text: response.msg, icon: response.icon, timer: 2000, showConfirmButton: false })
                        .then(() => { window.location.href = response.redirect_url; });
                
                // 2. Lógica para modais customizados de Revendedor (e Créditos)
                } else if (response.icon === 'success' && response.show_copy_modal) {
                    const customModalEl = document.getElementById(response.show_copy_modal);
                    if (!customModalEl) {
                        console.error("Modal customizado nao encontrado:", response.show_copy_modal);
                        return;
                    }
                    const customModal = new bootstrap.Modal(customModalEl);
                    const divContent = document.getElementById(response.copy_div_id);
                    if (divContent) {
                        divContent.innerHTML = response.copy_message_html;
                        // Define AMBOS os atributos para funcionar com custom.js e app.js
                        divContent.setAttribute('data-copy-text', response.copy_message_raw);
                        divContent.setAttribute('data-raw-text', response.copy_message_raw);
                    }
                    customModal.show();
                
                // 3. Lógica para mensagem de boas-vindas (criar cliente/teste MANUAL)
                } else if (response.icon === 'success' && response.dados_cliente_msg) {
                    
                    const modalClienteId = 'infoClienteModal'; 
                    const divClienteId = 'dadosClienteParaCopiar';
                    const modalClienteEl = document.getElementById(modalClienteId);
                    const divContent = document.getElementById(divClienteId);

                    if (modalClienteEl && divContent) {
                        const customModal = new bootstrap.Modal(modalClienteEl);
                        const msg_html = response.dados_cliente_msg.replace(/\n/g, '<br>');
                        
                        divContent.innerHTML = msg_html;
                        divContent.setAttribute('data-copy-text', response.dados_cliente_msg);
                        divContent.setAttribute('data-raw-text', response.dados_cliente_msg);
                        
                        const modalTitle = document.getElementById(modalClienteId + '-titulo'); 
                        if (modalTitle) {
                            modalTitle.innerHTML = "🔥 Seu Acesso foi criado com Sucesso";
                        }
                        customModal.show();
                    } else {
                        // Fallback (plano B) se o modal customizado não for encontrado
                        console.error('Modal de cliente (' + modalClienteId + ') ou div (' + divClienteId + ') não encontrado(s). Usando SweetAlert como fallback.');
                        Swal.fire({
                            title: 'Dados Criados!',
                            html: `<textarea class="form-control" rows="12" readonly>${response.dados_cliente_msg}</textarea>`,
                            showCancelButton: true, confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
                            cancelButtonText: '<i class="fab fa-whatsapp"></i> Enviar', cancelButtonColor: '#25D366',
                        }).then((result) => {
                            if (result.isConfirmed) {
                                navigator.clipboard.writeText(response.dados_cliente_msg);
                                Swal.fire({ toast: true, position: 'top-end', icon: 'success', title: 'Copiado!', showConfirmButton: false, timer: 2000 });
                            } else if (result.dismiss === Swal.DismissReason.cancel) {
                                window.open(`https://wa.me/?text=${encodeURIComponent(response.dados_cliente_msg)}`, '_blank');
                            }
                        });
                    }

                // 4. Lógica para todos os outros alertas (simples ou com HTML, como renovação)
                } else {
                    const msgContent = (typeof response.msg === 'string' && response.msg.includes('<div')) 
                        ? { title: response.title, html: response.msg, icon: response.icon, showConfirmButton: (response.msg.includes('<button') ? false : true), showCloseButton: true } 
                        : { title: response.title, text: response.msg, icon: response.icon };
                    Swal.fire(msgContent);
                }

                // Atualiza as tabelas se o backend pedir
                if (response.data_table === 'atualizar') {
                    if ($.fn.DataTable.isDataTable('#tabela_clientes')) $('#tabela_clientes').DataTable().ajax.reload(null, false);
                    if ($.fn.DataTable.isDataTable('#tabela_testes')) $('#tabela_testes').DataTable().ajax.reload(null, false);
                    if ($.fn.DataTable.isDataTable('#tabela_revendedores')) $('#tabela_revendedores').DataTable().ajax.reload(null, false);
                }
                
                // Atualiza os créditos na interface
                if (typeof updateinfo === 'function') {
                    updateinfo();
                }
            };

            // Garante que o modal de formulário esteja fechado antes de mostrar o próximo
            if (masterModal && masterModal._isShown) {
                $(masterModal._element).one('hidden.bs.modal', afterModalClose);
                masterModal.hide();
            } else {
                afterModalClose();
            }
        },
        error: function(jqXHR, textStatus, errorThrown) { 
            Swal.close();
            console.error("AJAX Error (enviarFormulario):", textStatus, errorThrown, jqXHR.responseText);
            Swal.fire('Erro de Comunicação', 'Não foi possível se conectar ao servidor.', 'error'); 
        }
    });
}

/**
 * Função para gerar um teste rápido.
 * ===================================================================
 * ### CORREÇÃO 1 APLICADA AQUI (Teste Rápido) ###
 * A lógica para abrir o modal de info (infoClienteModal)
 * foi colocada diretamente aqui para garantir que funcione.
 * ===================================================================
 */
function executarTesteRapido() {
    Swal.fire({ title: 'Gerando Teste Rápido...', allowOutsideClick: false, didOpen: () => Swal.showLoading() });
    
    $.ajax({
        url: 'api/testes.php',
        type: 'POST',
        data: { gerar_teste_rapido: true },
        dataType: 'json',
        success: function(response) {
            Swal.close();
            
            if (response.icon === 'success' && response.dados_cliente_msg) {
                
                const modalClienteId = 'infoClienteModal'; 
                const divClienteId = 'dadosClienteParaCopiar';
                const modalClienteEl = document.getElementById(modalClienteId);
                const divContent = document.getElementById(divClienteId);

                if (modalClienteEl && divContent) {
                    const customModal = new bootstrap.Modal(modalClienteEl);
                    const msg_html = response.dados_cliente_msg.replace(/\n/g, '<br>');
                    
                    divContent.innerHTML = msg_html;
                    // Define AMBOS os atributos para o botão "Copiar" funcionar
                    divContent.setAttribute('data-copy-text', response.dados_cliente_msg);
                    divContent.setAttribute('data-raw-text', response.dados_cliente_msg);
                    
                    const modalTitle = document.getElementById(modalClienteId + '-titulo');
                    if (modalTitle) {
                        modalTitle.innerHTML = "🔥 Seu Acesso foi criado com Sucesso";
                    }
                    customModal.show();
                } else {
                    // Plano B (Fallback) se o modal customizado não for encontrado
                    console.error('Modal de cliente (' + modalClienteId + ') ou div (' + divClienteId + ') não encontrado(s). Usando SweetAlert como fallback.');
                    Swal.fire({
                        title: 'Dados Criados!',
                        html: `<textarea class="form-control" rows="12" readonly>${response.dados_cliente_msg}</textarea>`,
                        showCancelButton: true, confirmButtonText: '<i class="fas fa-copy"></i> Copiar',
                        cancelButtonText: '<i class="fab fa-whatsapp"></i> Enviar', cancelButtonColor: '#25D366',
                    }).then((result) => {
                        if (result.isConfirmed) { navigator.clipboard.writeText(response.dados_cliente_msg); }
                        else if (result.dismiss === Swal.DismissReason.cancel) { window.open(`https://wa.me/?text=${encodeURIComponent(response.dados_cliente_msg)}`, '_blank'); }
                    });
                }

                // Atualiza a tabela de testes
                if ($.fn.DataTable.isDataTable('#tabela_testes')) {
                    $('#tabela_testes').DataTable().ajax.reload(null, false);
                }
                
            } else {
                // Se o teste rápido falhar (ex: sem créditos)
                Swal.fire(response.title, response.msg, response.icon);
            }
        },
        error: function() { Swal.fire('Erro de Comunicação', 'Não foi possível se conectar ao servidor.', 'error'); }
    });
}

/**
 * Função para copiar mensagens para o clipboard.
 */
function copiarMensagem(elementId) {
    const element = document.getElementById(elementId);
    // Lê de AMBOS os atributos, garantindo compatibilidade
    const textToCopy = element ? (element.getAttribute('data-copy-text') || element.getAttribute('data-raw-text') || element.textContent) : null;
    
    if (textToCopy) {
        navigator.clipboard.writeText(textToCopy).then(() => {
            Swal.fire({ toast: true, position: 'top-end', text: 'Copiado!', icon: 'success', showConfirmButton: false, timer: 1500 });
        });
    } else {
         Swal.fire('Atencao!', 'Nenhum texto para copiar.', 'warning');
    }
}

// Função alias para compatibilidade, caso algum onclick antigo ainda exista
function enviarFormularioRevendedor(formId, apiUrl) {
    enviarFormulario(formId, apiUrl);
}