<?php
// ARQUIVO FINAL: monitor_painel.php (UI e Visual - Tempo Online Sempre Visível)
require_once "menu.php"; 
require_once "api/controles/db.php"; 
?>

<style>
    /* Estilos do Tema Escuro */
    .card-monitor { background-color: #1e1e1e; border: 1px solid #333; color: #fff; }
    .live-badge { padding: 5px 10px; border-radius: 4px; font-weight: bold; font-size: 0.8rem; }
    .badge-tv { background-color: #198754; color: white; }
    .badge-movie { background-color: #0dcaf0; color: black; }
    .badge-serie { background-color: #d63384; color: white; }
    .user-test { color: #ffc107; font-weight: bold; }
    
    /* CORREÇÃO VISUAL CRÍTICA: Cor do Usuário */
    .username-visible { 
        color: #39ff14 !important;
        font-weight: bold; 
    }
    .table-dark-custom { background-color: #252525; color: #ddd; }
    .table-dark-custom th { background-color: #111; border-bottom: 2px solid #444; color: #0dcaf0; }
    .table-dark-custom td { border-bottom: 1px solid #333; vertical-align: middle; }
    .animate-blink { animation: blinker 1.5s linear infinite; color: #0f0; margin-right: 5px; }
    @keyframes blinker { 50% { opacity: 0; } }
</style>

<div class="container-fluid p-0"> 
    <div class="card card-monitor border-0 rounded-0">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><i class="fa fa-circle animate-blink"></i> Usuarios online Tempo Real</h4>
            <span class="badge bg-info fs-6" id="total_online">0 Online</span>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-dark-custom mb-0">
                    <thead>
                        <tr>
                            <th style="min-width: 100px;">USUÁRIO</th>
                            <th class="d-none d-sm-table-cell">IP</th> 
                            <th>O QUE ESTÁ ASSISTINDO?</th>
                            <th>TIPO</th>
                            <th>TEMPO ONLINE</th> <th>AÇÃO</th>
                        </tr>
                    </thead>
                    <tbody id="tabela_conexoes"></tbody>
                </table>
            </div>
        </div>
        <div class="card-footer text-muted text-end">
            <small>Atualização a cada 2 segundos.</small>
        </div>
    </div>
</div>

<?php require_once "footer.php"; ?>

<script>
function atualizarMonitor() {
    fetch('api/api_monitor_ajax.php?nocache=' + Date.now())
    .then(response => response.json())
    .then(data => {
        let html = '';
        document.getElementById('total_online').innerText = data.total + " Online";

        if(data.conexoes.length === 0) {
            html = '<tr><td colspan="6" class="text-center p-4 text-muted"><h5>Nenhum cliente conectado.</h5></td></tr>';
        } else {
            data.conexoes.forEach(row => {
                let tipoClass = '';
                if(row.tipo === 'TV') tipoClass = 'badge-tv';
                if(row.tipo === 'FILME') tipoClass = 'badge-movie';
                if(row.tipo === 'SERIE') tipoClass = 'badge-serie';
                
                let userClass = (row.is_trial == 1) ? 'user-test' : 'username-visible';
                let userLabel = (row.is_trial == 1) ? '<span class="badge bg-warning text-dark ms-1" style="font-size:0.6rem">TESTE</span>' : '';

                html += `
                <tr>
                    <td><span class="${userClass}">${row.usuario}</span> ${userLabel}</td>
                    <td class="d-none d-sm-table-cell">${row.ip}</td> 
                    <td>${row.conteudo}</td>
                    <td><span class="live-badge ${tipoClass}">${row.tipo}</span></td>
                    <td>${row.ping}</td> <td>
                        <button class="btn btn-sm btn-outline-danger" onclick="derrubar('${row.id_conexao}')">
                            Derrubar
                        </button>
                    </td>
                </tr>`;
            });
        }
        document.getElementById('tabela_conexoes').innerHTML = html;
    })
    .catch(e => console.error('Erro API'));
}

function derrubar(id) {
    if(confirm('Tem certeza que deseja derrubar esta conexão?')) {
        fetch('api/api_monitor_ajax.php?action=kill&id=' + id + '&t=' + Date.now()).then(() => atualizarMonitor());
    }
}

setInterval(atualizarMonitor, 2000);
atualizarMonitor();
</script>