<?php
session_start();
require_once('./api/controles/db.php');
require_once("menu.php");

$conexao = conectar_bd();

// [CORREÇÃO SEGURANÇA] Usar prepared statement para evitar SQL Injection
$sql = "SELECT * FROM planos WHERE admin_id = ?";
$stmt = $conexao->prepare($sql);
$stmt->execute([$_SESSION['admin_id']]);

?>

<style>
    /* 1. Cores Padrão (Tema Claro) */
    .card {
        color: #212529; 
        background-color: #fff;
    }
    .table {
        color: #212529; 
        background-color: #fff; 
    }
    .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, 0.05); 
    }

    /* 2. Sobrescreve para o TEMA ESCURO */
    [data-theme="dark"] .card {
        background-color: #2a2e33 !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    
    [data-theme="dark"] .table {
        background-color: transparent !important; 
        color: #e4e6eb !important; 
        border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .table td,
    [data-theme="dark"] .table th {
        color: #e4e6eb !important;
        border-color: #3a3f44 !important;
        background-color: transparent !important; 
    }
    
    [data-theme="dark"] .table-striped > tbody > tr:nth-of-type(odd) {
        background-color: rgba(255, 255, 255, 0.05) !important; 
    }
    
    [data-theme="dark"] .table-hover > tbody > tr:hover > * {
        background-color: rgba(255, 255, 255, 0.1) !important; 
        color: #e4e6eb !important;
    }
    
    /* Cabeçalho da tabela */
    [data-theme="dark"] .table > thead {
         background-color: #343a40 !important; 
         color: #fff !important; 
         border-color: #3a3f44 !important;
    }
    [data-theme="dark"] .table > thead th {
         color: #fff !important; 
    }
</style>
<div class="container-fluid py-4"> <div class="row mb-4">
        <div class="col-md-12">
            <div class="border-0 card py-2 rounded-0">
            
                <div class="card-title mb-1 p-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Todos os Planos</h5>
                    
                    <button type="button" class="btn btn-outline-success" onclick="modal_master('api/planos.php', 'adicionar_planos', 'add')">
                        <i class="fas fa-plus"></i><span class="ms-2">Adicionar Plano</span>
                    </button>
                </div>

                <div class="card-body overflow-auto py-0">
                    <div class="table-responsive-md">
                        <table class='table table-hover table-striped'>
                            <thead>
                                <tr>
                                    <th>Nome</th>
                                    <th class='text-center'>Valor Padrao</th>
                                    <th>Total Clientes</th>
                                    <th>VT.Lucro</th>
                                    <th>VT.Custo</th>
                                    <th style='min-width: 140px;' class='text-center'>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php
                            $valor_creditos2 = 0; // Inicializa fora do loop
                            $V_Lucro2 = 0; // Inicializa fora do loop

                            if ($stmt->rowCount() > 0) {
                                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                    $id = $row["id"];
                                    $data = date('Y-m-d');

                                    // Contar clientes ativos deste plano
                                    $sql_count = "SELECT COUNT(*) AS total FROM clientes WHERE plano = ? AND Vencimento >= ? AND is_trial = 0";
                                    $result_count = $conexao->prepare($sql_count);
                                    $result_count->execute([$id, $data]);
                                    $row_count = $result_count->fetch(PDO::FETCH_ASSOC);
                                    $total = $row_count["total"];

                                    // Contas
                                    $custo_por_credito = isset($row["custo_por_credito"]) ? (float)$row["custo_por_credito"] : 0;
                                    $valor_creditos = $custo_por_credito * $total;
                                    $valor_plano = isset($row["valor"]) ? (float)$row["valor"] : 0;
                                    $V_Lucro = $valor_plano * $total - $valor_creditos;
                                    $valor_creditos2 += $valor_creditos;
                                    $V_Lucro2 += $V_Lucro;

                                    echo "<tr>";
                                    echo "<td>".$row["nome"]."</td>
                                    <td class='text-center'>".number_format($valor_plano, 2, ',', '.')."</td>";
                                    echo "<td>".$total."</td>";
                                    echo "<td>R$:".number_format($V_Lucro, 2, ',', '.')."</td>";
                                    echo "<td>R$:".number_format($valor_creditos, 2, ',', '.')."</td>";
                                    echo '<td class="text-center" style="min-width: 160px;">
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-outline-primary mx-1" data-placement="top" title="Editar" onclick=\'modal_master("api/planos.php", "edite_planos", "' . $id . '")\'>
                                                <i class="fa fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger mx-1" data-placement="top" title="Apagar" onclick=\'modal_master("api/planos.php", "delete_plano", "' . $id . '")\'>
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>';
                                    echo "</tr>";
                                }
                            }
                            ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>TOTAL</th>
                                    <th class='text-center'></th>
                                    <th class='text-center'></th>
                                    <th>R$:<?php echo number_format($V_Lucro2, 2, ',', '.'); ?></th>
                                    <th>R$:<?php echo number_format($valor_creditos2, 2, ',', '.'); ?></th>
                                    <th class='text-center'></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal_master" tabindex="-1" aria-labelledby="modal_master" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="d-block modal-header" id="modal_master-header">
        <h5 class="float-start modal-title" id="modal_master-titulo"></h5>
        <button type="button" class="fa btn text-white fa-close fs-6 float-end" data-bs-dismiss="modal" aria-label="Close"></button>
        </button>
      </div>
      <form id="modal_master_form" onsubmit="event.preventDefault();" autocomplete="off">
        <div id="modal_master-body" class="modal-body overflow-auto" style="max-height: 421px;"></div>
        <div id="modal_master-footer" class="modal-footer"></div>
      </form>
    </div>
  </div>
</div>
<?php
// Inclui o footer.php para carregar os scripts JS (como app.js e sweetalert2)
require_once("footer.php"); 
?>