<?php
// Arquivo: auth_mac.php
// Local: Salvar na raiz do site (junto com loja.php)

// Caminho exato que você confirmou:
require_once('./api/controles/db.php');

// =======================================================================
// --- CONFIGURAÇÕES (EDITE AQUI) ---
// =======================================================================

// Duração do teste automático (em horas)
$duracao_teste_horas = 4; 

// ID dos Pacotes (Bouquets) que o teste vai liberar.
// Olhe na tabela 'bouquets' do banco. Exemplo: "[1]" ou "[1, 5]"
$bouquets_padrao = "[1]"; 

// ID do Revendedor dono dos testes (Admin geralmente é 1)
$id_revendedor = 1; 

// =======================================================================

$conexao = conectar_bd();

// Detecta se é HTTP ou HTTPS para montar o link
$protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
$server_dns = $protocol . "://" . $_SERVER['HTTP_HOST'];

// Pega dados da URL
$username = isset($_GET['username']) ? $_GET['username'] : '';
$password = $username; // Login por MAC usa usuário = senha
$action = isset($_GET['action']) ? $_GET['action'] : '';

// 1. Se já tem action (pedindo canais), manda direto pra API real
if (!empty($action)) {
    $query_string = $_SERVER['QUERY_STRING'];
    header("Location: {$server_dns}/player_api.php?{$query_string}", true, 302);
    exit;
}

// 2. Validação básica
if (empty($username)) {
    die("Erro: MAC Address não informado na URL (?username=...)");
}

try {
    // 3. Verifica se o cliente já existe no banco
    $stmt = $conexao->prepare("SELECT id FROM clientes WHERE usuario = :usuario LIMIT 1");
    $stmt->execute([':usuario' => $username]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$cliente) {
        // --- CLIENTE NOVO: CRIA O TESTE ---
        
        $agora = date('Y-m-d H:i:s');
        $vencimento = date('Y-m-d H:i:s', strtotime("+$duracao_teste_horas hours"));
        
        // Insere na tabela 'clientes' do seu painel
        $sql = "INSERT INTO clientes (usuario, senha, reseller_id, bouquet_id, Criado_em, Vencimento, is_trial, max_connections, active, is_banned) 
                VALUES (:u, :s, :r, :b, :c, :v, 1, 1, 1, 0)";

        $stmt_insert = $conexao->prepare($sql);
        $stmt_insert->execute([
            ':u' => $username,
            ':s' => $password,
            ':r' => $id_revendedor,
            ':b' => $bouquets_padrao,
            ':c' => $agora,
            ':v' => $vencimento
        ]);
        
        // Pausa de 1s para garantir que o banco gravou antes de redirecionar
        sleep(1);
    }

    // 4. Redireciona para o player_api.php (que vai entregar a lista)
    $query_string = http_build_query($_GET);
    header("Location: {$server_dns}/player_api.php?{$query_string}", true, 302);
    exit;

} catch (PDOException $e) {
    // Grava erro no log do servidor, mas não mostra pro usuário
    error_log("Erro Auth MAC: " . $e->getMessage());
    die("Erro interno. Tente novamente.");
}
?>