<?php
// ARQUIVO: series_redirecionamento.php
// Verso: v13.0 - SRIES COM BLINDAGEM TOTAL (Anti-VPS + Bloqueio de 2 IP)

ob_start(); // Inicia buffer

header("Content-Type: text/html; charset=UTF-8");
header("Cache-Control: no-store, no-cache, must-revalidate");
date_default_timezone_set('America/Sao_Paulo');

error_reporting(0); 
ini_set('display_errors', 0);

require_once('./api/controles/db.php');

// --- FUNES AUXILIARES (MANTIDAS DO SEU CDIGO) ---
function processarUrl($url) {
    $parsedUrl = parse_url($url);
    $path = $parsedUrl['path'] ?? '';
    $pathParts = explode('/', trim($path, '/'));
    
    if (count($pathParts) >= 4) {
        $usuario = $pathParts[1];
        $senha = $pathParts[2];
        $arquivo = pathinfo($pathParts[3], PATHINFO_FILENAME);
    } elseif (count($pathParts) <= 3 && count($pathParts) > 1) {
        $usuario = $pathParts[0];
        $senha = $pathParts[1];
        $arquivo = pathinfo($pathParts[2] ?? '', PATHINFO_FILENAME);
    } else { return false; }
    
    if (empty($arquivo) || !is_numeric($arquivo)) { return false; }
    
    return [ 'dominio' => $parsedUrl['host'] ?? '', 'usuario' => $usuario, 'senha' => $senha, 'arquivo' => $arquivo ];
}

function getHeadersAsJson($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    $headers = [];
    if ($response !== false) {
        $header_text = substr($response, 0, curl_getinfo($ch, CURLINFO_HEADER_SIZE));
        foreach (explode("\r\n", $header_text) as $i => $line) {
            if ($i === 0) { $headers['http_code'] = $line; } 
            else {
                $parts = explode(': ', $line);
                if (count($parts) == 2) { $headers[$parts[0]] = $parts[1]; }
            }
        }
    }
    curl_close($ch);
    return json_encode($headers);
}
// ----------------------------

// --- DEFINIO DOS VDEOS DE BLOQUEIO ---
$host = "http://" . $_SERVER["HTTP_HOST"];
$video_banido = "$host/video/block.mp4";             // Conta Vencida, Banida ou VPS/Rob
$video_limite = "$host/video/bloqueio-conexao.mp4";  // Limite Excedido (2 Tela em outro IP)

// --- 1. SEGURANA NIVEL 1: USER AGENTS (Softwares de Restream) ---
$ua_atual = $_SERVER['HTTP_USER_AGENT'] ?? '';
$softwares_proibidos = ['ffmpeg', 'curl', 'wget', 'python', 'golang', 'gstreamer', 'vlc', 'libav'];

foreach ($softwares_proibidos as $soft) {
    if (stripos(strtolower($ua_atual), $soft) !== false) {
        header("Location: $video_banido"); exit;
    }
}
if (empty($ua_atual)) { header("Location: $video_banido"); exit; }

// --- 2. SEGURANA NIVEL 2: HOSTNAME (Anti-VPS/Dedicado) ---
$ip_atual = $_SERVER['REMOTE_ADDR'];
$servidores_proibidos = [
    'amazon', 'aws', 'google', 'cloud', 'ovh', 'hetzner', 'digitalocean', 
    'linode', 'vultr', 'azure', 'oracle', 'alibaba', 'dedic', 'server', 'vps'
];

$hostname = gethostbyaddr($ip_atual); 

if ($hostname) {
    foreach ($servidores_proibidos as $host_proibido) {
        if (stripos(strtolower($hostname), $host_proibido) !== false) {
            header("Location: $video_banido"); exit;
        }
    }
}

// --- CONFIGURAES GERAIS ---
$agora = date('Y-m-d H:i:s');
$type_url = $_GET['type_url'] ?? 'series';
$username = $_GET['usuario'] ?? null;
$password = $_GET['senha'] ?? null;
$arquivo  = $_GET['arquivo'] ?? null;

if ($arquivo) {
    $stream_id = pathinfo($arquivo, PATHINFO_FILENAME);
    $extensao = pathinfo($arquivo, PATHINFO_EXTENSION);
} else {
    $stream_id = null;
    $extensao = 'mp4';
}

if (!$username || !$password || !$stream_id) {
    header("Location: $video_banido");
    exit();
}

try {
    $conexao = conectar_bd();

    // 3. VALIDAO DA CONTA
    $query_auth = "SELECT id, max_connections, Vencimento, is_banned FROM clientes WHERE usuario = :username AND senha = :password LIMIT 1";
    $statement = $conexao->prepare($query_auth);
    $statement->execute([':username' => $username, ':password' => $password]);
    $cliente = $statement->fetch(PDO::FETCH_ASSOC);

    // BLOQUEIO 1: CONTA IRREGULAR
    if (!$cliente || ($cliente['is_banned'] == 1) || (new DateTime() > new DateTime($cliente["Vencimento"]))) {
        header("Location: $video_banido"); exit();
    }

    $limiteConexoes = (int) ($cliente["max_connections"] ?? 1);
    if ($limiteConexoes < 1) $limiteConexoes = 1;

    // Limpeza rpida (20s)
    $conexao->exec("DELETE FROM conexoes WHERE ultima_atividade < NOW() - INTERVAL 20 SECOND");
    
    // --- 4. LGICA DE CONEXO E BLOQUEIO DE 2 IP ---

    // A. Verifica se  o MESMO DISPOSITIVO (Sesso Exata)
    $stmt_check = $conexao->prepare("SELECT id FROM conexoes WHERE usuario = :user AND ip = :ip AND user_agent = :ua LIMIT 1");
    $stmt_check->execute([':user' => $username, ':ip' => $ip_atual, ':ua' => $ua_atual]);
    $sessao_exata = $stmt_check->fetch(PDO::FETCH_ASSOC);

    if ($sessao_exata) {
        // Atualiza conexo existente (Continua assistindo ou prximo episdio)
        $stmt_up = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now_time, stream_id = :sid WHERE id = :id");
        $stmt_up->execute([':now_time' => $agora, ':sid' => $stream_id, ':id' => $sessao_exata['id']]);

    } else {
        // B. Dispositivo Novo. Verifica Vagas.
        $stmt_count = $conexao->prepare("SELECT COUNT(*) FROM conexoes WHERE usuario = :user");
        $stmt_count->execute([':user' => $username]);
        $conexoes_ativas = (int) $stmt_count->fetchColumn();

        if ($conexoes_ativas < $limiteConexoes) {
             // TEM VAGA: Libera.
            $stmt_insert = $conexao->prepare("INSERT INTO conexoes (usuario, ip, user_agent, stream_id, ultima_atividade) VALUES (:usuario, :ip, :user_agent, :stream_id, :now_time)");
            $stmt_insert->execute([ ':usuario' => $username, ':ip' => $ip_atual, ':user_agent' => $ua_atual, ':stream_id' => $stream_id, ':now_time' => $agora ]);
        
        } else {
            // C. LIMITE ATINGIDO.
            // Verifica: O "intruso" vem do MESMO IP (Troca de episdio/Srie na mesma casa)?
            $stmt_check_ip = $conexao->prepare("SELECT id FROM conexoes WHERE usuario = :user AND ip = :ip LIMIT 1");
            $stmt_check_ip->execute([':user' => $username, ':ip' => $ip_atual]);
            $mesmo_ip = $stmt_check_ip->fetch(PDO::FETCH_ASSOC);

            if ($mesmo_ip) {
                // MESMO IP: Recicla a sesso (Derruba a anterior e assume a vaga)
                $stmt_subs = $conexao->prepare("UPDATE conexoes SET ultima_atividade = :now, stream_id = :sid, user_agent = :ua WHERE id = :id");
                $stmt_subs->execute([':now' => $agora, ':sid' => $stream_id, ':ua' => $ua_atual, ':id' => $mesmo_ip['id']]);
            
            } else {
                // IP DIFERENTE: Bloqueia a 2 tela
                header("Location: $video_limite");
                exit();
            }
        }
    }

    // 5. BUSCA DO EPISDIO
    $query_streams = "SELECT * FROM series_episodes WHERE id = :id LIMIT 1";
    $stmt_streams = $conexao->prepare($query_streams);
    $stmt_streams->bindValue(':id', $stream_id, PDO::PARAM_INT);
    $stmt_streams->execute();
    $resultado_streams = $stmt_streams->fetch(PDO::FETCH_ASSOC);

    if (empty($resultado_streams) || empty($resultado_streams['link'])) {
        header("Location: $video_banido");
        exit();
    }
    
    ob_end_clean(); // Limpa buffer e prepara para os headers finais

    // ---- REDIRECIONAMENTOS (SUA LGICA ORIGINAL) ----
    $location = $resultado_streams['link'];
    $tipo_link = $resultado_streams['tipo_link'] ?? 'link_direto';

    if ($tipo_link == 'link_direto') { header("Location: ".$location); exit; }
    
    $dados = @processarUrl($location);
    if ($location && $dados && $tipo_link !== 'link_direto2') {
        $url = "http://{$dados['dominio']}/{$type_url}/{$dados['usuario']}/{$dados['senha']}/{$dados['arquivo']}.$extensao";
        if ($tipo_link == 'padrao2') { header("Location: ".$location); exit; }
        
        $location2_json = getHeadersAsJson($url);
        $location2 = json_decode($location2_json, true);
        
        if ($location2 && isset($location2['Location'])) { header("Location: " . (is_array($location2['Location']) ? $location2['Location'][0] : $location2['Location'])); exit; }
        if ($location2 && isset($location2['URLsComToken'])) { header("Location: " . (is_array($location2['URLsComToken']) ? $location2['URLsComToken'][0] : $location2['URLsComToken'])); exit; }
        
        header("Location: $url"); exit;
    }

    $location3_json = getHeadersAsJson($location);
    $location3 = json_decode($location3_json, true);
    
    if ($location3 && isset($location3['Location'])) { header("Location: " . (is_array($location3['Location']) ? $location3['Location'][0] : $location3['Location'])); exit; }
    if (isset($location3['URLsComToken'])) { header("Location: " . (is_array($location3['URLsComToken']) ? $location3['URLsComToken'][0] : $location3['URLsComToken'])); exit; }

    header("Location: $location");
    exit;

} catch (Exception $e) {
    header("Location: $video_banido");
    exit();
}
?>