<?php
ini_set('display_errors', 1); error_reporting(E_ALL);
header('Content-Type: application/json');
require_once($_SERVER['DOCUMENT_ROOT'] . '/api/controles/db.php');

$data = json_decode(file_get_contents("php://input"), true);
if (empty($data['id']) || empty($data['usuario'])) { http_response_code(400); die(json_encode(['status' => 'error', 'message' => 'Dados incompletos.'])); }
try {
    $pdo = conectar_bd();
    $sql = "UPDATE admin SET user = :user";
    $params = [':user' => $data['usuario'], ':id' => $data['id']];
    if (!empty($data['senha'])) {
        $sql .= ", pass = :pass";
        $params[':pass'] = password_hash($data['senha'], PASSWORD_DEFAULT);
    }
    $sql .= " WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    echo json_encode(['status' => 'success', 'message' => 'Revendedor atualizado com sucesso.']);
} catch (PDOException $e) {
    if ($e->getCode() == 23000) { die(json_encode(['status' => 'error', 'message' => 'Este usuário já existe.'])); }
    http_response_code(500); die(json_encode(['status' => 'error', 'message' => 'Erro ao atualizar: ' . $e->getMessage()]));
}
?>