// Função para lidar com o envio de formulários dentro do modal_master
function handleFormSubmit(action, id = null) {
    const form = document.getElementById('modal_master_form');
    const formData = new FormData(form);
    formData.append(action, '1'); // Adiciona a ação que o PHP espera
    if (id) {
        formData.append('id', id); // Adiciona o ID se for uma ação de edição/crédito
    }

    fetch('api/revendedores.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        // Fecha o modal principal
        var myModalEl = document.getElementById('modal_master');
        var modal = bootstrap.Modal.getInstance(myModalEl);
        modal.hide();

        // Mostra o alerta de sucesso/erro
        SweetAlert3(data.title, data.msg, data.icon);

        // Se a API mandar abrir um modal de informação, faz isso
        if (data.show_info_modal) {
            const infoModalEl = document.getElementById(data.show_info_modal);
            const copyTextEl = infoModalEl.querySelector('[id$="ParaCopiar"]');
            
            copyTextEl.textContent = data.copy_text;
            copyTextEl.setAttribute('data-copy-text', data.copy_text);
            
            new bootstrap.Modal(infoModalEl).show();
        }

        // Recarrega a tabela para mostrar os dados atualizados
        $('#data_table').DataTable().ajax.reload();
    })
    .catch(error => {
        console.error('Erro no formulário:', error);
        SweetAlert3('Erro de Rede!', 'Não foi possível se comunicar com o servidor.', 'error');
    });
}

// Inicializa a tabela DataTables quando a página carrega
$(document).ready(function() {
    $('#data_table').DataTable({
        "processing": true,
        "serverSide": false, // Usaremos o processamento do lado do cliente para simplicidade
        "ajax": {
            "url": "api/revendedores.php?listar_revendedores=1",
            "type": "GET",
            "dataSrc": "data"
        },
        "columns": [
            { "data": "id" },
            { "data": "user" },
            { "data": "creditos", "render": function(data) {
                return parseFloat(data).toFixed(2);
            }},
            { "data": "tipo" },
            { "data": "total_revendedores" },
            { "data": "total_clientes" },
            { 
                "data": null,
                "orderable": false,
                "render": function(data, type, row) {
                    // Cria os botões de ação para cada linha
                    return `
                        <button class="btn btn-success btn-sm" onclick="modal_master('api/revendedores.php', 'add_creditos', '${row.id}')" title="Adicionar Créditos">
                            <i class="fas fa-coins"></i>
                        </button>
                        <button class="btn btn-info btn-sm" onclick="/* modal_master('api/revendedores.php', 'info_revendedor', '${row.id}') */" title="Informações">
                            <i class="fas fa-eye"></i>
                        </button>
                        <button class="btn btn-warning btn-sm" onclick="/* modal_master('api/revendedores.php', 'edit_revendedor', '${row.id}') */" title="Editar">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button class="btn btn-danger btn-sm" onclick="/* modal_master('api/revendedores.php', 'delete_revendedor', '${row.id}') */" title="Excluir">
                            <i class="fas fa-trash"></i>
                        </button>
                    `;
                }
            }
        ],
        "language": { "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese-Brasil.json" }
    });
});