<?php
// Em um ambiente de produção, estas linhas devem ser desativadas.
// É melhor configurar isso no arquivo php.ini do servidor.
// ini_set('display_errors', 0);
// error_reporting(0);

header('Content-Type: application/json');
require_once dirname(__DIR__) . '/controles/db.php';

$data = json_decode(file_get_contents("php://input"), true);

// MELHORIA: Validação consistente usando empty() para todos os campos.
if (empty($data['id']) || empty($data['name']) || empty($data['usuario']) || empty($data['senha']) || empty($data['vencimento'])) {
    http_response_code(400);
    // Usar die() ou exit() após enviar a resposta é uma boa prática.
    die(json_encode(['status' => 'error', 'message' => 'Dados incompletos. Todos os campos são obrigatórios.']));
}

try {
    $pdo = conectar_bd();
    
    // A sua lógica de atualização está perfeita e segura.
    $sql = "UPDATE clientes SET name = :name, usuario = :usuario, senha = :senha, vencimento = :vencimento WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    
    $stmt->execute([
        ':name'       => $data['name'],
        ':usuario'    => $data['usuario'],
        ':senha'      => $data['senha'],
        ':vencimento' => $data['vencimento'],
        ':id'         => $data['id']
    ]);
    
    // Verifica se alguma linha foi realmente alterada.
    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Cliente atualizado com sucesso.']);
    } else {
        // Opcional: Informa se os dados enviados eram iguais aos já existentes.
        echo json_encode(['status' => 'success', 'message' => 'Nenhuma alteração foi necessária.']);
    }

} catch (PDOException $e) {
    // PONTO CRÍTICO DE SEGURANÇA: CORRIGIDO
    // Define o código de erro do servidor.
    http_response_code(500); 
    
    // Envia uma mensagem de erro genérica para o cliente. NUNCA envie $e->getMessage().
    die(json_encode(['status' => 'error', 'message' => 'Ocorreu um erro no servidor ao tentar atualizar o cliente.']));

    // Para seu controle, registre o erro real em um log no servidor.
    // error_log('Erro de atualização no banco de dados: ' . $e->getMessage());
}
?>