<?php
// Arquivo: api/clientes/criar_teste_controlado.php (VERS01O FINAL LIMPA)

header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../controles/db.php'; 

$data = json_decode(file_get_contents('php://input'), true);

if (!isset($data['nome']) || !isset($data['duracao_horas'])) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Dados incompletos. Nome e dura0400o s00o obrigatrios.']);
    exit();
}

try {
    $nome_teste = trim($data['nome']);
    $usuario_enviado = isset($data['usuario']) ? trim($data['usuario']) : '';
    $senha_enviada = isset($data['senha']) ? trim($data['senha']) : '';
    $duracao_horas = filter_var($data['duracao_horas'], FILTER_VALIDATE_INT);

    if (empty($nome_teste) || $duracao_horas === false || $duracao_horas <= 0) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Valores invlidos para nome ou dura0400o.']);
        exit();
    }
    
    $pdo = conectar_bd();

    $usuario_teste = !empty($usuario_enviado) ? $usuario_enviado : 'teste' . rand(1000, 9999);
    $senha_teste = !empty($senha_enviada) ? $senha_enviada : substr(str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789'), 0, 6);

    $dataVenc = new DateTime("now", new DateTimeZone('America/Sao_Paulo'));
    $dataVenc->add(new DateInterval("PT{$duracao_horas}H"));
    $vencimento_formatado = $dataVenc->format('Y-m-d H:i:s');
    
    $sql = "INSERT INTO clientes (name, usuario, senha, Vencimento, Criado_em, is_trial) 
            VALUES (:name, :usuario, :senha, :vencimento, NOW(), 1)";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name' => $nome_teste, 
        ':usuario' => $usuario_teste, 
        ':senha' => $senha_teste, 
        ':vencimento' => $vencimento_formatado
    ]);
    
    $novoId = $pdo->lastInsertId();
    
    echo json_encode(['status' => 'success', 'message' => 'Teste criado com sucesso.', 'novoId' => $novoId]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Ocorreu um erro no servidor ao tentar criar o teste.']);
    // error_log("Erro ao criar teste: " . $e->getMessage());
}
?>