<?php
// Arquivo: api/clientes/excluir.php (VERSÃO CORRETA E SEGURA)

header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../controles/db.php';

// Apenas aceita requisições do tipo POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    die(json_encode(['status' => 'error', 'message' => 'Método não permitido.']));
}

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['id']) || !is_numeric($data['id'])) {
    http_response_code(400); // Bad Request
    die(json_encode(['status' => 'error', 'message' => 'ID do cliente inválido ou não fornecido.']));
}

try {
    $pdo = conectar_bd();
    
    // Deleta o cliente da tabela usando o ID fornecido
    $stmt = $pdo->prepare("DELETE FROM clientes WHERE id = :id");
    $stmt->execute([':id' => $data['id']]);
    
    // Verifica se alguma linha foi realmente deletada
    if ($stmt->rowCount() > 0) {
        echo json_encode(['status' => 'success', 'message' => 'Teste excluído com sucesso.']);
    } else {
        // Se rowCount() for 0, o cliente com aquele ID não foi encontrado
        http_response_code(404); // Not Found
        echo json_encode(['status' => 'error', 'message' => 'Cliente não encontrado.']);
    }

} catch (PDOException $e) {
    http_response_code(500);
    die(json_encode(['status' => 'error', 'message' => 'Erro de servidor ao tentar excluir o cliente.']));
}
?>